/*
 * Decompiled with CFR 0.152.
 */
package com.igrium.craftui.util;

import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public final class RaycastUtils {
    private static final Matrix4f lastProjectionMatrix = new Matrix4f();
    @Nullable
    private static class_4184 lastCamera;

    private RaycastUtils() {
    }

    public static void register() {
        WorldRenderEvents.AFTER_SETUP.register(context -> {
            lastProjectionMatrix.set((Matrix4fc)context.projectionMatrix());
            lastCamera = context.camera();
        });
    }

    public static class_239 raycastViewport(float x, float y, float distance, Predicate<class_1297> predicate, boolean includeFluids) {
        class_1041 window = class_310.method_1551().method_22683();
        return RaycastUtils.raycastViewport(x, y, window.method_4480(), window.method_4507(), distance, predicate, includeFluids);
    }

    public static class_239 raycastViewport(float x, float y, float width, float height, float distance, Predicate<class_1297> predicate, boolean includeFluids) {
        class_1297 cameraEntity = class_310.method_1551().method_1560();
        if (cameraEntity == null) {
            throw new IllegalStateException("No camera entity");
        }
        if (lastCamera == null) {
            throw new IllegalStateException("No frame has been rendered yet.");
        }
        class_243 start = lastCamera.method_19326();
        class_243 end = RaycastUtils.projectViewportGlobal(x, y, width, height, distance);
        return RaycastUtils.raycast(cameraEntity, start, end, predicate, includeFluids);
    }

    public static class_243 projectViewportGlobal(float x, float y, float width, float height, float distance) {
        if (lastCamera == null) {
            throw new IllegalStateException("No frame has been rendered yet.");
        }
        Vector3f localSpace = RaycastUtils.projectViewport(x, y, width, height, distance, new Vector3f());
        return new class_243((double)localSpace.x + RaycastUtils.lastCamera.method_19326().field_1352, (double)localSpace.y + RaycastUtils.lastCamera.method_19326().field_1351, (double)localSpace.z + RaycastUtils.lastCamera.method_19326().field_1350);
    }

    public static Vector3f projectViewport(float x, float y, float width, float height, float distance, Vector3f dest) {
        if (lastCamera == null) {
            throw new IllegalStateException("No frame has been rendered yet.");
        }
        Vector4f screenspace = new Vector4f(2.0f * x / width - 1.0f, 2.0f * y / height - 1.0f, -1.0f, 1.0f);
        screenspace.y = -screenspace.y;
        Matrix4f cameraProjection = new Matrix4f((Matrix4fc)lastProjectionMatrix);
        cameraProjection.invert();
        cameraProjection.transform(screenspace);
        screenspace.mul(distance);
        screenspace.rotate((Quaternionfc)lastCamera.method_23767());
        dest.set((Vector4fc)screenspace);
        return dest;
    }

    private static class_239 raycast(class_1297 sourceEntity, class_243 start, class_243 end, Predicate<class_1297> predicate, boolean includeFluids) {
        double worldDist;
        double entityDist;
        double distance = start.method_1022(end);
        class_238 box = class_238.method_30048((class_243)start, (double)1.0, (double)1.0, (double)1.0).method_18804(sourceEntity.method_5828(1.0f).method_1021(distance)).method_1009(1.0, 1.0, 1.0);
        class_3965 worldHit = sourceEntity.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17559, includeFluids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, sourceEntity));
        class_3966 entityHit = class_1675.method_18075((class_1297)sourceEntity, (class_243)start, (class_243)end, (class_238)box, predicate, (double)distance);
        if (entityHit != null && (entityDist = start.method_1025(entityHit.method_17784())) < (worldDist = start.method_1025(worldHit.method_17784()))) {
            return entityHit;
        }
        return worldHit;
    }
}

