/*
 * Decompiled with CFR 0.152.
 */
package net.jackson;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.jackson.config.Config;
import net.minecraft.class_1299;
import net.minecraft.class_1541;
import net.minecraft.class_238;
import net.minecraft.class_5575;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class TntLimitClient
implements ClientModInitializer {
    public static final String MOD_ID = "TntCounter";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"TntCounter");
    private final Set<UUID> trackedTnt = new LinkedHashSet<UUID>();
    private int tntCount = 0;
    private static Config config;
    private int lastLoggedCount = 1;
    private static TntLimitClient INSTANCE;
    private long lastUpdateTime = 0L;
    private static final int UPDATE_INTERVAL_MS = 100;
    private class_238 lastRenderBox = null;

    public TntLimitClient() {
        INSTANCE = this;
    }

    public static TntLimitClient getInstance() {
        return INSTANCE;
    }

    public static int getTntToRender() {
        return config.getTntToRender();
    }

    public static void setTntToRender(int value) {
        config.setTntToRender(value);
    }

    public boolean isTrackedTnt(UUID uuid) {
        return this.trackedTnt.contains(uuid);
    }

    public void onInitializeClient() {
        config = Config.load();
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null || client.field_1724 == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastUpdateTime < 100L) {
                return;
            }
            this.lastUpdateTime = currentTime;
            int viewDistance = (Integer)client.field_1690.method_42503().method_41753() * 16;
            class_238 newRenderBox = new class_238(client.field_1724.method_23317() - (double)viewDistance, client.field_1724.method_23318() - (double)viewDistance, client.field_1724.method_23321() - (double)viewDistance, client.field_1724.method_23317() + (double)viewDistance, client.field_1724.method_23318() + (double)viewDistance, client.field_1724.method_23321() + (double)viewDistance);
            if (this.lastRenderBox == null || !this.lastRenderBox.equals((Object)newRenderBox)) {
                this.lastRenderBox = newRenderBox;
            }
            ArrayList currentTnts = new ArrayList(client.field_1687.method_18023((class_5575)class_1299.field_6063, this.lastRenderBox, entity -> true));
            this.trackedTnt.clear();
            this.tntCount = currentTnts.size();
            if (this.tntCount <= config.getTntToRender()) {
                currentTnts.forEach(tnt -> this.trackedTnt.add(tnt.method_5667()));
            } else {
                for (int i = 0; i < config.getTntToRender() && i < currentTnts.size(); ++i) {
                    this.trackedTnt.add(((class_1541)currentTnts.get(i)).method_5667());
                }
            }
            if (this.tntCount != this.lastLoggedCount) {
                this.lastLoggedCount = this.tntCount;
            }
        });
    }

    public boolean shouldRenderParticles(double x, double y, double z) {
        return this.trackedTnt.isEmpty();
    }

    public int getTntCount() {
        return this.tntCount;
    }
}

