/*
 * Decompiled with CFR 0.152.
 */
package net.jackson.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class Config {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("tntlimit.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private int tntToRender = 1;

    public static Config load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                return (Config)GSON.fromJson(Files.readString(CONFIG_PATH), Config.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load TNT Limiter config: " + e.getMessage());
            }
        }
        return new Config();
    }

    public void save() {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save TNT Limiter config: " + e.getMessage());
        }
    }

    public int getTntToRender() {
        return this.tntToRender;
    }

    public void setTntToRender(int value) {
        this.tntToRender = value;
        this.save();
    }
}

