/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow.mixins;

import dev.wuffs.squatgrow.SquatAction;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerMixin {
    @Unique
    boolean squatgrow$wasCrouchingLastTick = false;

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void sg$onTickEnd(CallbackInfo ci) {
        PlayerMixin playerMixin = this;
        if (playerMixin instanceof Player) {
            Player player = (Player)playerMixin;
            boolean crouching = player.isCrouching();
            boolean onGround = player.onGround();
            if (!onGround) {
                return;
            }
            if (!this.squatgrow$wasCrouchingLastTick && crouching) {
                SquatAction.performAction(player.level(), player);
            }
            this.squatgrow$wasCrouchingLastTick = crouching;
        }
    }
}

