/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow;

import com.google.common.collect.ImmutableSet;
import dev.wuffs.squatgrow.SquatGrow;
import dev.wuffs.squatgrow.SquatPlatform;
import dev.wuffs.squatgrow.actions.Action;
import dev.wuffs.squatgrow.actions.ActionContext;
import dev.wuffs.squatgrow.actions.Actions;
import dev.wuffs.squatgrow.config.SquatGrowConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;

public class SquatAction {
    public static void performAction(class_1937 level, class_1657 player) {
        if (level.field_9236) {
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (!SquatGrow.config.allowAdventureTwerking && serverPlayer.field_13974.method_14257() == class_1934.field_9216) {
            return;
        }
        if (!SquatPlatform.isSquatGrowEnabled(serverPlayer)) {
            return;
        }
        Pair<Boolean, List<class_1799>> requirementsTest = SquatAction.passesRequirements(player);
        if (!((Boolean)requirementsTest.getKey()).booleanValue()) {
            return;
        }
        SquatAction.grow(level, (class_3222)player, (List)requirementsTest.getValue());
    }

    public static Pair<Boolean, List<class_1799>> passesRequirements(class_1657 player) {
        ArrayList<class_1799> itemsThatHandleDamage = new ArrayList<class_1799>();
        if (SquatGrow.config.requireHoe) {
            class_1799 matchedItem = SquatAction.getMatchingHeldItem(player, Collections.emptyList(), List.of(class_3489.field_42613));
            if (!matchedItem.method_7960()) {
                itemsThatHandleDamage.add(matchedItem);
                return Pair.of((Object)true, itemsThatHandleDamage);
            }
            return Pair.of((Object)false, itemsThatHandleDamage);
        }
        SquatGrowConfig.Requirements requirements = SquatGrow.config.requirements;
        if (requirements.enabled && SquatGrow.computedRequirements != null) {
            List<class_1799> matchingEquipment;
            if (requirements.heldItemRequirement.isEmpty() && requirements.equipmentRequirement.isEmpty()) {
                return Pair.of((Object)true, itemsThatHandleDamage);
            }
            boolean passesEquipment = false;
            if (!requirements.equipmentRequirement.isEmpty() && (matchingEquipment = SquatAction.matchingEquipmentItem(player.method_37908(), player, SquatGrow.computedRequirements.equipmentRequirementStacks(), SquatGrow.computedRequirements.equipmentRequirementTags())).size() == requirements.equipmentRequirement.size()) {
                itemsThatHandleDamage.addAll(matchingEquipment);
                passesEquipment = true;
            }
            if (!requirements.equipmentRequirement.isEmpty() && !passesEquipment) {
                return Pair.of((Object)false, itemsThatHandleDamage);
            }
            boolean passedHeldItem = false;
            class_1799 matchingHeldItem = SquatAction.getMatchingHeldItem(player, SquatGrow.computedRequirements.heldItemRequirementStacks(), SquatGrow.computedRequirements.heldItemRequirementTags());
            if (!matchingHeldItem.method_7960()) {
                itemsThatHandleDamage.add(matchingHeldItem);
                passedHeldItem = true;
            }
            if (!requirements.heldItemRequirement.isEmpty() && !passedHeldItem) {
                return Pair.of((Object)false, itemsThatHandleDamage);
            }
            return Pair.of((Object)true, itemsThatHandleDamage);
        }
        return Pair.of((Object)true, Collections.emptyList());
    }

    public static void grow(class_1937 level, class_3222 player, List<class_1799> itemsToDamage) {
        class_2338 pos = player.method_24515();
        class_5819 r = level.field_9229;
        ImmutableSet<Action> actions = Actions.get().getActions();
        for (int x = -SquatGrow.config.range; x <= SquatGrow.config.range; ++x) {
            for (int z = -SquatGrow.config.range; z <= SquatGrow.config.range; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    double randomValue = 0.0 + 1.0 * r.method_43058();
                    if ((double)SquatGrow.config.chance < randomValue) continue;
                    boolean didGrow = false;
                    class_2338 offsetLocation = pos.method_10069(x, y, z);
                    class_2680 offsetState = level.method_8320(offsetLocation);
                    if (offsetState.method_26215() || !SquatGrow.allowTwerk(offsetState).booleanValue()) continue;
                    ActionContext context = new ActionContext(level, offsetLocation, offsetState, player.method_6047(), player.method_6079(), (class_1657)player);
                    for (Action action : actions) {
                        if (!action.canApply(context)) continue;
                        didGrow = action.execute(context);
                    }
                    if ((SquatGrow.config.hoeTakesDamage || SquatGrow.config.requirements.requiredItemTakesDamage) && didGrow && !itemsToDamage.isEmpty()) {
                        int durabilityToApply = SquatGrow.config.hoeTakesDamage ? 1 : SquatGrow.config.requirements.durabilityDamage;
                        for (class_1799 item : itemsToDamage) {
                            item.method_7970(durabilityToApply, (class_1309)player, player.method_6058() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
                        }
                    }
                    if (!didGrow) continue;
                    SquatAction.addGrowthParticles((class_3218)level, offsetLocation, player);
                }
            }
        }
    }

    private static void addGrowthParticles(class_3218 level, class_2338 pos, class_3222 player) {
        class_5819 random = level.field_9229;
        int numParticles = 2;
        class_2680 blockstate = level.method_8320(pos);
        if (!blockstate.method_26215()) {
            double d1;
            double d0 = 0.5;
            if (blockstate.method_27852(class_2246.field_10382)) {
                numParticles *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.method_26216((class_1922)level, pos)) {
                pos = pos.method_10084();
                numParticles *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.method_26218((class_1922)level, pos).method_1105(class_2350.class_2351.field_11052);
            }
            int randomPartialCount = random.method_43051(1, numParticles);
            class_2338 immutablePos = pos.method_10062();
            for (int i = 0; i < randomPartialCount; ++i) {
                double d2 = random.method_43059() * 0.2;
                double d3 = random.method_43059() * 0.2;
                double d4 = random.method_43059() * 0.2;
                double randomY = class_3532.method_15350((double)random.method_43058(), (double)0.1, (double)0.5);
                double x = (double)immutablePos.method_10263() + class_3532.method_15350((double)random.method_43058(), (double)-1.0, (double)1.0);
                double y = (double)immutablePos.method_10264() - 0.95 + (d1 + randomY);
                double z = (double)immutablePos.method_10260() + class_3532.method_15350((double)random.method_43058(), (double)-1.0, (double)1.0);
                class_2680 state = level.method_8320(immutablePos);
                if (state.method_26215()) continue;
                level.method_14166(player, (class_2394)class_2398.field_11211, false, x, y, z, numParticles, d2, d3, d4, 0.5);
            }
            level.method_8396(null, immutablePos, class_3417.field_33433, class_3419.field_15250, 0.5f, 1.0f);
        }
    }

    private static class_1799 getMatchingHeldItem(class_1657 player, List<class_1799> itemStacks, List<class_6862<class_1792>> itemTags) {
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        class_1799 matchingItem = SquatAction.compareItemToLists(player.method_37908(), mainHand, itemStacks, itemTags);
        if (!matchingItem.method_7960()) {
            return matchingItem;
        }
        return SquatAction.compareItemToLists(player.method_37908(), offHand, itemStacks, itemTags);
    }

    private static class_1799 compareItemToLists(class_1937 level, class_1799 stack, List<class_1799> itemStacks, List<class_6862<class_1792>> itemTags) {
        for (class_1799 class_17992 : itemStacks) {
            if (!SquatAction.itemStackMatches(level, stack, class_17992)) continue;
            return stack;
        }
        for (class_6862 class_68622 : itemTags) {
            if (!SquatAction.itemStackMatches(level, stack, (class_6862<class_1792>)class_68622)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    private static List<class_1799> matchingEquipmentItem(class_1937 level, class_1657 player, Map<class_1304, class_1799> equipmentStacks, Map<class_1304, class_6862<class_1792>> equipmentTags) {
        class_1799 itemBySlot;
        ArrayList<class_1799> matchedItems = new ArrayList<class_1799>();
        for (Map.Entry<class_1304, class_1799> entry : equipmentStacks.entrySet()) {
            itemBySlot = player.method_6118(entry.getKey());
            if (!SquatAction.itemStackMatches(level, itemBySlot, entry.getValue())) continue;
            matchedItems.add(itemBySlot);
        }
        for (Map.Entry<class_1304, class_1799> entry : equipmentTags.entrySet()) {
            itemBySlot = player.method_6118(entry.getKey());
            if (!SquatAction.itemStackMatches(level, itemBySlot, (class_6862<class_1792>)((class_6862)entry.getValue()))) continue;
            matchedItems.add(itemBySlot);
        }
        return matchedItems;
    }

    private static boolean itemStackMatches(class_1937 level, class_1799 stack, class_6862<class_1792> tag) {
        class_9304 itemEnchantments;
        class_1887 enchantmentValue;
        if (SquatGrow.computedEnchantment != null && stack.method_7923() && (enchantmentValue = SquatGrow.computedEnchantment.get((class_1936)level)) != null && stack.method_31573(tag) && (itemEnchantments = (class_9304)stack.method_57824(class_9334.field_49633)) != null) {
            return stack.method_31573(tag) && itemEnchantments.method_57536(class_6880.method_40223((Object)enchantmentValue)) > 0;
        }
        return stack.method_31573(tag);
    }

    private static boolean itemStackMatches(class_1937 level, class_1799 stack, class_1799 item) {
        class_9304 itemEnchantments;
        class_1887 enchantmentValue;
        if (SquatGrow.computedEnchantment != null && stack.method_7923() && (enchantmentValue = SquatGrow.computedEnchantment.get((class_1936)level)) != null && stack.method_31574(item.method_7909()) && (itemEnchantments = (class_9304)stack.method_57824(class_9334.field_49633)) != null) {
            return itemEnchantments.method_57536(class_6880.method_40223((Object)enchantmentValue)) > 0;
        }
        return stack.method_31574(item.method_7909());
    }
}

