/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.wuffs.squatgrow.SquatGrowClient;
import dev.wuffs.squatgrow.SquatPlatform;
import dev.wuffs.squatgrow.actions.Actions;
import dev.wuffs.squatgrow.config.ComputedRequirements;
import dev.wuffs.squatgrow.config.SquatGrowConfig;
import dev.wuffs.squatgrow.network.SquatGrowEnabledPacket;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.YamlConfigSerializer;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_4013;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SquatGrow {
    public static final String MOD_ID = "squatgrow";
    private static final Logger LOGGER = LoggerFactory.getLogger(SquatGrow.class);
    public static SquatGrowConfig config;
    public static ConfigHolder<SquatGrowConfig> configHolder;
    public static final Set<class_6862<class_2248>> tagCache;
    public static final Set<String> wildcardCache;
    public static ComputedRequirements computedRequirements;
    public static LazyLevelDependentValue<class_1887> computedEnchantment;

    public static void init() {
        configHolder = AutoConfig.register(SquatGrowConfig.class, YamlConfigSerializer::new);
        configHolder.registerLoadListener(SquatGrow::onConfigChanged);
        configHolder.registerSaveListener(SquatGrow::onConfigChanged);
        configHolder.load();
        config = (SquatGrowConfig)configHolder.get();
        if (Platform.getEnv() == EnvType.CLIENT) {
            SquatGrowClient.init();
        }
        LifecycleEvent.SETUP.register(SquatGrow::onSetup);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)new ReloadHandler());
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SquatGrowEnabledPacket.TYPE, SquatGrowEnabledPacket.CODEC, (packet, context) -> context.queue(() -> SquatPlatform.setSquatGrowEnabled((class_3222)context.getPlayer())));
    }

    private static void onSetup() {
        LOGGER.debug("Starting setup");
        Actions.get().setup();
    }

    private static class_1269 onConfigChanged(ConfigHolder<SquatGrowConfig> holder, SquatGrowConfig newConfig) {
        tagCache.clear();
        wildcardCache.clear();
        tagCache.addAll(newConfig.ignoreList.stream().filter(e -> e.contains("#")).map(e -> class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_12829((String)e.replace("#", "")))).collect(Collectors.toSet()));
        wildcardCache.addAll(newConfig.ignoreList.stream().filter(e -> e.contains("*")).map(e -> e.split(":")[0]).collect(Collectors.toSet()));
        List<String> heldItemRequirement = newConfig.requirements.heldItemRequirement;
        Map<class_1304, String> equipmentRequirement = newConfig.requirements.equipmentRequirement;
        Pair<List<class_1799>, List<class_6862<class_1792>>> computedHeldEntries = SquatGrow.computeItemsAndTagsFromStringList(heldItemRequirement);
        Map<class_1304, class_1799> equipmentRequirementStacks = equipmentRequirement.entrySet().stream().filter(e -> !((String)e.getValue()).contains("#")).collect(Collectors.toMap(Map.Entry::getKey, e -> new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_12829((String)((String)e.getValue()))))));
        Map<class_1304, class_6862<class_1792>> equipmentRequirementTags = equipmentRequirement.entrySet().stream().filter(e -> ((String)e.getValue()).contains("#")).collect(Collectors.toMap(Map.Entry::getKey, e -> class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_12829((String)((String)e.getValue()).replace("#", "")))));
        computedRequirements = new ComputedRequirements((List)computedHeldEntries.getLeft(), (List)computedHeldEntries.getRight(), equipmentRequirementStacks, equipmentRequirementTags);
        if (!newConfig.requirements.requiredEnchantment.isEmpty()) {
            class_2960 enchantmentRl = class_2960.method_12829((String)newConfig.requirements.requiredEnchantment);
            computedEnchantment = new LazyLevelDependentValue<class_1887>(accessor -> {
                class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)enchantmentRl);
                try {
                    class_5455 registryAccess = accessor.method_30349();
                    class_6880.class_6883 enchantmentHolder = registryAccess.method_46762(class_7924.field_41265).method_46747(key);
                    return (class_1887)enchantmentHolder.comp_349();
                }
                catch (Exception e) {
                    LOGGER.error("Enchantment {} not found, falling back to null", (Object)enchantmentRl);
                    computedEnchantment = null;
                    return null;
                }
            });
        } else {
            computedEnchantment = null;
        }
        return class_1269.field_5812;
    }

    public static Boolean allowTwerk(class_2680 state) {
        return SquatGrow.config.useWhitelist == SquatGrow.isBlockInIgnoreList(state);
    }

    private static boolean isBlockInIgnoreList(class_2680 state) {
        class_2960 resourceLocation = state.method_26204().arch$registryName();
        if (resourceLocation == null) {
            return false;
        }
        if (SquatGrow.config.ignoreList.contains(resourceLocation.toString()) || wildcardCache.contains(resourceLocation.method_12836())) {
            return true;
        }
        return tagCache.stream().anyMatch(arg_0 -> ((class_2680)state).method_26164(arg_0));
    }

    private static Pair<List<class_1799>, List<class_6862<class_1792>>> computeItemsAndTagsFromStringList(List<String> list) {
        List<class_1799> stacks = list.stream().filter(e -> !e.contains("#")).map(e -> new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_12829((String)e)))).toList();
        List<class_6862> tags = list.stream().filter(e -> e.contains("#")).map(e -> class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_12829((String)e.replace("#", "")))).toList();
        return Pair.of(stacks, tags);
    }

    static {
        tagCache = new HashSet<class_6862<class_2248>>();
        wildcardCache = new HashSet<String>();
        computedRequirements = null;
        computedEnchantment = null;
    }

    static class ReloadHandler
    implements class_4013 {
        ReloadHandler() {
        }

        public void method_14491(class_3300 manager) {
            configHolder.load();
            config = (SquatGrowConfig)configHolder.get();
        }
    }

    public static class LazyLevelDependentValue<T> {
        @Nullable
        private T value = null;
        private Function<class_1936, T> supplier;

        public LazyLevelDependentValue(Function<class_1936, T> supplier) {
            this.supplier = supplier;
        }

        public T get(class_1936 accessor) {
            if (this.value == null) {
                this.value = this.supplier.apply(accessor);
            }
            if (this.value == null) {
                throw new IllegalStateException("Value not initialized");
            }
            return this.value;
        }
    }
}

