/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.class_1304;

@Config(name="squatgrow-common")
public class SquatGrowConfig
implements ConfigData {
    @Comment(value="Enable debug logging")
    public boolean debug = false;
    @Comment(value="Require hoe to allow growth, LEGACY, PLEASE SWITCH TO THE NEW SYSTEM, SEE REQUIREMENTS")
    public boolean requireHoe = false;
    @Comment(value="Hoe takes damage on growth, LEGACY, PLEASE SWITCH TO THE NEW SYSTEM, SEE REQUIREMENTS")
    public boolean hoeTakesDamage = false;
    @Comment(value="Use whitelist instead of blacklist, default false")
    public boolean useWhitelist = false;
    @Comment(value="Range of effect, warning: this can cause lag if set too high")
    @ConfigEntry.BoundedDiscrete(min=0L, max=16L)
    public int range = 3;
    @Comment(value="Growth chance")
    public float chance = 0.5f;
    @Comment(value="Don't use! Use randomTickMultiplier instead, this is here for backwards compatibility")
    @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
    public int sugarcaneMultiplier = 4;
    @Comment(value="Random tick multiplier, this is the amount of times the mod will call the randomTick method on the block for each block in the range")
    @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
    public int randomTickMultiplier = 4;
    @Comment(value="List of blocks to blacklist/whitelist from twerking, Tags can be used by using #minecraft:<tag_name> or #modid:<tag_name>")
    public List<String> ignoreList = new ArrayList<String>(Arrays.asList("minecraft:grass_block", "minecraft:grass", "minecraft:short_grass", "minecraft:tall_grass", "minecraft:netherrack", "minecraft:warped_nylium", "minecraft:crimson_nylium"));
    @Comment(value="Allow twerking in adventure mode, default true")
    public boolean allowAdventureTwerking = true;
    @Comment(value="Enable Mystical Crops")
    public boolean enableMysticalCrops = true;
    @Comment(value="Enable AE2 accelerator")
    public boolean enableAE2Accelerator = true;
    @Comment(value="AE2 growth multiplier, only available if AE2 is present")
    @ConfigEntry.BoundedDiscrete(min=1L, max=16L)
    public int ae2Multiplier = 4;
    @Comment(value="When the player is holding a grass block in their offhand, they will be able to randomly convert dirt into grass")
    public boolean enableDirtToGrass = true;
    @ConfigEntry.Category(value="requirements")
    @Comment(value="Requirements for growing")
    public Requirements requirements = new Requirements();

    public static class Requirements {
        @Comment(value="Enabled the new requirements system")
        public boolean enabled = true;
        @Comment(value="List of blocks that require a hoe to grow, leave empty to disable")
        public List<String> heldItemRequirement = new ArrayList<String>();
        @Comment(value="Map of equipment slots to items required to grow, leave empty to disable")
        public Map<class_1304, String> equipmentRequirement = Map.of();
        @Comment(value="Durability based items take damage when used to grow")
        public boolean requiredItemTakesDamage = false;
        @Comment(value="Amount of damage to take when used to grow")
        public int durabilityDamage = 1;
        @Comment(value="Enchantment required to grow, leave empty to disable\n")
        public String requiredEnchantment = "";
    }
}

