/*
 * Decompiled with CFR 0.152.
 */
package com.tarlaboratories.portalgun;

import com.mojang.logging.LogUtils;
import com.tarlaboratories.portalgun.ApertureStoneCable;
import com.tarlaboratories.portalgun.portalgun;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.IEnergyStorage;
import org.slf4j.Logger;

public class ApertureStoneSourceBlockEntity
extends BlockEntity
implements IEnergyStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    public int signal_strength = 0;
    public int signal_strength_cap = 1000;
    public int capacity = 1000000;
    public int energy = 0;
    public Set<BlockPos> connected_devices = new HashSet<BlockPos>();

    public ApertureStoneSourceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)portalgun.APERTURESTONE_SOURCE_BLOCKENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity_) {
        ApertureStoneSourceBlockEntity blockEntity = (ApertureStoneSourceBlockEntity)blockEntity_;
        blockEntity.signal_strength = Math.min(blockEntity.energy, blockEntity.signal_strength_cap) - blockEntity.connected_devices.size() * 100;
        blockEntity.signal_strength = Math.max(blockEntity.signal_strength, 0);
        blockEntity.energy -= blockEntity.signal_strength;
        if (ApertureStoneCable.canConnectApertureStone(level.m_8055_(pos.m_7494_())).booleanValue()) {
            ApertureStoneCable.setSignalStrength((LevelAccessor)level, pos.m_7494_(), blockEntity.signal_strength, Direction.DOWN, new HashSet<BlockPos>(), pos);
        }
        if (ApertureStoneCable.canConnectApertureStone(level.m_8055_(pos.m_7495_())).booleanValue()) {
            ApertureStoneCable.setSignalStrength((LevelAccessor)level, pos.m_7495_(), blockEntity.signal_strength, Direction.UP, new HashSet<BlockPos>(), pos);
        }
        if (ApertureStoneCable.canConnectApertureStone(level.m_8055_(pos.m_122012_())).booleanValue()) {
            ApertureStoneCable.setSignalStrength((LevelAccessor)level, pos.m_122012_(), blockEntity.signal_strength, Direction.SOUTH, new HashSet<BlockPos>(), pos);
        }
        if (ApertureStoneCable.canConnectApertureStone(level.m_8055_(pos.m_122019_())).booleanValue()) {
            ApertureStoneCable.setSignalStrength((LevelAccessor)level, pos.m_122019_(), blockEntity.signal_strength, Direction.NORTH, new HashSet<BlockPos>(), pos);
        }
        if (ApertureStoneCable.canConnectApertureStone(level.m_8055_(pos.m_122029_())).booleanValue()) {
            ApertureStoneCable.setSignalStrength((LevelAccessor)level, pos.m_122029_(), blockEntity.signal_strength, Direction.WEST, new HashSet<BlockPos>(), pos);
        }
        if (ApertureStoneCable.canConnectApertureStone(level.m_8055_(pos.m_122024_())).booleanValue()) {
            ApertureStoneCable.setSignalStrength((LevelAccessor)level, pos.m_122024_(), blockEntity.signal_strength, Direction.EAST, new HashSet<BlockPos>(), pos);
        }
    }

    public void m_142466_(CompoundTag tag) {
        this.signal_strength = tag.m_128451_("signal_strength");
        this.signal_strength_cap = tag.m_128451_("signal_strength_cap");
        this.energy = tag.m_128451_("energy");
        this.capacity = tag.m_128451_("capacity");
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("signal_strength", this.signal_strength);
        tag.m_128405_("signal_strength_cap", this.signal_strength_cap);
        tag.m_128405_("energy", this.energy);
        tag.m_128405_("capacity", this.capacity);
        super.m_183515_(tag);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(this.capacity - this.energy, maxReceive);
        if (!simulate) {
            this.energy += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

