/*
 * Decompiled with CFR 0.152.
 */
package com.tarlaboratories.portalgun;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="portalgun", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> PORTALABLE_BLOCK_STRINGS = BUILDER.comment("A list of (non-)portalable blocks.").defineListAllowEmpty("portalable_blocks", List.of(), Config::validateBlockName);
    private static final ForgeConfigSpec.BooleanValue IS_WHITELIST_MODE = BUILDER.comment("Whether the list of (non-)portalable blocks is for portalable blocks or non-portalable blocks.").define("is_whitelist_mode", false);
    private static final ForgeConfigSpec.ConfigValue<Integer> EMANCIPATION_GRID_EMITTER_RANGE = BUILDER.comment("The maximum amount blocks can be between two emancipation grid emitters for them to function").define("emancipation_grid_emitter_range", (Object)16);
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean logDirtBlock;
    public static int magicNumber;
    public static String magicNumberIntroduction;
    public static Set<Item> items;
    public static Set<Block> portalable_blocks;
    public static boolean is_whitelist_mode;
    public static int emancipation_grid_emitter_range;

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName = (String)obj));
    }

    private static boolean validateBlockName(Object obj) {
        String blockName;
        return obj instanceof String && ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockName = (String)obj));
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        emancipation_grid_emitter_range = (Integer)EMANCIPATION_GRID_EMITTER_RANGE.get();
        portalable_blocks = ((List)PORTALABLE_BLOCK_STRINGS.get()).stream().map(blockName -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName))).collect(Collectors.toSet());
    }
}

