/*
 * Decompiled with CFR 0.152.
 */
package com.tarlaboratories.portalgun;

import com.mojang.logging.LogUtils;
import com.tarlaboratories.portalgun.Config;
import com.tarlaboratories.portalgun.EmancipationGridBlock;
import com.tarlaboratories.portalgun.PortalGunItem;
import com.tarlaboratories.portalgun.portalgun;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class EmancipationGridEmitter
extends Block {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DirectionProperty FACE = DirectionProperty.m_156003_((String)"face");
    public static final BooleanProperty IS_ACTIVE = BooleanProperty.m_61465_((String)"is_active");
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.m_61587_((String)"axis", Direction.Axis.class);
    public static final VoxelShape NORTH_FACE_EMITTER_VERTICAL = EmancipationGridEmitter.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)1.0);
    public static final VoxelShape NORTH_FACE_EMITTER_HORIZONTAL = EmancipationGridEmitter.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)1.0);
    public static final VoxelShape SOUTH_FACE_EMITTER_VERTICAL = EmancipationGridEmitter.m_49796_((double)6.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_FACE_EMITTER_HORIZONTAL = EmancipationGridEmitter.m_49796_((double)0.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0, (double)16.0);
    public static final VoxelShape EAST_FACE_EMITTER_VERTICAL = EmancipationGridEmitter.m_49796_((double)15.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    public static final VoxelShape EAST_FACE_EMITTER_HORIZONTAL = EmancipationGridEmitter.m_49796_((double)15.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    public static final VoxelShape WEST_FACE_EMITTER_VERTICAL = EmancipationGridEmitter.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)1.0, (double)16.0, (double)10.0);
    public static final VoxelShape WEST_FACE_EMITTER_HORIZONTAL = EmancipationGridEmitter.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0);
    public static final VoxelShape DOWN_FACE_EMITTER_X = EmancipationGridEmitter.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)1.0, (double)16.0);
    public static final VoxelShape DOWN_FACE_EMITTER_Z = EmancipationGridEmitter.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)1.0, (double)10.0);
    public static final VoxelShape UP_FACE_EMITTER_X = EmancipationGridEmitter.m_49796_((double)6.0, (double)15.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    public static final VoxelShape UP_FACE_EMITTER_Z = EmancipationGridEmitter.m_49796_((double)0.0, (double)15.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    public static final VoxelShape EMANCIPATION_GRID_X = EmancipationGridEmitter.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    public static final VoxelShape EMANCIPATION_GRID_Y = EmancipationGridEmitter.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    public static final VoxelShape EMANCIPATION_GRID_Z = EmancipationGridEmitter.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public EmancipationGridEmitter(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACE, (Comparable)Direction.NORTH)).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACE, AXIS, IS_ACTIVE}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction.Axis axis = null;
        Vec3 player_pos = context.m_43723_().m_20182_();
        BlockPos block_pos = context.m_8083_();
        Vec3 distance = new Vec3(Math.abs((double)block_pos.m_123341_() - player_pos.f_82479_), Math.abs((double)block_pos.m_123342_() - player_pos.f_82480_), Math.abs((double)block_pos.m_123343_() - player_pos.f_82481_));
        state = (BlockState)state.m_61124_((Property)FACE, (Comparable)context.m_43719_().m_122424_());
        switch ((Direction)state.m_61143_((Property)FACE)) {
            case NORTH: {
                if (distance.f_82480_ >= distance.f_82479_ && distance.f_82480_ >= distance.f_82481_) {
                    axis = Direction.Axis.Y;
                    break;
                }
                axis = Direction.Axis.X;
                break;
            }
            case SOUTH: {
                if (distance.f_82480_ >= distance.f_82479_ && distance.f_82480_ >= distance.f_82481_) {
                    axis = Direction.Axis.Y;
                    break;
                }
                axis = Direction.Axis.X;
                break;
            }
            case EAST: {
                if (distance.f_82480_ >= distance.f_82479_ && distance.f_82480_ >= distance.f_82481_) {
                    axis = Direction.Axis.Y;
                    break;
                }
                axis = Direction.Axis.Z;
                break;
            }
            case WEST: {
                if (distance.f_82480_ >= distance.f_82479_ && distance.f_82480_ >= distance.f_82481_) {
                    axis = Direction.Axis.Y;
                    break;
                }
                axis = Direction.Axis.Z;
                break;
            }
            case UP: {
                if (distance.f_82479_ >= distance.f_82481_) {
                    axis = Direction.Axis.X;
                    break;
                }
                axis = Direction.Axis.Z;
                break;
            }
            case DOWN: {
                axis = distance.f_82479_ >= distance.f_82481_ ? Direction.Axis.X : Direction.Axis.Z;
            }
        }
        state = (BlockState)state.m_61124_(AXIS, axis);
        state = this.m_7417_(state, null, null, (LevelAccessor)context.m_43725_(), block_pos, null);
        return state;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state2, LevelAccessor level, BlockPos pos, BlockPos pos2) {
        if (!level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACE)).m_122424_())).m_60713_((Block)portalgun.EMANCIPATION_GRID_BLOCK.get())) {
            state = (BlockState)state.m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        EmancipationGridEmitter.deactivate(state, (LevelAccessor)level, pos);
    }

    public static VoxelShape calculateShape(Direction face, Direction.Axis axis, Boolean is_active) {
        VoxelShape shape = null;
        switch (face) {
            case NORTH: {
                if (axis == Direction.Axis.Y) {
                    shape = NORTH_FACE_EMITTER_HORIZONTAL;
                    break;
                }
                shape = NORTH_FACE_EMITTER_VERTICAL;
                break;
            }
            case SOUTH: {
                if (axis == Direction.Axis.Y) {
                    shape = SOUTH_FACE_EMITTER_HORIZONTAL;
                    break;
                }
                shape = SOUTH_FACE_EMITTER_VERTICAL;
                break;
            }
            case EAST: {
                if (axis == Direction.Axis.Y) {
                    shape = EAST_FACE_EMITTER_HORIZONTAL;
                    break;
                }
                shape = EAST_FACE_EMITTER_VERTICAL;
                break;
            }
            case WEST: {
                if (axis == Direction.Axis.Y) {
                    shape = WEST_FACE_EMITTER_HORIZONTAL;
                    break;
                }
                shape = WEST_FACE_EMITTER_VERTICAL;
                break;
            }
            case UP: {
                if (axis == Direction.Axis.X) {
                    shape = UP_FACE_EMITTER_X;
                    break;
                }
                shape = UP_FACE_EMITTER_Z;
                break;
            }
            case DOWN: {
                shape = axis == Direction.Axis.X ? DOWN_FACE_EMITTER_X : DOWN_FACE_EMITTER_Z;
            }
        }
        if (is_active.booleanValue()) {
            switch (axis) {
                case X: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)EMANCIPATION_GRID_X, (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case Y: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)EMANCIPATION_GRID_Y, (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case Z: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)EMANCIPATION_GRID_Z, (BooleanOp)BooleanOp.f_82695_);
                }
            }
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return EmancipationGridEmitter.calculateShape((Direction)state.m_61143_((Property)FACE), (Direction.Axis)state.m_61143_(AXIS), (Boolean)state.m_61143_((Property)IS_ACTIVE));
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter getter, BlockPos pos) {
        return this.m_5940_(state, getter, pos, null);
    }

    public static boolean tryActivate(BlockState state, LevelAccessor level, BlockPos pos) {
        int i;
        if (level.m_5776_()) {
            return false;
        }
        if (level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACE)).m_122424_())).m_60713_((Block)portalgun.EMANCIPATION_GRID_BLOCK.get())) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(true)), 15);
            return true;
        }
        int dist = 0;
        BlockPos tmp_pos = pos;
        for (i = 0; i < Config.emancipation_grid_emitter_range; ++i) {
            tmp_pos = tmp_pos.m_121945_(((Direction)state.m_61143_((Property)FACE)).m_122424_());
            ++dist;
            if (level.m_8055_(tmp_pos).m_60713_((Block)portalgun.EMANCIPATION_GRID_EMITTER.get())) break;
            if (EmancipationGridEmitter.canReplaceWithGrid(level.m_8055_(tmp_pos))) continue;
            return false;
        }
        if (!level.m_8055_(tmp_pos).m_60713_((Block)portalgun.EMANCIPATION_GRID_EMITTER.get())) {
            return false;
        }
        if (level.m_8055_(tmp_pos).m_61143_((Property)FACE) != ((Direction)state.m_61143_((Property)FACE)).m_122424_()) {
            return false;
        }
        if (level.m_8055_(tmp_pos).m_61143_(AXIS) != state.m_61143_(AXIS)) {
            return false;
        }
        tmp_pos = pos;
        for (i = 0; i < dist - 1; ++i) {
            tmp_pos = tmp_pos.m_121945_(((Direction)state.m_61143_((Property)FACE)).m_122424_());
            level.m_7731_(tmp_pos, (BlockState)((Block)portalgun.EMANCIPATION_GRID_BLOCK.get()).m_49966_().m_61124_(EmancipationGridBlock.AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS))), 15);
        }
        level.m_7731_(tmp_pos.m_121945_(((Direction)state.m_61143_((Property)FACE)).m_122424_()), (BlockState)((BlockState)state.m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACE, (Comparable)((Direction)state.m_61143_((Property)FACE)).m_122424_()), 15);
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(true)), 15);
        return true;
    }

    public static void deactivate(BlockState state, LevelAccessor level, BlockPos pos) {
        if (!((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue()) {
            return;
        }
        BlockPos tmp_pos = pos;
        for (int i = 0; i < Config.emancipation_grid_emitter_range && level.m_8055_(tmp_pos = tmp_pos.m_121945_(((Direction)state.m_61143_((Property)FACE)).m_122424_())).m_60713_((Block)portalgun.EMANCIPATION_GRID_BLOCK.get()); ++i) {
            level.m_7731_(tmp_pos, Blocks.f_50016_.m_49966_(), 15);
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false)), 15);
    }

    public static boolean canReplaceWithGrid(BlockState state) {
        return state.m_247087_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        List<EntityType> emancipated_entites = List.of((EntityType)portalgun.WEIGHTED_CUBE_ENTITYTYPE.get(), (EntityType)portalgun.COMPANION_CUBE_ENTITYTYPE.get(), (EntityType)portalgun.REDIRECTION_CUBE_ENTITYTYPE.get());
        if (!((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue()) {
            return;
        }
        if (entity.m_6095_() == EntityType.f_20532_) {
            Player player = (Player)entity;
            for (ItemStack itemstack : player.m_150109_().f_35974_) {
                if (!itemstack.m_150930_((Item)portalgun.PORTAL_GUN_ITEM.get())) continue;
                PortalGunItem.clearPortals(level, itemstack);
            }
        } else if (emancipated_entites.contains(entity.m_6095_())) {
            entity.m_142687_(Entity.RemovalReason.KILLED);
        }
    }
}

