/*
 * Decompiled with CFR 0.152.
 */
package com.tarlaboratories.portalgun;

import com.tarlaboratories.portalgun.AnyBlockEmitter;
import com.tarlaboratories.portalgun.EmancipationGridEmitter;
import com.tarlaboratories.portalgun.HardLightBridge;
import com.tarlaboratories.portalgun.portalgun;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HardLightBridgeEmitter
extends AnyBlockEmitter {
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.m_61587_((String)"axis", Direction.Axis.class);
    public static final Function<BlockState, BlockState> getStateForEmmition = state -> (BlockState)((Block)portalgun.HARD_LIGHT_BRIDGE.get()).m_49966_().m_61124_(HardLightBridge.AXIS, (Comparable)((Direction.Axis)state.m_61143_(AXIS)));
    public static final VoxelShape HARD_LIGHT_BRIDGE_X = HardLightBridgeEmitter.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    public static final VoxelShape HARD_LIGHT_BRIDGE_Y = HardLightBridgeEmitter.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    public static final VoxelShape HARD_LIGHT_BRIDGE_Z = HardLightBridgeEmitter.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)3.0);
    public static final VoxelShape NORTH_FACE_EMITTER_VERTICAL = HardLightBridgeEmitter.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)1.0);
    public static final VoxelShape NORTH_FACE_EMITTER_HORIZONTAL = HardLightBridgeEmitter.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)1.0);
    public static final VoxelShape SOUTH_FACE_EMITTER_VERTICAL = HardLightBridgeEmitter.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_FACE_EMITTER_HORIZONTAL = HardLightBridgeEmitter.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape EAST_FACE_EMITTER_VERTICAL = HardLightBridgeEmitter.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    public static final VoxelShape EAST_FACE_EMITTER_HORIZONTAL = HardLightBridgeEmitter.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape WEST_FACE_EMITTER_VERTICAL = HardLightBridgeEmitter.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)4.0);
    public static final VoxelShape WEST_FACE_EMITTER_HORIZONTAL = HardLightBridgeEmitter.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)4.0, (double)16.0);
    public static final VoxelShape DOWN_FACE_EMITTER_X = HardLightBridgeEmitter.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)1.0, (double)16.0);
    public static final VoxelShape DOWN_FACE_EMITTER_Z = HardLightBridgeEmitter.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)4.0);
    public static final VoxelShape UP_FACE_EMITTER_X = HardLightBridgeEmitter.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    public static final VoxelShape UP_FACE_EMITTER_Z = HardLightBridgeEmitter.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);

    public HardLightBridgeEmitter(BlockBehaviour.Properties properties) {
        super(properties, getStateForEmmition);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{AXIS}));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        this.deactivate((LevelAccessor)level, pos);
    }

    public static VoxelShape calculateShape(Direction face, Direction.Axis axis, Boolean is_active) {
        VoxelShape shape = null;
        face = face.m_122424_();
        switch (face) {
            case NORTH: {
                if (axis == Direction.Axis.Y) {
                    shape = NORTH_FACE_EMITTER_HORIZONTAL;
                    break;
                }
                shape = NORTH_FACE_EMITTER_VERTICAL;
                break;
            }
            case SOUTH: {
                if (axis == Direction.Axis.Y) {
                    shape = SOUTH_FACE_EMITTER_HORIZONTAL;
                    break;
                }
                shape = SOUTH_FACE_EMITTER_VERTICAL;
                break;
            }
            case EAST: {
                if (axis == Direction.Axis.Y) {
                    shape = EAST_FACE_EMITTER_HORIZONTAL;
                    break;
                }
                shape = EAST_FACE_EMITTER_VERTICAL;
                break;
            }
            case WEST: {
                if (axis == Direction.Axis.Y) {
                    shape = WEST_FACE_EMITTER_HORIZONTAL;
                    break;
                }
                shape = WEST_FACE_EMITTER_VERTICAL;
                break;
            }
            case UP: {
                if (axis == Direction.Axis.X) {
                    shape = UP_FACE_EMITTER_X;
                    break;
                }
                shape = UP_FACE_EMITTER_Z;
                break;
            }
            case DOWN: {
                shape = axis == Direction.Axis.X ? DOWN_FACE_EMITTER_X : DOWN_FACE_EMITTER_Z;
            }
        }
        if (is_active.booleanValue()) {
            switch (axis) {
                case X: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)HARD_LIGHT_BRIDGE_X, (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case Y: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)HARD_LIGHT_BRIDGE_Y, (BooleanOp)BooleanOp.f_82695_);
                    break;
                }
                case Z: {
                    shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)HARD_LIGHT_BRIDGE_Z, (BooleanOp)BooleanOp.f_82695_);
                }
            }
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return HardLightBridgeEmitter.calculateShape((Direction)state.m_61143_((Property)FACING), (Direction.Axis)state.m_61143_(AXIS), (Boolean)state.m_61143_((Property)IS_ACTIVE));
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter getter, BlockPos pos) {
        return this.m_5940_(state, getter, pos, null);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction.Axis axis = null;
        Vec3 player_pos = context.m_43723_().m_20182_();
        BlockPos block_pos = context.m_8083_();
        Vec3 distance = new Vec3(Math.abs((double)block_pos.m_123341_() - player_pos.f_82479_), Math.abs((double)block_pos.m_123342_() - player_pos.f_82480_), Math.abs((double)block_pos.m_123343_() - player_pos.f_82481_));
        state = (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_43719_());
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                if (distance.f_82480_ >= distance.f_82479_ && distance.f_82480_ >= distance.f_82481_) {
                    axis = Direction.Axis.Y;
                    break;
                }
                axis = Direction.Axis.X;
                break;
            }
            case SOUTH: {
                if (distance.f_82480_ >= distance.f_82479_ && distance.f_82480_ >= distance.f_82481_) {
                    axis = Direction.Axis.Y;
                    break;
                }
                axis = Direction.Axis.X;
                break;
            }
            case EAST: {
                if (distance.f_82480_ >= distance.f_82479_ && distance.f_82480_ >= distance.f_82481_) {
                    axis = Direction.Axis.Y;
                    break;
                }
                axis = Direction.Axis.Z;
                break;
            }
            case WEST: {
                if (distance.f_82480_ >= distance.f_82479_ && distance.f_82480_ >= distance.f_82481_) {
                    axis = Direction.Axis.Y;
                    break;
                }
                axis = Direction.Axis.Z;
                break;
            }
            case UP: {
                if (distance.f_82479_ >= distance.f_82481_) {
                    axis = Direction.Axis.X;
                    break;
                }
                axis = Direction.Axis.Z;
                break;
            }
            case DOWN: {
                axis = distance.f_82479_ >= distance.f_82481_ ? Direction.Axis.X : Direction.Axis.Z;
            }
        }
        state = (BlockState)state.m_61124_(EmancipationGridEmitter.AXIS, axis);
        return state;
    }
}

