/*
 * Decompiled with CFR 0.152.
 */
package com.tarlaboratories.portalgun;

import com.mojang.logging.LogUtils;
import com.tarlaboratories.portalgun.PortalBlockBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.slf4j.Logger;

public class PortalBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACE = DirectionProperty.m_156003_((String)"face");
    public static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");
    public static final BooleanProperty IS_ORANGE = BooleanProperty.m_61465_((String)"is_orange");
    public static final BooleanProperty IS_ACTIVE = BooleanProperty.m_61465_((String)"is_active");
    private static final VoxelShape INSIDE = PortalBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape UP_PANE = PortalBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_PANE = PortalBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape EAST_PANE = PortalBlock.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_PANE = PortalBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_PANE = PortalBlock.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_PANE = PortalBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape START_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)INSIDE, (BooleanOp)BooleanOp.f_82685_);
    private BlockPos target_block_pos = null;
    private BlockState replaced_block = null;
    private static final Logger LOGGER = LogUtils.getLogger();

    public PortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACE, (Comparable)Direction.EAST)).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)IS_ORANGE, (Comparable)Boolean.valueOf(true))).m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACE, FACING, IS_ORANGE, IS_ACTIVE}));
    }

    public Class<PortalBlockBlockEntity> getBlockEntityClass() {
        return PortalBlockBlockEntity.class;
    }

    public VoxelShape m_5940_(BlockState p_151964_, BlockGetter p_151965_, BlockPos p_151966_, CollisionContext p_151967_) {
        VoxelShape shape = START_SHAPE;
        switch ((Direction)p_151964_.m_61143_((Property)FACE)) {
            case DOWN: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)DOWN_PANE, (BooleanOp)BooleanOp.f_82685_);
                break;
            }
            case EAST: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)EAST_PANE, (BooleanOp)BooleanOp.f_82685_);
                break;
            }
            case NORTH: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)NORTH_PANE, (BooleanOp)BooleanOp.f_82685_);
                break;
            }
            case SOUTH: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SOUTH_PANE, (BooleanOp)BooleanOp.f_82685_);
                break;
            }
            case UP: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)UP_PANE, (BooleanOp)BooleanOp.f_82685_);
                break;
            }
            case WEST: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)WEST_PANE, (BooleanOp)BooleanOp.f_82685_);
            }
        }
        switch ((Direction)p_151964_.m_61143_((Property)FACING)) {
            case DOWN: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)DOWN_PANE, (BooleanOp)BooleanOp.f_82685_);
                break;
            }
            case EAST: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)EAST_PANE, (BooleanOp)BooleanOp.f_82685_);
                break;
            }
            case NORTH: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)NORTH_PANE, (BooleanOp)BooleanOp.f_82685_);
                break;
            }
            case SOUTH: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)SOUTH_PANE, (BooleanOp)BooleanOp.f_82685_);
                break;
            }
            case UP: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)UP_PANE, (BooleanOp)BooleanOp.f_82685_);
                break;
            }
            case WEST: {
                shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)WEST_PANE, (BooleanOp)BooleanOp.f_82685_);
            }
        }
        return shape;
    }

    public VoxelShape m_6079_(BlockState p_151955_, BlockGetter p_151956_, BlockPos p_151957_) {
        return INSIDE;
    }

    public PortalBlockBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PortalBlockBlockEntity(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        long distance_x = context.m_8083_().m_123341_() - context.m_43723_().m_146903_();
        long distance_y = context.m_8083_().m_123342_() - context.m_43723_().m_146904_();
        long distance_z = context.m_8083_().m_123343_() - context.m_43723_().m_146907_();
        state = Math.abs(distance_x) >= Math.abs(distance_z) ? (distance_x > 0L ? (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.WEST) : (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.EAST)) : (distance_z > 0L ? (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.NORTH) : (BlockState)state.m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
        state.m_61124_((Property)FACE, (Comparable)context.m_43719_());
        return state;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        try {
            BlockPos link_pos;
            if (entity.m_20092_()) {
                return;
            }
            if (!((Boolean)state.m_61143_((Property)IS_ACTIVE)).booleanValue()) {
                return;
            }
            ServerLevel serverlevel = null;
            long chunk = 0L;
            if (!level.m_46749_(pos) & !level.f_46443_) {
                serverlevel = (ServerLevel)level;
                chunk = new ChunkPos(pos).m_45588_();
                ForgeChunkManager.forceChunk((ServerLevel)serverlevel, (String)"portalgun", (BlockPos)pos, (int)((int)chunk), (int)((int)(chunk >> 32)), (boolean)true, (boolean)false);
            }
            if ((link_pos = ((PortalBlockBlockEntity)level.m_7702_((BlockPos)pos)).link_pos) == null) {
                return;
            }
            if (entity.m_6095_() == EntityType.f_20532_) {
                entity = (Player)entity;
            }
            entity.m_146884_(link_pos.m_121945_((Direction)level.m_8055_(link_pos).m_61143_((Property)FACE)).m_121945_((Direction)level.m_8055_(link_pos).m_61143_((Property)FACING)).m_252807_());
            float old_rotation = entity.m_146908_();
            Vec3 emv = entity.m_20184_();
            switch ((Direction)state.m_61143_((Property)FACE)) {
                case DOWN: {
                    emv = new Vec3(emv.f_82479_, emv.f_82481_, -emv.f_82480_);
                    break;
                }
                case EAST: {
                    entity.m_146922_(entity.m_7890_(Rotation.CLOCKWISE_90));
                    emv = new Vec3(-emv.f_82481_, emv.f_82480_, emv.f_82479_);
                    break;
                }
                case NORTH: {
                    entity.m_146922_(entity.m_7890_(Rotation.CLOCKWISE_180));
                    emv = new Vec3(-emv.f_82479_, emv.f_82480_, -emv.f_82481_);
                    break;
                }
                case SOUTH: {
                    break;
                }
                case UP: {
                    emv = new Vec3(emv.f_82479_, -emv.f_82481_, emv.f_82480_);
                    break;
                }
                case WEST: {
                    entity.m_146922_(entity.m_7890_(Rotation.COUNTERCLOCKWISE_90));
                    emv = new Vec3(emv.f_82481_, emv.f_82480_, -emv.f_82479_);
                }
            }
            switch ((Direction)level.m_8055_(link_pos).m_61143_((Property)FACE)) {
                case DOWN: {
                    entity.m_246847_(0.0, -1.0, 0.0);
                    emv = new Vec3(emv.f_82479_, emv.f_82481_, -emv.f_82480_);
                    break;
                }
                case EAST: {
                    entity.m_146922_(entity.m_7890_(Rotation.CLOCKWISE_90));
                    emv = new Vec3(-emv.f_82481_, emv.f_82480_, emv.f_82479_);
                    break;
                }
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    entity.m_146922_(entity.m_7890_(Rotation.CLOCKWISE_180));
                    emv = new Vec3(-emv.f_82479_, emv.f_82480_, -emv.f_82481_);
                    break;
                }
                case UP: {
                    emv = new Vec3(emv.f_82479_, -emv.f_82481_, emv.f_82480_);
                    break;
                }
                case WEST: {
                    entity.m_146922_(entity.m_7890_(Rotation.COUNTERCLOCKWISE_90));
                    emv = new Vec3(emv.f_82481_, emv.f_82480_, -emv.f_82479_);
                }
            }
            entity.m_20256_(emv);
            entity.m_287199_(1);
            if (serverlevel != null) {
                ForgeChunkManager.forceChunk((ServerLevel)serverlevel, (String)"portalgun", (BlockPos)pos, (int)((int)chunk), (int)((int)(chunk >> 32)), (boolean)false, (boolean)false);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            e.printStackTrace();
        }
    }
}

