/*
 * Decompiled with CFR 0.152.
 */
package com.tarlaboratories.portalgun;

import com.mojang.logging.LogUtils;
import com.tarlaboratories.portalgun.LaserCatcher;
import com.tarlaboratories.portalgun.PortalBlock;
import com.tarlaboratories.portalgun.portalgun;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class PortalBlockBlockEntity
extends BlockEntity {
    public BlockPos link_pos;
    public BlockState replaced_block_blockstate;
    private static final Logger LOGGER = LogUtils.getLogger();

    public PortalBlockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)portalgun.PORTAL_BLOCK_BLOCKSTATE.get(), pos, state);
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> S setValueHelper(S p_129205_, Property<T> p_129206_, String p_129207_, CompoundTag p_129208_, CompoundTag p_129209_) {
        Optional optional = p_129206_.m_6215_(p_129208_.m_128461_(p_129207_));
        if (optional.isPresent()) {
            return (S)((StateHolder)p_129205_.m_61124_(p_129206_, (Comparable)optional.get()));
        }
        LOGGER.warn("Unable to read property: {} with value: {} for blockstate: {}", new Object[]{p_129207_, p_129208_.m_128461_(p_129207_), p_129209_});
        return p_129205_;
    }

    protected BlockState readBlockState(CompoundTag tag) {
        if (!tag.m_128425_("Name", 8)) {
            return Blocks.f_50016_.m_49966_();
        }
        ResourceLocation resourcelocation = new ResourceLocation(tag.m_128461_("Name"));
        Block block = (Block)RegistryObject.create((ResourceLocation)resourcelocation, (IForgeRegistry)ForgeRegistries.BLOCKS).get();
        BlockState blockstate = block.m_49966_();
        if (tag.m_128425_("Properties", 10)) {
            CompoundTag compoundtag = tag.m_128469_("Properties");
            StateDefinition statedefinition = block.m_49965_();
            for (String s : compoundtag.m_128431_()) {
                Property property = statedefinition.m_61081_(s);
                if (property == null) continue;
                blockstate = PortalBlockBlockEntity.setValueHelper(blockstate, property, s, compoundtag, tag);
            }
        }
        return blockstate;
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("link_pos")) {
            this.link_pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("link_pos"));
        }
        if (tag.m_128441_("replaced_block_blockstate")) {
            this.replaced_block_blockstate = this.readBlockState(tag.m_128469_("replaced_block_blockstate"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        if (this.link_pos != null) {
            tag.m_128365_("link_pos", (Tag)NbtUtils.m_129224_((BlockPos)this.link_pos));
        }
        if (this.replaced_block_blockstate != null) {
            tag.m_128365_("replaced_block_blockstate", (Tag)NbtUtils.m_129202_((BlockState)this.replaced_block_blockstate));
        }
    }

    public PortalBlockBlockEntity setReplacedBlock(BlockState replaced_block) {
        this.replaced_block_blockstate = replaced_block;
        this.m_6596_();
        return this;
    }

    public PortalBlockBlockEntity setLinkPos(BlockPos pos) {
        this.link_pos = pos;
        this.m_6596_();
        return this;
    }

    public void removePortal() {
        if (this.replaced_block_blockstate == null) {
            return;
        }
        ServerLevel serverlevel = null;
        long chunk = 0L;
        if (this.f_58857_ != null & !this.f_58857_.f_46443_) {
            serverlevel = (ServerLevel)this.f_58857_;
            chunk = new ChunkPos(this.f_58858_).m_45588_();
            ForgeChunkManager.forceChunk((ServerLevel)serverlevel, (String)"portalgun", (BlockPos)this.f_58858_, (int)((int)chunk), (int)((int)(chunk >> 32)), (boolean)true, (boolean)false);
        }
        this.destroyHardLightBridge();
        this.destroyLaser();
        this.f_58857_.m_46597_(this.f_58858_, this.replaced_block_blockstate);
        if (serverlevel != null) {
            ForgeChunkManager.forceChunk((ServerLevel)serverlevel, (String)"portalgun", (BlockPos)this.f_58858_, (int)((int)chunk), (int)((int)(chunk >> 32)), (boolean)false, (boolean)false);
        }
    }

    public void destroyHardLightBridge() {
        if (this.f_58857_.m_8055_(this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)PortalBlock.FACE))).m_60713_((Block)portalgun.HARD_LIGHT_BRIDGE.get())) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            Direction direction = (Direction)state.m_61143_((Property)PortalBlock.FACE);
            BlockPos tmp_pos = this.f_58858_.m_121945_(direction);
            while (this.f_58857_.m_8055_(tmp_pos).m_60713_((Block)portalgun.HARD_LIGHT_BRIDGE.get())) {
                this.f_58857_.m_7731_(tmp_pos, Blocks.f_50016_.m_49966_(), 15);
                if (!this.f_58857_.m_8055_(tmp_pos = tmp_pos.m_121945_(direction)).m_60713_((Block)portalgun.PORTAL_BLOCK.get())) continue;
                if (direction != ((Direction)this.f_58857_.m_8055_(tmp_pos).m_61143_((Property)PortalBlock.FACE)).m_122424_()) break;
                tmp_pos = ((PortalBlockBlockEntity)this.f_58857_.m_7702_((BlockPos)tmp_pos)).link_pos;
                direction = (Direction)this.f_58857_.m_8055_(tmp_pos).m_61143_((Property)PortalBlock.FACE);
                tmp_pos = tmp_pos.m_121945_(direction);
            }
        }
    }

    public void destroyLaser() {
        if (this.f_58857_.m_8055_(this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)PortalBlock.FACE))).m_60713_((Block)portalgun.LASER_BLOCK.get())) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            Direction direction = (Direction)state.m_61143_((Property)PortalBlock.FACE);
            BlockPos tmp_pos = this.f_58858_.m_121945_(direction);
            while (this.f_58857_.m_8055_(tmp_pos).m_60713_((Block)portalgun.LASER_BLOCK.get())) {
                this.f_58857_.m_7731_(tmp_pos, Blocks.f_50016_.m_49966_(), 15);
                tmp_pos = tmp_pos.m_121945_(direction);
                if (this.f_58857_.m_8055_(tmp_pos).m_60713_((Block)portalgun.PORTAL_BLOCK.get())) {
                    if (direction != ((Direction)this.f_58857_.m_8055_(tmp_pos).m_61143_((Property)PortalBlock.FACE)).m_122424_()) break;
                    tmp_pos = ((PortalBlockBlockEntity)this.f_58857_.m_7702_((BlockPos)tmp_pos)).link_pos;
                    direction = (Direction)this.f_58857_.m_8055_(tmp_pos).m_61143_((Property)PortalBlock.FACE);
                    tmp_pos = tmp_pos.m_121945_(direction);
                    continue;
                }
                if (!this.f_58857_.m_8055_(tmp_pos).m_60713_((Block)portalgun.LASER_CATCHER.get())) continue;
                this.f_58857_.m_7731_(tmp_pos, (BlockState)this.f_58857_.m_8055_(tmp_pos).m_61124_((Property)LaserCatcher.ACTIVE, (Comparable)Boolean.valueOf(false)), 0);
            }
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("link_pos", (Tag)NbtUtils.m_129224_((BlockPos)this.link_pos));
        tag.m_128365_("replaced_block", (Tag)NbtUtils.m_129202_((BlockState)this.replaced_block_blockstate));
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.link_pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("link_pos"));
        this.replaced_block_blockstate = this.readBlockState(tag.m_128469_("replaced_block"));
    }
}

