/*
 * Decompiled with CFR 0.152.
 */
package com.tarlaboratories.portalgun;

import com.mojang.logging.LogUtils;
import com.tarlaboratories.portalgun.Config;
import com.tarlaboratories.portalgun.PortalBlock;
import com.tarlaboratories.portalgun.PortalBlockBlockEntity;
import com.tarlaboratories.portalgun.portalgun;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class PortalGunItem
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();

    public PortalGunItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> shootPortal(Level level, Player player, InteractionHand hand, boolean is_leftclick) {
        try {
            CompoundTag tag = player.m_21120_(hand).m_41784_();
            BlockEntity ORANGE_PORTAL_BLOCKENTITY = null;
            BlockEntity BLUE_PORTAL_BLOCKENTITY = null;
            BlockEntityType PORTAL_BLOCK_ENTITY_TYPE = (BlockEntityType)RegistryObject.create((ResourceLocation)new ResourceLocation("portalgun:portal_block_blockentity"), (IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES).get();
            if (tag.m_128441_("orange_portal_pos")) {
                ORANGE_PORTAL_BLOCKENTITY = level.m_7702_(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("orange_portal_pos")));
            }
            if (tag.m_128441_("blue_portal_pos")) {
                BLUE_PORTAL_BLOCKENTITY = level.m_7702_(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("blue_portal_pos")));
            }
            if (ORANGE_PORTAL_BLOCKENTITY != null) {
                ((PortalBlockBlockEntity)ORANGE_PORTAL_BLOCKENTITY).destroyHardLightBridge();
                ((PortalBlockBlockEntity)ORANGE_PORTAL_BLOCKENTITY).destroyLaser();
            }
            if (BLUE_PORTAL_BLOCKENTITY != null) {
                ((PortalBlockBlockEntity)BLUE_PORTAL_BLOCKENTITY).destroyHardLightBridge();
                ((PortalBlockBlockEntity)ORANGE_PORTAL_BLOCKENTITY).destroyLaser();
            }
            HitResult res = player.m_19907_(6000.0, 0.0f, false);
            BlockHitResult res_block = (BlockHitResult)res;
            RegistryObject PORTAL_BLOCK = RegistryObject.create((ResourceLocation)new ResourceLocation("portalgun:portal_block"), (IForgeRegistry)ForgeRegistries.BLOCKS);
            BlockState PORTAL_BLOCKSTATE = (BlockState)((PortalBlock)((Object)PORTAL_BLOCK.get())).m_5573_(new BlockPlaceContext(player, hand, this.m_7968_(), res_block)).m_61124_((Property)PortalBlock.FACE, (Comparable)res_block.m_82434_());
            if (PORTAL_BLOCKSTATE.m_61143_((Property)PortalBlock.FACE) != Direction.UP & PORTAL_BLOCKSTATE.m_61143_((Property)PortalBlock.FACE) != Direction.DOWN) {
                PORTAL_BLOCKSTATE = (BlockState)PORTAL_BLOCKSTATE.m_61124_((Property)PortalBlock.FACING, (Comparable)Direction.DOWN);
            }
            if (res_block != null & this.canPlacePortal(res_block.m_82425_(), (Direction)PORTAL_BLOCKSTATE.m_61143_((Property)PortalBlock.FACE), (Direction)PORTAL_BLOCKSTATE.m_61143_((Property)PortalBlock.FACING), level)) {
                if (ORANGE_PORTAL_BLOCKENTITY != null & !is_leftclick & !tag.m_128441_("only_blue")) {
                    ((PortalBlockBlockEntity)ORANGE_PORTAL_BLOCKENTITY).removePortal();
                    ((PortalBlockBlockEntity)level.m_7702_(ORANGE_PORTAL_BLOCKENTITY.m_58899_().m_121945_((Direction)ORANGE_PORTAL_BLOCKENTITY.m_58900_().m_61143_((Property)PortalBlock.FACING)))).removePortal();
                }
                if (BLUE_PORTAL_BLOCKENTITY != null & (is_leftclick | tag.m_128441_("only_blue"))) {
                    ((PortalBlockBlockEntity)BLUE_PORTAL_BLOCKENTITY).removePortal();
                    ((PortalBlockBlockEntity)level.m_7702_(BLUE_PORTAL_BLOCKENTITY.m_58899_().m_121945_((Direction)BLUE_PORTAL_BLOCKENTITY.m_58900_().m_61143_((Property)PortalBlock.FACING)))).removePortal();
                }
                if (!is_leftclick & !tag.m_128441_("only_blue")) {
                    tag.m_128365_("orange_portal_pos", (Tag)NbtUtils.m_129224_((BlockPos)res_block.m_82425_()));
                }
                if (is_leftclick | tag.m_128441_("only_blue")) {
                    tag.m_128365_("blue_portal_pos", (Tag)NbtUtils.m_129224_((BlockPos)res_block.m_82425_()));
                }
                BlockState old_block_state = level.m_8055_(res_block.m_82425_());
                BlockState old_blockstate2 = level.m_8055_(res_block.m_82425_().m_121945_((Direction)PORTAL_BLOCKSTATE.m_61143_((Property)PortalBlock.FACING)));
                if (is_leftclick | tag.m_128441_("only_blue")) {
                    PORTAL_BLOCKSTATE = (BlockState)PORTAL_BLOCKSTATE.m_61124_((Property)PortalBlock.IS_ORANGE, (Comparable)Boolean.valueOf(false));
                }
                BlockState second_portal_block = (BlockState)PORTAL_BLOCKSTATE.m_61124_((Property)PortalBlock.FACING, (Comparable)((Direction)PORTAL_BLOCKSTATE.m_61143_((Property)PortalBlock.FACING)).m_122424_());
                level.m_46597_(res_block.m_82425_(), PORTAL_BLOCKSTATE);
                level.m_46597_(res_block.m_82425_().m_121945_((Direction)PORTAL_BLOCKSTATE.m_61143_((Property)PortalBlock.FACING)), second_portal_block);
                PortalBlockBlockEntity res_portal_block_entity = ((PortalBlock)PORTAL_BLOCKSTATE.m_60734_()).newBlockEntity(res_block.m_82425_(), PORTAL_BLOCKSTATE);
                PortalBlockBlockEntity res_portal_blockentity2 = ((PortalBlock)second_portal_block.m_60734_()).newBlockEntity(res_block.m_82425_().m_121945_((Direction)PORTAL_BLOCKSTATE.m_61143_((Property)PortalBlock.FACING)), second_portal_block);
                if (BLUE_PORTAL_BLOCKENTITY != null & !is_leftclick & !tag.m_128441_("only_blue")) {
                    res_portal_block_entity.setLinkPos(BLUE_PORTAL_BLOCKENTITY.m_58899_());
                    res_portal_blockentity2.setLinkPos(BLUE_PORTAL_BLOCKENTITY.m_58899_());
                    ((PortalBlockBlockEntity)BLUE_PORTAL_BLOCKENTITY).setLinkPos(res_portal_block_entity.m_58899_());
                    ((PortalBlockBlockEntity)level.m_7702_(BLUE_PORTAL_BLOCKENTITY.m_58899_().m_121945_((Direction)BLUE_PORTAL_BLOCKENTITY.m_58900_().m_61143_((Property)PortalBlock.FACING)))).setLinkPos(res_portal_block_entity.m_58899_());
                    level.m_46597_(res_portal_block_entity.m_58899_(), (BlockState)res_portal_block_entity.m_58900_().m_61124_((Property)PortalBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(res_portal_blockentity2.m_58899_(), (BlockState)res_portal_blockentity2.m_58900_().m_61124_((Property)PortalBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(BLUE_PORTAL_BLOCKENTITY.m_58899_(), (BlockState)BLUE_PORTAL_BLOCKENTITY.m_58900_().m_61124_((Property)PortalBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(BLUE_PORTAL_BLOCKENTITY.m_58899_().m_121945_((Direction)BLUE_PORTAL_BLOCKENTITY.m_58900_().m_61143_((Property)PortalBlock.FACING)), (BlockState)level.m_7702_(BLUE_PORTAL_BLOCKENTITY.m_58899_().m_121945_((Direction)BLUE_PORTAL_BLOCKENTITY.m_58900_().m_61143_((Property)PortalBlock.FACING))).m_58900_().m_61124_((Property)PortalBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                }
                if (ORANGE_PORTAL_BLOCKENTITY != null & (is_leftclick | tag.m_128441_("only_blue"))) {
                    res_portal_block_entity.setLinkPos(ORANGE_PORTAL_BLOCKENTITY.m_58899_());
                    res_portal_blockentity2.setLinkPos(ORANGE_PORTAL_BLOCKENTITY.m_58899_());
                    ((PortalBlockBlockEntity)ORANGE_PORTAL_BLOCKENTITY).setLinkPos(res_portal_block_entity.m_58899_());
                    ((PortalBlockBlockEntity)level.m_7702_(ORANGE_PORTAL_BLOCKENTITY.m_58899_().m_121945_((Direction)ORANGE_PORTAL_BLOCKENTITY.m_58900_().m_61143_((Property)PortalBlock.FACING)))).setLinkPos(res_portal_block_entity.m_58899_());
                    level.m_46597_(res_portal_block_entity.m_58899_(), (BlockState)res_portal_block_entity.m_58900_().m_61124_((Property)PortalBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(res_portal_blockentity2.m_58899_(), (BlockState)res_portal_blockentity2.m_58900_().m_61124_((Property)PortalBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(ORANGE_PORTAL_BLOCKENTITY.m_58899_(), (BlockState)ORANGE_PORTAL_BLOCKENTITY.m_58900_().m_61124_((Property)PortalBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                    level.m_46597_(ORANGE_PORTAL_BLOCKENTITY.m_58899_().m_121945_((Direction)ORANGE_PORTAL_BLOCKENTITY.m_58900_().m_61143_((Property)PortalBlock.FACING)), (BlockState)level.m_7702_(ORANGE_PORTAL_BLOCKENTITY.m_58899_().m_121945_((Direction)ORANGE_PORTAL_BLOCKENTITY.m_58900_().m_61143_((Property)PortalBlock.FACING))).m_58900_().m_61124_((Property)PortalBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(true)));
                }
                res_portal_block_entity.setReplacedBlock(old_block_state);
                res_portal_blockentity2.setReplacedBlock(old_blockstate2);
                level.m_151523_((BlockEntity)res_portal_block_entity);
                level.m_151523_((BlockEntity)res_portal_blockentity2);
                player.m_21120_(hand).m_41751_(tag);
                player.m_36335_().m_41524_((Item)this, 5);
                return super.m_7203_(level, player, hand);
            }
            player.m_5661_((Component)Component.m_237115_((String)"Cannot place portal here!"), true);
        }
        catch (Exception e) {
            player.m_5661_((Component)Component.m_237115_((String)"An error has occured! Couldn't place portal"), true);
            LOGGER.error("An exception has occured while trying to place portal: {}", (Object)e.toString());
            e.printStackTrace();
        }
        return super.m_7203_(level, player, hand);
    }

    protected boolean canPlacePortal(BlockPos pos, Direction face, Direction facing, Level level) {
        return this.isPortalable(level.m_8055_(pos).m_60734_()) & this.isPortalable(level.m_8055_(pos.m_121945_(facing)).m_60734_()) & this.canBeInFrontOfPortal(level.m_8055_(pos.m_121945_(face))) & this.canBeInFrontOfPortal(level.m_8055_(pos.m_121945_(facing).m_121945_(face)));
    }

    protected boolean isPortalable(Block block) {
        List<Block> cannot_place_portal_on = List.of(Blocks.f_50016_, Blocks.f_50627_, Blocks.f_50626_, (Block)portalgun.PORTAL_BLOCK.get(), (Block)portalgun.EMANCIPATION_GRID_BLOCK.get(), (Block)portalgun.EMANCIPATION_GRID_EMITTER.get(), (Block)portalgun.APERTURESTONE_CABLE.get(), (Block)portalgun.APERTURESTONE_CABLE_ENCASED.get(), (Block)portalgun.APERTURESTONE_INDICATOR.get(), (Block)portalgun.APERTURESTONE_LOGIC_GATE.get(), (Block)portalgun.APERTURESTONE_REDSTONE_SWITCH.get(), (Block)portalgun.APERTURESTONE_SOURCE.get(), (Block)portalgun.CREATIVE_APERTURESTONE_SOURCE.get(), (Block)portalgun.WEIGHTED_CUBE_DROPPER.get(), (Block)portalgun.COMPANION_CUBE_DROPPER.get(), (Block)portalgun.HARD_LIGHT_BRIDGE_EMITTER.get(), (Block)portalgun.HARD_LIGHT_BRIDGE.get(), (Block)portalgun.LASER_CATCHER.get(), (Block)portalgun.LASER_EMITTER.get(), (Block)portalgun.LASER_BLOCK.get());
        return (Config.portalable_blocks.contains(block) ^ !Config.is_whitelist_mode) & !cannot_place_portal_on.contains(block);
    }

    public static void clearPortals(Level level, ItemStack item) {
        CompoundTag tag = item.m_41784_();
        BlockEntity ORANGE_PORTAL_BLOCKENTITY = null;
        BlockEntity BLUE_PORTAL_BLOCKENTITY = null;
        if (tag.m_128441_("orange_portal_pos") & !tag.m_128441_("only_blue")) {
            ORANGE_PORTAL_BLOCKENTITY = level.m_7702_(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("orange_portal_pos")));
        }
        if (tag.m_128441_("blue_portal_pos")) {
            BLUE_PORTAL_BLOCKENTITY = level.m_7702_(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("blue_portal_pos")));
        }
        if (ORANGE_PORTAL_BLOCKENTITY != null) {
            ((PortalBlockBlockEntity)level.m_7702_(ORANGE_PORTAL_BLOCKENTITY.m_58899_().m_121945_((Direction)ORANGE_PORTAL_BLOCKENTITY.m_58900_().m_61143_((Property)PortalBlock.FACING)))).removePortal();
            ((PortalBlockBlockEntity)ORANGE_PORTAL_BLOCKENTITY).removePortal();
        }
        if (BLUE_PORTAL_BLOCKENTITY != null) {
            ((PortalBlockBlockEntity)level.m_7702_(BLUE_PORTAL_BLOCKENTITY.m_58899_().m_121945_((Direction)BLUE_PORTAL_BLOCKENTITY.m_58900_().m_61143_((Property)PortalBlock.FACING)))).removePortal();
            ((PortalBlockBlockEntity)BLUE_PORTAL_BLOCKENTITY).removePortal();
        }
        if (!tag.m_128441_("only_blue")) {
            tag.m_128473_("orange_portal_pos");
        }
        tag.m_128473_("blue_portal_pos");
        item.m_41751_(tag);
    }

    @SubscribeEvent
    public static void EntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        if (entity.m_6095_() != EntityType.f_20532_) {
            return;
        }
        Player player = (Player)entity;
        for (ItemStack item : player.m_150109_().f_35974_) {
            if (!item.m_150930_((Item)portalgun.PORTAL_GUN_ITEM.get())) continue;
            PortalGunItem.clearPortals(level, item);
        }
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResult onLeftClick(Player player, InteractionHand hand) {
        Level level = player.m_9236_();
        return this.shootPortal(level, player, hand, true).m_19089_();
    }

    public InteractionResult onRightClick(Player player, InteractionHand hand) {
        Level level = player.m_9236_();
        return this.shootPortal(level, player, hand, false).m_19089_();
    }

    @SubscribeEvent
    public void LeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        LOGGER.info("left click!!!1!!1!!!1");
        if (event.getItemStack().m_150930_((Item)portalgun.PORTAL_GUN_ITEM.get())) {
            this.onLeftClick(event.getEntity(), event.getHand());
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            return new InteractionResultHolder(this.onLeftClick(player, hand), (Object)player.m_21120_(hand));
        }
        return new InteractionResultHolder(this.onRightClick(player, hand), (Object)player.m_21120_(hand));
    }

    protected boolean canBeInFrontOfPortal(BlockState state) {
        if (state.m_247087_()) {
            return true;
        }
        if (state.m_60713_((Block)portalgun.HARD_LIGHT_BRIDGE.get())) {
            return true;
        }
        if (state.m_60713_((Block)portalgun.HARD_LIGHT_BRIDGE_EMITTER.get())) {
            return true;
        }
        return state.m_60713_((Block)portalgun.LASER_BLOCK.get());
    }
}

