/*
 * Decompiled with CFR 0.152.
 */
package com.tarlaboratories.portalgun;

import com.mojang.logging.LogUtils;
import com.tarlaboratories.portalgun.WeightedCube;
import com.tarlaboratories.portalgun.portalgun;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class PressureButton
extends Block {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final DirectionProperty FACE = DirectionProperty.m_156003_((String)"face");
    public static final VoxelShape MAIN_SHAPE_DOWN = Shapes.m_83113_((VoxelShape)PressureButton.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)PressureButton.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape BUTTON_SHAPE_DOWN = PressureButton.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);
    public static final VoxelShape BUTTON_COLLISION_DOWN = PressureButton.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    public static final VoxelShape MAIN_SHAPE_UP = Shapes.m_83113_((VoxelShape)PressureButton.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)PressureButton.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape BUTTON_SHAPE_UP = PressureButton.m_49796_((double)2.0, (double)13.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public static final VoxelShape BUTTON_COLLISION_UP = PressureButton.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);
    public static final VoxelShape MAIN_SHAPE_NORTH = Shapes.m_83113_((VoxelShape)PressureButton.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), (VoxelShape)PressureButton.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)2.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape BUTTON_SHAPE_NORTH = PressureButton.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)3.0);
    public static final VoxelShape BUTTON_COLLISION_NORTH = PressureButton.m_49796_((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0, (double)4.0);
    public static final VoxelShape MAIN_SHAPE_SOUTH = Shapes.m_83113_((VoxelShape)PressureButton.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)PressureButton.m_49796_((double)1.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape BUTTON_SHAPE_SOUTH = PressureButton.m_49796_((double)2.0, (double)2.0, (double)13.0, (double)14.0, (double)14.0, (double)14.0);
    public static final VoxelShape BUTTON_COLLISION_SOUTH = PressureButton.m_49796_((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0, (double)14.0);
    public static final VoxelShape MAIN_SHAPE_WEST = Shapes.m_83113_((VoxelShape)PressureButton.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), (VoxelShape)PressureButton.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape BUTTON_SHAPE_WEST = PressureButton.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)3.0, (double)14.0, (double)14.0);
    public static final VoxelShape BUTTON_COLLISION_WEST = PressureButton.m_49796_((double)2.0, (double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0);
    public static final VoxelShape MAIN_SHAPE_EAST = Shapes.m_83113_((VoxelShape)PressureButton.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)PressureButton.m_49796_((double)14.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), (BooleanOp)BooleanOp.f_82695_);
    public static final VoxelShape BUTTON_SHAPE_EAST = PressureButton.m_49796_((double)13.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);
    public static final VoxelShape BUTTON_COLLISION_EAST = PressureButton.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0);

    public PressureButton(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{POWERED, FACE}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        List<VoxelShape> shapes = PressureButton.getShapesForFace((Direction)state.m_61143_((Property)FACE));
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return shapes.get(0);
        }
        return Shapes.m_83113_((VoxelShape)shapes.get(0), (VoxelShape)shapes.get(1), (BooleanOp)BooleanOp.f_82695_);
    }

    public static List<VoxelShape> getShapesForFace(Direction face) {
        switch (face) {
            case DOWN: {
                return List.of(MAIN_SHAPE_DOWN, BUTTON_SHAPE_DOWN, BUTTON_COLLISION_DOWN);
            }
            case UP: {
                return List.of(MAIN_SHAPE_UP, BUTTON_SHAPE_UP, BUTTON_COLLISION_UP);
            }
            case NORTH: {
                return List.of(MAIN_SHAPE_NORTH, BUTTON_SHAPE_NORTH, BUTTON_COLLISION_NORTH);
            }
            case SOUTH: {
                return List.of(MAIN_SHAPE_SOUTH, BUTTON_SHAPE_SOUTH, BUTTON_COLLISION_SOUTH);
            }
            case EAST: {
                return List.of(MAIN_SHAPE_EAST, BUTTON_SHAPE_EAST, BUTTON_COLLISION_EAST);
            }
            case WEST: {
                return List.of(MAIN_SHAPE_WEST, BUTTON_SHAPE_WEST, BUTTON_COLLISION_WEST);
            }
        }
        return List.of();
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter getter, BlockPos pos) {
        return this.m_5940_(state, getter, pos, null);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACE, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    private boolean isColliding(VoxelShape shape, Entity entity, BlockPos pos) {
        VoxelShape positionedShape = shape.m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        return Shapes.m_83157_((VoxelShape)positionedShape, (VoxelShape)Shapes.m_83064_((AABB)entity.m_20191_()), (BooleanOp)BooleanOp.f_82689_);
    }

    public void m_7892_(BlockState state, Level level_, BlockPos pos, Entity entity_) {
        List<VoxelShape> shapes = PressureButton.getShapesForFace((Direction)state.m_61143_((Property)FACE));
        Boolean flag = false;
        if (level_.f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)level_;
        List<EntityType> allowedEntities = List.of(EntityType.f_20532_, (EntityType)portalgun.WEIGHTED_CUBE_ENTITYTYPE.get(), (EntityType)portalgun.COMPANION_CUBE_ENTITYTYPE.get());
        for (Entity entity : level.m_8583_()) {
            if (entity.m_213877_() || !allowedEntities.contains(entity.m_6095_())) continue;
            if (this.isColliding(shapes.get(2), entity, pos)) {
                if (entity.m_6095_() == portalgun.WEIGHTED_CUBE_ENTITYTYPE.get()) {
                    entity.m_20088_().m_135381_(WeightedCube.ACTIVATED, (Object)true);
                }
                flag = true;
                break;
            }
            if (entity.m_6095_() != portalgun.WEIGHTED_CUBE_ENTITYTYPE.get()) continue;
            entity.m_20088_().m_135381_(WeightedCube.ACTIVATED, (Object)false);
        }
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)flag));
    }

    public int m_6378_(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }
}

