/*
 * Decompiled with CFR 0.152.
 */
package com.tarlaboratories.portalgun;

import com.mojang.logging.LogUtils;
import com.tarlaboratories.portalgun.portalgun;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class WeightedCube
extends Entity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EntityDataAccessor<Boolean> ACTIVATED = SynchedEntityData.m_135353_(WeightedCube.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<BlockPos> SPAWN_DROPPER_POS = SynchedEntityData.m_135353_(WeightedCube.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Optional<UUID>> PICKED_UP_BY = SynchedEntityData.m_135353_(WeightedCube.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public WeightedCube(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ACTIVATED, (Object)false);
        this.f_19804_.m_135372_(SPAWN_DROPPER_POS, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(PICKED_UP_BY, Optional.empty());
    }

    protected void m_7378_(CompoundTag tag) {
        this.f_19804_.m_135381_(ACTIVATED, (Object)tag.m_128471_("activated"));
        this.f_19804_.m_135381_(SPAWN_DROPPER_POS, (Object)new BlockPos(tag.m_128465_("spawn_dropper_pos")[0], tag.m_128465_("spawn_dropper_pos")[1], tag.m_128465_("spawn_dropper_pos")[2]));
        if (tag.m_128441_("picked_up_by")) {
            this.f_19804_.m_135381_(PICKED_UP_BY, Optional.of(tag.m_128342_("picked_up_by")));
        } else {
            this.f_19804_.m_135381_(PICKED_UP_BY, Optional.empty());
        }
        this.m_20011_(this.m_142242_());
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128379_("activated", ((Boolean)this.f_19804_.m_135370_(ACTIVATED)).booleanValue());
        tag.m_128408_("spawn_dropper_pos", List.of(Integer.valueOf(((BlockPos)this.f_19804_.m_135370_(SPAWN_DROPPER_POS)).m_123341_()), Integer.valueOf(((BlockPos)this.f_19804_.m_135370_(SPAWN_DROPPER_POS)).m_123342_()), Integer.valueOf(((BlockPos)this.f_19804_.m_135370_(SPAWN_DROPPER_POS)).m_123343_())));
        if (((Optional)this.f_19804_.m_135370_(PICKED_UP_BY)).isPresent()) {
            tag.m_128362_("picked_up_by", (UUID)((Optional)this.f_19804_.m_135370_(PICKED_UP_BY)).get());
        } else {
            tag.m_128473_("picked_up_by");
        }
    }

    public void m_8119_() {
        UUID picked_up_by_uuid = ((Optional)this.f_19804_.m_135370_(PICKED_UP_BY)).orElse(null);
        if (picked_up_by_uuid != null) {
            Player player = this.m_9236_().m_46003_(picked_up_by_uuid);
            if (player == null) {
                this.f_19804_.m_135381_(PICKED_UP_BY, Optional.empty());
                return;
            }
            if (this.m_20270_((Entity)player) < 4.0f) {
                Vec3 following_pos = player.m_146892_().m_82520_(0.0, -0.375, 0.0);
                following_pos = following_pos.m_82549_(player.m_20154_().m_82542_(2.0, 2.0, 2.0));
                this.m_6478_(MoverType.SELF, following_pos.m_82546_(this.m_20182_()));
                this.m_146922_(player.m_6080_());
                return;
            }
        }
        if (-this.m_20184_().f_82480_ < 1.0) {
            this.m_246865_(new Vec3(0.0, -0.1, 0.0));
        }
        float flag = 1.0f;
        boolean flag2 = false;
        if (this.f_285638_.orElse(null) != null && this.m_9236_().m_8055_((BlockPos)this.f_285638_.get()) != null) {
            BlockState state = this.m_9236_().m_8055_((BlockPos)this.f_285638_.get());
            if (state.m_60713_(Blocks.f_50374_)) {
                flag = -0.25f;
            }
            if (state.m_60713_((Block)portalgun.PORTAL_BLOCK.get())) {
                flag2 = true;
            }
            float friction = state.getFriction((LevelReader)this.m_9236_(), (BlockPos)this.f_285638_.get(), null) * 0.95f;
            this.m_20256_(this.m_20184_().m_82542_((double)friction, 1.0, (double)friction));
        }
        if (this.m_20096_() & !flag2) {
            this.m_246865_(new Vec3(0.0, -this.m_20184_().f_82480_ * (double)flag, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        super.m_8119_();
    }

    public void m_142687_(Entity.RemovalReason reason) {
        BlockState state = this.m_9236_().m_8055_(this.m_20183_());
        super.m_142687_(reason);
        if (state != null & state.m_60713_((Block)portalgun.PRESSURE_BUTTON.get())) {
            state.m_60734_().m_7892_(state, this.m_9236_(), this.m_20183_(), (Entity)this);
        }
    }

    public boolean m_5829_() {
        return ((Optional)this.f_19804_.m_135370_(PICKED_UP_BY)).isEmpty();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!player.m_6144_()) {
            return InteractionResult.PASS;
        }
        if (((Optional)this.f_19804_.m_135370_(PICKED_UP_BY)).orElse(null) == null) {
            this.f_19804_.m_135381_(PICKED_UP_BY, Optional.of(player.m_20148_()));
        } else {
            this.f_19804_.m_135381_(PICKED_UP_BY, Optional.empty());
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6087_() {
        return true;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.getDimensions();
    }

    private EntityDimensions getDimensions() {
        return EntityDimensions.m_20395_((float)0.75f, (float)0.75f);
    }

    public boolean m_7337_(Entity entity) {
        return true;
    }
}

