/*
 * Decompiled with CFR 0.152.
 */
package club.luxry.rtpzone;

import club.luxry.rtpzone.commands.RTPZoneCommands;
import club.luxry.rtpzone.managers.ConfigManager;
import club.luxry.rtpzone.managers.CooldownManager;
import club.luxry.rtpzone.managers.RegionsManager;
import club.luxry.rtpzone.placeholders.RTPZonePlaceholders;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class RTPZonePlugin
extends JavaPlugin {
    private ConfigManager configManager;
    private RegionsManager regionManager;
    private CooldownManager cooldownManager;
    private RTPZonePlaceholders placeholders;

    public void onEnable() {
        String[] lines;
        if (!this.checkDependencies()) {
            this.getLogger().severe("Missing required dependencies! Disabling plugin.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        String asciiArt = "                                         \n                                         \n                                         \n                  &5 |  \\                                        \n                  &5 | $$ __    __  __    __   ______   __    __ \n                  &5 | $$|  \\  |  \\|  \\  /  \\ /      \\ |  \\  |  \\\n                  &5 | $$| $$  | $$ \\$$\\/  $$|  $$$$$$\\| $$  | $$\n                  &5 | $$| $$  | $$  >$$  $$ | $$   \\$$| $$  | $$\n                  &5 | $$| $$__/ $$ /  $$$$\\ | $$      | $$__/ $$\n                  &5 | $$ \\$$    $$|  $$ \\$$\\| $$       \\$$    $$\n                  &5  \\$$  \\$$$$$$  \\$$   \\$$ \\$$       _\\$$$$$$$\n                  &5                                   |  \\__| $$\n                  &5                                    \\$$    $$\n                  &5                                     \\$$$$$$ \n                                         \n                      &bRTPZone is running on Spigot - " + this.getDescription().getVersion() + "\n                        &6Check more resources at luxry.club  \n                                         ";
        for (String line : lines = asciiArt.split("\n")) {
            this.getServer().getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&5" + line)));
        }
        this.configManager = new ConfigManager(this);
        this.regionManager = new RegionsManager(this);
        this.cooldownManager = new CooldownManager(this);
        this.configManager.loadConfig();
        this.regionManager.initialize();
        this.cooldownManager.initialize();
        this.getCommand("rtpzone").setExecutor((CommandExecutor)new RTPZoneCommands(this));
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                this.placeholders = new RTPZonePlaceholders(this);
                if (this.placeholders.register()) {
                    this.getLogger().info("PlaceholderAPI integration enabled successfully!");
                } else {
                    this.getLogger().warning("Failed to register PlaceholderAPI expansion!");
                }
            }
        }, 20L);
        this.getLogger().info("RTPZone enabled successfully!");
    }

    public void onDisable() {
        if (this.cooldownManager != null) {
            this.cooldownManager.shutdown();
        }
        if (this.placeholders != null) {
            this.placeholders.unregister();
        }
        this.getLogger().info("RTPZone disabled!");
    }

    private boolean checkDependencies() {
        boolean betterRTP;
        boolean worldEdit = Bukkit.getPluginManager().getPlugin("WorldEdit") != null;
        boolean worldGuard = Bukkit.getPluginManager().getPlugin("WorldGuard") != null;
        boolean bl = betterRTP = Bukkit.getPluginManager().getPlugin("BetterRTP") != null;
        if (!worldEdit) {
            this.getLogger().severe("WorldEdit not found! This plugin is required.");
        }
        if (!worldGuard) {
            this.getLogger().severe("WorldGuard not found! This plugin is required for regions.");
        }
        if (!betterRTP) {
            this.getLogger().severe("BetterRTP not found! This plugin is required.");
        }
        return worldEdit && worldGuard && betterRTP;
    }

    public void reload() {
        this.cooldownManager.shutdown();
        this.configManager.loadConfig();
        this.regionManager.initialize();
        this.cooldownManager.initialize();
        if (this.placeholders != null) {
            this.placeholders.unregister();
            this.placeholders.register();
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public RegionsManager getRegionManager() {
        return this.regionManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }
}

