/*
 * Decompiled with CFR 0.152.
 */
package club.luxry.rtpzone.commands;

import club.luxry.rtpzone.RTPZonePlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class RTPZoneCommands
implements CommandExecutor,
TabCompleter {
    private final RTPZonePlugin plugin;

    public RTPZoneCommands(RTPZonePlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("rtpzone.use")) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                return this.handleReload(sender);
            }
            case "force": {
                if (!sender.hasPermission("rtpzone.use")) {
                    sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
                    return true;
                }
                return this.handleForce(sender, args);
            }
            case "about": {
                return this.handleAbout(sender);
            }
        }
        this.sendHelp(sender);
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("rtpzone.reload")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        try {
            this.plugin.reload();
            sender.sendMessage(this.plugin.getConfigManager().getMessage("reload"));
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cError reloading configuration: " + e.getMessage());
            this.plugin.getLogger().severe("Error reloading configuration: " + e.getMessage());
        }
        return true;
    }

    private boolean handleForce(CommandSender sender, String[] args) {
        if (!sender.hasPermission("rtpzone.force")) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage: /rtpzone force <region>");
            return true;
        }
        String regionId = args[1];
        if (!this.plugin.getRegionManager().regionExists(regionId)) {
            sender.sendMessage(this.plugin.getConfigManager().getMessage("region-not-found").replace("%region%", regionId));
            return true;
        }
        this.plugin.getCooldownManager().triggerTeleport(regionId);
        this.plugin.getCooldownManager().resetCooldown(regionId);
        sender.sendMessage(this.plugin.getConfigManager().getMessage("force").replace("%region%", regionId));
        return true;
    }

    private boolean handleAbout(CommandSender sender) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&b&lRTPZone &8- &b&lv" + this.plugin.getDescription().getVersion())));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&r"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b\u25c6 &fWebsite: &bhttps://luxry.club/"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&b\u25c6 &fDiscord: &bhttps://luxry.club/discord"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&r"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7&oThis plugin was developed and designed by Luxry Club."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7&oIf you have any questions, feel free to ask in our Discord server. "));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&r"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)"&8&m                                                                                                  &r"));
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage("\u00a76=== RTPZone Commands ===");
        sender.sendMessage("\u00a7e/rtpzone about \u00a77- About the plugin");
        sender.sendMessage("\u00a7e/rtpzone reload \u00a77- Reload configuration");
        sender.sendMessage("\u00a7e/rtpzone force <region> \u00a77- Force teleport region");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block3: {
            block2: {
                completions = new ArrayList<String>();
                if (args.length != 1) break block2;
                List<String> subcommands = Arrays.asList("reload", "force", "about");
                for (String sub : subcommands) {
                    if (!sub.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    completions.add(sub);
                }
                break block3;
            }
            if (args.length != 2 || !args[0].equalsIgnoreCase("force")) break block3;
            for (String regionId : this.plugin.getRegionManager().getRegionIds()) {
                if (!regionId.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                completions.add(regionId);
            }
        }
        return completions;
    }
}

