/*
 * Decompiled with CFR 0.152.
 */
package club.luxry.rtpzone.managers;

import club.luxry.rtpzone.RTPZonePlugin;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final RTPZonePlugin plugin;
    private FileConfiguration config;
    private Map<String, RegionConfig> regions;

    public ConfigManager(RTPZonePlugin plugin) {
        this.plugin = plugin;
        this.regions = new HashMap<String, RegionConfig>();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.loadRegions();
    }

    private void loadRegions() {
        this.regions.clear();
        ConfigurationSection regionSection = this.config.getConfigurationSection("regions");
        if (regionSection == null) {
            this.plugin.getLogger().warning("No regions configured!");
            return;
        }
        for (String key : regionSection.getKeys(false)) {
            ConfigurationSection region = regionSection.getConfigurationSection(key);
            if (region == null) continue;
            String regionName = region.getString("region", key);
            int cooldown = region.getInt("cooldown", this.getDefaultCooldown());
            this.regions.put(key, new RegionConfig(key, regionName, cooldown));
            this.plugin.getLogger().info("Loaded region: " + key + " -> " + regionName + " (cooldown: " + cooldown + "s)");
        }
    }

    public Map<String, RegionConfig> getRegions() {
        return new HashMap<String, RegionConfig>(this.regions);
    }

    public RegionConfig getRegion(String id) {
        return this.regions.get(id);
    }

    public String getCooldownFormat() {
        return this.config.getString("settings.cooldown-format", "mm:ss");
    }

    public String getBetterRTPWorld() {
        return this.config.getString("settings.betterrtp-world", "world");
    }

    public int getDefaultCooldown() {
        return this.config.getInt("settings.cooldown-default", 300);
    }

    public int getResetDuration() {
        return this.config.getInt("settings.reset-duration", 30);
    }

    public String getResetMessage() {
        return this.config.getString("settings.reset-message", "Resetting").replace("&", "\u00a7");
    }

    public String getMessage(String path) {
        return this.config.getString("messages.chat." + path, "Message not found: " + path).replace("&", "\u00a7");
    }

    public boolean isTitleEnabled(String type) {
        return this.config.getBoolean("messages.titles." + type + ".enabled", false);
    }

    public String getTitleText(String type) {
        return this.config.getString("messages.titles." + type + ".title", "").replace("&", "\u00a7");
    }

    public String getSubtitleText(String type) {
        return this.config.getString("messages.titles." + type + ".subtitle", "").replace("&", "\u00a7");
    }

    public int getTitleFadeIn(String type) {
        return this.config.getInt("messages.titles." + type + ".fade-in", 10);
    }

    public int getTitleStay(String type) {
        return this.config.getInt("messages.titles." + type + ".stay", 40);
    }

    public int getTitleFadeOut(String type) {
        return this.config.getInt("messages.titles." + type + ".fade-out", 10);
    }

    public static class RegionConfig {
        private final String id;
        private final String regionName;
        private final int cooldown;

        public RegionConfig(String id, String regionName, int cooldown) {
            this.id = id;
            this.regionName = regionName;
            this.cooldown = cooldown;
        }

        public String getId() {
            return this.id;
        }

        public String getRegionName() {
            return this.regionName;
        }

        public int getCooldown() {
            return this.cooldown;
        }
    }
}

