/*
 * Decompiled with CFR 0.152.
 */
package club.luxry.rtpzone.managers;

import club.luxry.rtpzone.RTPZonePlugin;
import club.luxry.rtpzone.managers.ConfigManager;
import club.luxry.rtpzone.utils.TimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.SuperRonanCraft.BetterRTP.player.rtp.RTP_PlayerInfo;
import me.SuperRonanCraft.BetterRTP.player.rtp.RTP_TYPE;
import me.SuperRonanCraft.BetterRTP.references.helpers.HelperRTP;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CooldownManager {
    private final RTPZonePlugin plugin;
    private final Map<String, Integer> cooldowns;
    private final Map<String, Integer> resetTimers;
    private BukkitTask cooldownTask;

    public CooldownManager(RTPZonePlugin plugin) {
        this.plugin = plugin;
        this.cooldowns = new HashMap<String, Integer>();
        this.resetTimers = new HashMap<String, Integer>();
    }

    public void initialize() {
        for (ConfigManager.RegionConfig region : this.plugin.getConfigManager().getRegions().values()) {
            this.cooldowns.put(region.getId(), region.getCooldown());
            this.resetTimers.put(region.getId(), 0);
        }
        this.startCooldownTask();
    }

    private void startCooldownTask() {
        if (this.cooldownTask != null) {
            this.cooldownTask.cancel();
        }
        this.cooldownTask = new BukkitRunnable(){

            public void run() {
                CooldownManager.this.processCooldowns();
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    private void processCooldowns() {
        for (Map.Entry<String, Integer> entry : this.cooldowns.entrySet()) {
            String regionId = entry.getKey();
            int currentCooldown = entry.getValue();
            int currentReset = this.resetTimers.get(regionId);
            if (currentReset > 0) {
                ConfigManager.RegionConfig regionConfig;
                this.resetTimers.put(regionId, currentReset - 1);
                if (currentReset - 1 != 0 || (regionConfig = this.plugin.getConfigManager().getRegion(regionId)) == null) continue;
                this.cooldowns.put(regionId, regionConfig.getCooldown());
                continue;
            }
            if (currentCooldown > 0) {
                int newCooldown = currentCooldown - 1;
                this.cooldowns.put(regionId, newCooldown);
                if (newCooldown != 30 && newCooldown != 10 && newCooldown > 5) continue;
                this.sendWarningToPlayers(regionId, newCooldown);
                continue;
            }
            if (currentCooldown != 0 || currentReset != 0) continue;
            this.triggerTeleport(regionId);
            int resetDuration = this.plugin.getConfigManager().getResetDuration();
            this.resetTimers.put(regionId, resetDuration);
        }
    }

    private void sendWarningToPlayers(String regionId, int timeLeft) {
        Set<Player> players = this.plugin.getRegionManager().getPlayersInRegion(regionId);
        if (players.isEmpty()) {
            return;
        }
        String timeFormatted = TimeFormatter.format(timeLeft, this.plugin.getConfigManager().getCooldownFormat());
        String message = this.plugin.getConfigManager().getMessage("cooldown-warning").replace("%region%", regionId).replace("%time%", timeFormatted);
        for (Player player : players) {
            player.sendMessage(message);
            if (!this.plugin.getConfigManager().isTitleEnabled("cooldown-warning")) continue;
            String title = this.plugin.getConfigManager().getTitleText("cooldown-warning").replace("%region%", regionId).replace("%time%", timeFormatted);
            String subtitle = this.plugin.getConfigManager().getSubtitleText("cooldown-warning").replace("%region%", regionId).replace("%time%", timeFormatted);
            player.sendTitle(title, subtitle, this.plugin.getConfigManager().getTitleFadeIn("cooldown-warning"), this.plugin.getConfigManager().getTitleStay("cooldown-warning"), this.plugin.getConfigManager().getTitleFadeOut("cooldown-warning"));
        }
    }

    public void triggerTeleport(String regionId) {
        Set<Player> players = this.plugin.getRegionManager().getPlayersInRegion(regionId);
        if (players.isEmpty()) {
            return;
        }
        String message = this.plugin.getConfigManager().getMessage("teleport").replace("%region%", regionId);
        for (Player player : players) {
            player.sendMessage(message);
            if (!this.plugin.getConfigManager().isTitleEnabled("teleport")) continue;
            String title = this.plugin.getConfigManager().getTitleText("teleport").replace("%region%", regionId);
            String subtitle = this.plugin.getConfigManager().getSubtitleText("teleport").replace("%region%", regionId);
            player.sendTitle(title, subtitle, this.plugin.getConfigManager().getTitleFadeIn("teleport"), this.plugin.getConfigManager().getTitleStay("teleport"), this.plugin.getConfigManager().getTitleFadeOut("teleport"));
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            String worldName = this.plugin.getConfigManager().getBetterRTPWorld();
            World world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                return;
            }
            try {
                List onlinePlayers = players.stream().filter(OfflinePlayer::isOnline).collect(Collectors.toList());
                if (!onlinePlayers.isEmpty()) {
                    Player firstPlayer = (Player)onlinePlayers.get(0);
                    HelperRTP.tp((Player)firstPlayer, (CommandSender)Bukkit.getConsoleSender(), (World)world, null, (RTP_TYPE)RTP_TYPE.FORCED, null, (RTP_PlayerInfo)new RTP_PlayerInfo(false, false));
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        Location targetLocation = firstPlayer.getLocation();
                        for (int i = 1; i < onlinePlayers.size(); ++i) {
                            Player player = (Player)onlinePlayers.get(i);
                            if (!player.isOnline()) continue;
                            player.teleport(targetLocation);
                        }
                    }, 40L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 40L);
    }

    public int getCooldown(String regionId) {
        return this.cooldowns.getOrDefault(regionId, 0);
    }

    public int getResetTimer(String regionId) {
        return this.resetTimers.getOrDefault(regionId, 0);
    }

    public boolean isInResetPeriod(String regionId) {
        return this.getResetTimer(regionId) > 0;
    }

    public void setCooldown(String regionId, int seconds) {
        this.cooldowns.put(regionId, seconds);
        this.resetTimers.put(regionId, 0);
    }

    public void resetCooldown(String regionId) {
        ConfigManager.RegionConfig regionConfig = this.plugin.getConfigManager().getRegion(regionId);
        if (regionConfig != null) {
            this.cooldowns.put(regionId, regionConfig.getCooldown());
            this.resetTimers.put(regionId, 0);
        }
    }

    public void shutdown() {
        if (this.cooldownTask != null) {
            this.cooldownTask.cancel();
            this.cooldownTask = null;
        }
    }
}

