/*
 * Decompiled with CFR 0.152.
 */
package club.luxry.rtpzone.managers;

import club.luxry.rtpzone.RTPZonePlugin;
import club.luxry.rtpzone.managers.ConfigManager;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class RegionsManager {
    private final RTPZonePlugin plugin;
    private final Map<String, ProtectedRegion> regions;
    private final Map<String, World> regionWorlds;

    public RegionsManager(RTPZonePlugin plugin) {
        this.plugin = plugin;
        this.regions = new HashMap<String, ProtectedRegion>();
        this.regionWorlds = new HashMap<String, World>();
    }

    public void initialize() {
        this.regions.clear();
        this.regionWorlds.clear();
        this.plugin.getLogger().info("Loading regions...");
        for (ConfigManager.RegionConfig regionConfig : this.plugin.getConfigManager().getRegions().values()) {
            this.loadRegion(regionConfig);
        }
        this.plugin.getLogger().info("Loaded " + this.regions.size() + " regions successfully.");
    }

    private void loadRegion(ConfigManager.RegionConfig regionConfig) {
        String regionName = regionConfig.getRegionName();
        this.plugin.getLogger().info("Attempting to load region: " + regionName + " (ID: " + regionConfig.getId() + ")");
        ProtectedRegion region = this.findRegionInWorlds(regionName);
        if (region != null) {
            this.regions.put(regionConfig.getId(), region);
            this.plugin.getLogger().info("Successfully loaded region: " + regionName + " -> " + regionConfig.getId());
        } else {
            this.plugin.getLogger().warning("Could not find WorldGuard region: " + regionName);
            this.plugin.getLogger().warning("Available regions in all worlds:");
            this.listAllRegions();
        }
    }

    private void listAllRegions() {
        for (World world : Bukkit.getWorlds()) {
            RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
        }
    }

    private ProtectedRegion findRegionInWorlds(String regionName) {
        for (World world : Bukkit.getWorlds()) {
            ProtectedRegion region;
            RegionManager worldRegions = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
            if (worldRegions == null || (region = worldRegions.getRegion(regionName)) == null) continue;
            this.regionWorlds.put(regionName, world);
            return region;
        }
        return null;
    }

    public Set<Player> getPlayersInRegion(String regionId) {
        ProtectedRegion region = this.regions.get(regionId);
        if (region == null) {
            return new HashSet<Player>();
        }
        HashSet<Player> playersInRegion = new HashSet<Player>();
        ConfigManager.RegionConfig regionConfig = this.plugin.getConfigManager().getRegion(regionId);
        if (regionConfig == null) {
            return playersInRegion;
        }
        String regionName = regionConfig.getRegionName();
        World world = this.regionWorlds.get(regionName);
        if (world == null) {
            return playersInRegion;
        }
        for (Player player : world.getPlayers()) {
            Location loc = player.getLocation();
            if (!region.contains(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ())) continue;
            playersInRegion.add(player);
        }
        return playersInRegion;
    }

    public boolean regionExists(String regionId) {
        boolean exists = this.regions.containsKey(regionId);
        return exists;
    }

    public Set<String> getRegionIds() {
        return new HashSet<String>(this.regions.keySet());
    }
}

