/*
 * Decompiled with CFR 0.152.
 */
package club.luxry.rtpzone.placeholders;

import club.luxry.rtpzone.RTPZonePlugin;
import club.luxry.rtpzone.utils.TimeFormatter;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class RTPZonePlaceholders
extends PlaceholderExpansion {
    private final RTPZonePlugin plugin;

    public RTPZonePlaceholders(RTPZonePlugin plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "rtpzone";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, String params) {
        if (params == null) {
            return null;
        }
        if (params.endsWith("_cooldown")) {
            String regionId = params.substring(0, params.length() - "_cooldown".length());
            if (this.plugin.getRegionManager().regionExists(regionId)) {
                if (this.plugin.getCooldownManager().isInResetPeriod(regionId)) {
                    return this.plugin.getConfigManager().getResetMessage();
                }
                int cooldown = this.plugin.getCooldownManager().getCooldown(regionId);
                return TimeFormatter.format(cooldown, this.plugin.getConfigManager().getCooldownFormat());
            }
        }
        return null;
    }
}

