/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client;

import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2591;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5601;
import net.minecraft.class_953;
import net.satisfy.brewery.client.gui.WallDecorationEditGui;
import net.satisfy.brewery.client.model.BeerElementalModel;
import net.satisfy.brewery.client.model.BrewfestBootsModel;
import net.satisfy.brewery.client.model.BrewfestChestplateModel;
import net.satisfy.brewery.client.model.BrewfestHatModel;
import net.satisfy.brewery.client.model.BrewfestLeggingsModel;
import net.satisfy.brewery.client.renderer.block.BeerMugRenderer;
import net.satisfy.brewery.client.renderer.block.BeverageRenderer;
import net.satisfy.brewery.client.renderer.block.BrewingstationRenderer;
import net.satisfy.brewery.client.renderer.block.CompletionistBannerRenderer;
import net.satisfy.brewery.client.renderer.block.StorageBlockEntityRenderer;
import net.satisfy.brewery.client.renderer.block.WallDecorationBlockRenderer;
import net.satisfy.brewery.client.renderer.entity.BeerElementalAttackRenderer;
import net.satisfy.brewery.client.renderer.entity.BeerElementalRenderer;
import net.satisfy.brewery.core.block.entity.WallDecorationBlockEntity;
import net.satisfy.brewery.core.item.BreathalyzerItem;
import net.satisfy.brewery.core.registry.EntityTypeRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.brewery.core.registry.StorageTypeRegistry;

@Environment(value=EnvType.CLIENT)
public class BreweryClient {
    public static void onInitializeClient() {
        BreathalyzerItem.init();
        RenderTypeRegistry.register((class_1921)class_1921.method_23581(), (class_2248[])new class_2248[]{(class_2248)ObjectRegistry.WILD_HOPS.get(), (class_2248)ObjectRegistry.BEER_MUG.get(), (class_2248)ObjectRegistry.BEER_WHEAT.get(), (class_2248)ObjectRegistry.BEER_HOPS.get(), (class_2248)ObjectRegistry.BEER_BARLEY.get(), (class_2248)ObjectRegistry.BEER_HALEY.get(), (class_2248)ObjectRegistry.BEER_OAT.get(), (class_2248)ObjectRegistry.BEER_NETTLE.get(), (class_2248)ObjectRegistry.HOPS_CROP_BODY.get(), (class_2248)ObjectRegistry.HOPS_CROP.get(), (class_2248)ObjectRegistry.WHISKEY_MAGGOALLAN.get(), (class_2248)ObjectRegistry.WHISKEY_CARRASCONLABEL.get(), (class_2248)ObjectRegistry.WHISKEY_LILITUSINGLEMALT.get(), (class_2248)ObjectRegistry.WHISKEY_JOJANNIK.get(), (class_2248)ObjectRegistry.WHISKEY_MAGGOALLAN.get(), (class_2248)ObjectRegistry.WHISKEY_CRISTELWALKER.get(), (class_2248)ObjectRegistry.WHISKEY_AK.get(), (class_2248)ObjectRegistry.WHISKEY_HIGHLAND_HEARTH.get(), (class_2248)ObjectRegistry.WHISKEY_JAMESONS_MALT.get(), (class_2248)ObjectRegistry.WHISKEY_SMOKEY_REVERIE.get(), (class_2248)ObjectRegistry.BREWERY_BANNER.get(), (class_2248)ObjectRegistry.BREWERY_WALL_BANNER.get()});
        ColorHandlerRegistry.registerBlockColors((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return -1;
            }
            return class_1163.method_4961((class_1920)world, (class_2338)pos);
        }, (Supplier[])new Supplier[]{ObjectRegistry.WOODEN_BREWINGSTATION, ObjectRegistry.COPPER_BREWINGSTATION, ObjectRegistry.NETHERITE_BREWINGSTATION});
        BlockEntityRendererRegistry.register((class_2591)((class_2591)EntityTypeRegistry.BREWERY_BANNER.get()), CompletionistBannerRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)EntityTypeRegistry.STORAGE_ENTITY.get()), context -> new StorageBlockEntityRenderer());
        BlockEntityRendererRegistry.register((class_2591)((class_2591)EntityTypeRegistry.BEER_MUG_BLOCK_ENTITY.get()), BeerMugRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)EntityTypeRegistry.BREWINGSTATION_BLOCK_ENTITY.get()), BrewingstationRenderer::new);
        BlockEntityRendererRegistry.register((class_2591)((class_2591)EntityTypeRegistry.WALL_DECORATION.get()), context -> new WallDecorationBlockRenderer());
        StorageBlockEntityRenderer.registerStorageType(StorageTypeRegistry.BEVERAGE, new BeverageRenderer());
    }

    public static void openStreetSignScreen(WallDecorationBlockEntity entity) {
        class_310.method_1551().method_1507((class_437)new WallDecorationEditGui(entity));
    }

    public static void preInitClient() {
        BreweryClient.registerEntityRenderers();
        BreweryClient.registerEntityModelLayers();
    }

    private static void registerEntityRenderers() {
        EntityRendererRegistry.register(EntityTypeRegistry.BEER_ELEMENTAL, BeerElementalRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.BEER_ELEMENTAL_ATTACK, BeerElementalAttackRenderer::new);
        EntityRendererRegistry.register(EntityTypeRegistry.DARK_BREW, class_953::new);
    }

    public static void registerEntityModelLayers() {
        EntityModelLayerRegistry.register((class_5601)BrewfestHatModel.LAYER_LOCATION, BrewfestHatModel::createBodyLayer);
        EntityModelLayerRegistry.register((class_5601)BrewfestChestplateModel.LAYER_LOCATION, BrewfestChestplateModel::createBodyLayer);
        EntityModelLayerRegistry.register((class_5601)BrewfestLeggingsModel.LAYER_LOCATION, BrewfestLeggingsModel::createBodyLayer);
        EntityModelLayerRegistry.register((class_5601)BrewfestBootsModel.LAYER_LOCATION, BrewfestBootsModel::createBodyLayer);
        EntityModelLayerRegistry.register((class_5601)BeerElementalModel.BEER_ELEMENTAL_MODEL_LAYER, BeerElementalModel::createBodyLayer);
        EntityModelLayerRegistry.register((class_5601)CompletionistBannerRenderer.LAYER_LOCATION, CompletionistBannerRenderer::createBodyLayer);
    }
}

