/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import com.mojang.serialization.MapCodec;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.satisfy.brewery.core.block.entity.CabinetBlockEntity;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SideBoardBlock
extends class_2237
implements class_3737 {
    private static final Map<GeneralUtil.LineConnectingType, Supplier<class_265>> SHAPES_SUPPLIERS = new HashMap<GeneralUtil.LineConnectingType, Supplier<class_265>>();
    private static final Map<class_2350, Map<GeneralUtil.LineConnectingType, class_265>> SHAPES = new EnumMap<class_2350, Map<GeneralUtil.LineConnectingType, class_265>>(class_2350.class);
    public static final class_2746 WATERLOGGED;
    public static final class_2753 FACING;
    public static final class_2754<GeneralUtil.LineConnectingType> TYPE;
    private final Supplier<class_3414> openSound;
    private final Supplier<class_3414> closeSound;
    public static final MapCodec<SideBoardBlock> CODEC;

    public SideBoardBlock(class_4970.class_2251 settings) {
        this(settings, null, null);
    }

    public SideBoardBlock(class_4970.class_2251 settings, Supplier<class_3414> openSound, Supplier<class_3414> closeSound) {
        super(settings);
        this.openSound = openSound;
        this.closeSound = closeSound;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(TYPE, (Comparable)GeneralUtil.LineConnectingType.NONE));
    }

    public class_2680 method_9605(class_1750 context) {
        class_1937 world = context.method_8045();
        class_2338 clickedPos = context.method_8037();
        class_2350 facing = context.method_8042().method_10153();
        class_2680 blockState = (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)facing)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(world.method_8316(clickedPos).method_15772() == class_3612.field_15910));
        return switch (facing) {
            case class_2350.field_11034 -> (class_2680)blockState.method_11657(TYPE, (Comparable)this.getType(blockState, world.method_8320(clickedPos.method_10072()), world.method_8320(clickedPos.method_10095())));
            case class_2350.field_11035 -> (class_2680)blockState.method_11657(TYPE, (Comparable)this.getType(blockState, world.method_8320(clickedPos.method_10067()), world.method_8320(clickedPos.method_10078())));
            case class_2350.field_11039 -> (class_2680)blockState.method_11657(TYPE, (Comparable)this.getType(blockState, world.method_8320(clickedPos.method_10095()), world.method_8320(clickedPos.method_10072())));
            default -> (class_2680)blockState.method_11657(TYPE, (Comparable)this.getType(blockState, world.method_8320(clickedPos.method_10078()), world.method_8320(clickedPos.method_10067())));
        };
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED, FACING, TYPE});
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof class_1263) {
                class_1263 container = (class_1263)blockEntity;
                class_1264.method_5451((class_1937)world, (class_2338)pos, (class_1263)container);
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    @NotNull
    protected class_1269 method_55766(class_2680 blockState, class_1937 world, class_2338 pos, class_1657 player, class_3965 blockHitResult) {
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CabinetBlockEntity) {
            CabinetBlockEntity blockEntity1 = (CabinetBlockEntity)blockEntity;
            player.method_17355((class_3908)blockEntity1);
        }
        return class_1269.field_21466;
    }

    public void playSound(class_1937 world, class_2338 pos, boolean isOpen) {
        world.method_8396(null, pos, isOpen ? this.openSound.get() : this.closeSound.get(), class_3419.field_15245, 1.0f, 1.1f);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CabinetBlockEntity(pos, state);
    }

    @NotNull
    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    @NotNull
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 blockEntity;
        if (itemStack.method_57826(class_9334.field_49631) && (blockEntity = world.method_8321(pos)) instanceof CabinetBlockEntity) {
            CabinetBlockEntity blockEntity1 = (CabinetBlockEntity)blockEntity;
            blockEntity1.method_58684(class_9323.method_57827().method_57840(class_9334.field_49631, (Object)itemStack.method_7964()).method_57838());
        }
    }

    @NotNull
    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public GeneralUtil.LineConnectingType getType(class_2680 state, class_2680 left, class_2680 right) {
        boolean shape_left_same = this.isConnectable(left, state);
        boolean shape_right_same = this.isConnectable(right, state);
        if (shape_left_same && shape_right_same) {
            return GeneralUtil.LineConnectingType.MIDDLE;
        }
        if (shape_left_same) {
            return GeneralUtil.LineConnectingType.LEFT;
        }
        if (shape_right_same) {
            return GeneralUtil.LineConnectingType.RIGHT;
        }
        return GeneralUtil.LineConnectingType.NONE;
    }

    protected boolean isConnectable(class_2680 state1, class_2680 state2) {
        return state1.method_26204() == state2.method_26204() && state1.method_11654((class_2769)FACING) == state2.method_11654((class_2769)FACING);
    }

    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        if (world.field_9236) {
            return;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        GeneralUtil.LineConnectingType type = switch (facing) {
            case class_2350.field_11034 -> this.getType(state, world.method_8320(pos.method_10072()), world.method_8320(pos.method_10095()));
            case class_2350.field_11035 -> this.getType(state, world.method_8320(pos.method_10067()), world.method_8320(pos.method_10078()));
            case class_2350.field_11039 -> this.getType(state, world.method_8320(pos.method_10095()), world.method_8320(pos.method_10072()));
            default -> this.getType(state, world.method_8320(pos.method_10078()), world.method_8320(pos.method_10067()));
        };
        if (state.method_11654(TYPE) != type) {
            state = (class_2680)state.method_11657(TYPE, (Comparable)type);
        }
        world.method_8652(pos, state, 3);
    }

    @NotNull
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        GeneralUtil.LineConnectingType type = (GeneralUtil.LineConnectingType)state.method_11654(TYPE);
        return SHAPES.get(direction).get(type);
    }

    private static class_265 makeSingleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.0625, (double)0.25, (double)0.1875, (double)0.25), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.75, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.25), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.75, (double)0.25, (double)0.1875, (double)0.9375), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.75, (double)0.0, (double)0.75, (double)0.9375, (double)0.1875, (double)0.9375), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.1875, (double)0.0625, (double)0.9375, (double)0.8125, (double)0.9375), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeRightShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.1875, (double)0.0625, (double)0.9375, (double)0.8125, (double)0.9375), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.75, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.25), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.75, (double)0.0, (double)0.75, (double)0.9375, (double)0.1875, (double)0.9375), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeLeftShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.1875, (double)0.0625, (double)1.0, (double)0.8125, (double)0.9375), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.75, (double)0.25, (double)0.1875, (double)0.9375), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0625, (double)0.0, (double)0.0625, (double)0.25, (double)0.1875, (double)0.25), (class_247)class_247.field_1366);
        return shape;
    }

    private static class_265 makeMiddleShape() {
        class_265 shape = class_259.method_1073();
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.1875, (double)0.0625, (double)1.0, (double)0.8125, (double)0.9375), (class_247)class_247.field_1366);
        shape = class_259.method_1072((class_265)shape, (class_265)class_259.method_1081((double)0.0, (double)0.8125, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (class_247)class_247.field_1366);
        return shape;
    }

    static {
        CODEC = SideBoardBlock.method_54094(SideBoardBlock::new);
        WATERLOGGED = class_2741.field_12508;
        FACING = class_2741.field_12481;
        TYPE = GeneralUtil.LINE_CONNECTING_TYPE;
        SHAPES_SUPPLIERS.put(GeneralUtil.LineConnectingType.NONE, SideBoardBlock::makeSingleShape);
        SHAPES_SUPPLIERS.put(GeneralUtil.LineConnectingType.MIDDLE, SideBoardBlock::makeMiddleShape);
        SHAPES_SUPPLIERS.put(GeneralUtil.LineConnectingType.RIGHT, SideBoardBlock::makeRightShape);
        SHAPES_SUPPLIERS.put(GeneralUtil.LineConnectingType.LEFT, SideBoardBlock::makeLeftShape);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            SHAPES.put(direction, new HashMap());
            for (Map.Entry<GeneralUtil.LineConnectingType, Supplier<class_265>> entry : SHAPES_SUPPLIERS.entrySet()) {
                SHAPES.get(direction).put(entry.getKey(), GeneralUtil.rotateShape((class_2350)class_2350.field_11043, (class_2350)direction, (class_265)entry.getValue().get()));
            }
        }
    }
}

