/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import java.util.Optional;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.satisfy.brewery.core.block.entity.StorageBlockEntity;
import net.satisfy.farm_and_charm.core.block.FacingBlock;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StorageBlock
extends FacingBlock
implements class_2343 {
    public static final class_3414 event = class_3417.field_14718;

    public StorageBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @NotNull
    public class_1269 use(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity shelfBlockEntity = (StorageBlockEntity)blockEntity;
            Optional optional = GeneralUtil.getRelativeHitCoordinatesForBlockFace((class_3965)hit, (class_2350)((class_2350)state.method_11654((class_2769)field_11177)), (class_2350[])this.unAllowedDirections());
            if (optional.isEmpty()) {
                return class_1269.field_5811;
            }
            class_3545 ff = (class_3545)optional.get();
            int i = this.getSection((Float)ff.method_15442(), (Float)ff.method_15441());
            if (i == Integer.MIN_VALUE) {
                return class_1269.field_5811;
            }
            if (!((class_1799)shelfBlockEntity.getInventory().get(i)).method_7960()) {
                this.remove(world, pos, player, shelfBlockEntity, i);
                return class_1269.method_29236((boolean)world.field_9236);
            }
            class_1799 stack = player.method_5998(hand);
            if (!stack.method_7960() && this.canInsertStack(stack)) {
                this.add(world, pos, player, shelfBlockEntity, stack, i);
                return class_1269.method_29236((boolean)world.field_9236);
            }
            return class_1269.field_21466;
        }
        return class_1269.field_5811;
    }

    public void add(class_1937 level, class_2338 blockPos, class_1657 player, StorageBlockEntity shelfBlockEntity, class_1799 itemStack, int i) {
        if (!level.field_9236) {
            class_3414 soundEvent = this.getAddSound(level, blockPos, player, i);
            shelfBlockEntity.setStack(i, itemStack.method_7971(1));
            level.method_8396(null, blockPos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            if (player.method_7337()) {
                itemStack.method_7933(1);
            }
            level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, blockPos);
        }
    }

    public void remove(class_1937 level, class_2338 blockPos, class_1657 player, StorageBlockEntity shelfBlockEntity, int i) {
        if (!level.field_9236) {
            class_1799 itemStack = shelfBlockEntity.removeStack(i);
            class_3414 soundEvent = this.getRemoveSound(level, blockPos, player, i);
            level.method_8396(null, blockPos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_31548().method_7394(itemStack)) {
                player.method_7328(itemStack, false);
            }
            level.method_33596((class_1297)player, (class_6880)class_5712.field_28733, blockPos);
        }
    }

    public class_3414 getRemoveSound(class_1937 level, class_2338 blockPos, class_1657 player, int i) {
        return event;
    }

    public class_3414 getAddSound(class_1937 level, class_2338 blockPos, class_1657 player, int i) {
        return event;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof StorageBlockEntity) {
                StorageBlockEntity shelf = (StorageBlockEntity)blockEntity;
                if (world instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)world;
                    class_1264.method_17349((class_1937)serverLevel, (class_2338)pos, shelf.getInventory());
                }
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    @NotNull
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public abstract int size();

    public abstract class_2960 type();

    public abstract class_2350[] unAllowedDirections();

    public abstract boolean canInsertStack(class_1799 var1);

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new StorageBlockEntity(pos, state, this.size());
    }

    public abstract int getSection(Float var1, Float var2);
}

