/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block.entity;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9062;
import net.satisfy.brewery.core.block.property.BrewMaterial;
import net.satisfy.brewery.core.block.property.Heat;
import net.satisfy.brewery.core.block.property.Liquid;
import net.satisfy.brewery.core.entity.BeerElementalEntity;
import net.satisfy.brewery.core.event.brew_event.BrewEvent;
import net.satisfy.brewery.core.event.brew_event.BrewEvents;
import net.satisfy.brewery.core.event.brew_event.BrewHelper;
import net.satisfy.brewery.core.item.DrinkBlockItem;
import net.satisfy.brewery.core.recipe.BrewingRecipe;
import net.satisfy.brewery.core.registry.BlockStateRegistry;
import net.satisfy.brewery.core.registry.EntityTypeRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.brewery.core.registry.RecipeTypeRegistry;
import net.satisfy.brewery.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import net.satisfy.farm_and_charm.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewstationBlockEntity
extends class_2586
implements ImplementedInventory,
class_5558<BrewstationBlockEntity> {
    @NotNull
    private Set<class_2338> components = new HashSet<class_2338>(4);
    private static final int MAX_BREW_TIME = 1200;
    private static final int MIN_TIME_FOR_EVENT = 100;
    private static final int MAX_TIME_FOR_EVENT = 300;
    private static final int SOUND_DURATION = 60;
    private int soundTime;
    private int brewTime;
    private int timeToNextEvent = Integer.MIN_VALUE;
    private final Set<BrewEvent> runningEvents = new HashSet<BrewEvent>();
    private int solved;
    private int totalEvents;
    private int eventQuota = -1;
    private int overflowStarted;
    private int overflowSolved;
    private class_2371<class_1799> ingredients;
    private class_1799 beer = class_1799.field_8037;
    private final class_3414 spawnEntitySound = (class_3414)SoundEventRegistry.BREWSTATION_PROCESS_FAILED.get();

    public BrewstationBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)EntityTypeRegistry.BREWINGSTATION_BLOCK_ENTITY.get(), blockPos, blockState);
        this.ingredients = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
    }

    public void setComponents(class_2338 ... components) {
        if (components.length != 4) {
            return;
        }
        this.components.addAll(Arrays.asList(components));
    }

    public class_9062 addIngredient(class_1799 itemStack) {
        for (int i = 0; i < 3; ++i) {
            class_1799 stack = (class_1799)this.ingredients.get(i);
            if (!stack.method_7960()) continue;
            this.method_5447(i, itemStack.method_7971(1));
            return class_9062.field_47728;
        }
        return class_9062.field_47731;
    }

    @Nullable
    public class_1799 getBeer() {
        if (this.beer.method_7960()) {
            return null;
        }
        class_1799 beerStack = this.beer.method_7972();
        beerStack.method_7939(1);
        this.beer.method_7934(1);
        if (this.beer.method_7960() && this.field_11863 != null) {
            this.field_11863.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.EMPTY)));
        }
        return beerStack;
    }

    @Nullable
    public class_1799 removeIngredient() {
        for (int i = 0; i < 3; ++i) {
            class_1799 itemStack = (class_1799)this.ingredients.get(i);
            if (itemStack.method_7960()) continue;
            this.ingredients.set(i, (Object)class_1799.field_8037);
            return itemStack;
        }
        return null;
    }

    public void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, BrewstationBlockEntity blockEntity) {
        if (level.field_9236) {
            return;
        }
        if (!this.beer.method_7960()) {
            return;
        }
        class_8786<BrewingRecipe> active = this.findActiveRecipe(level);
        if (active == null) {
            this.endBrewing();
            return;
        }
        if (this.eventQuota < 0) {
            this.eventQuota = this.computeEventQuota();
        }
        if (this.soundTime >= 60) {
            level.method_8396(null, blockPos, (class_3414)SoundEventRegistry.BREWSTATION_AMBIENT.get(), class_3419.field_15245, 1.0f, 1.0f);
            this.soundTime = 0;
        }
        ++this.soundTime;
        if (this.timeToNextEvent == Integer.MIN_VALUE) {
            this.setTimeToEvent();
        }
        BrewHelper.checkRunningEvents(this);
        int timeLeft = 1200 - this.brewTime;
        if (this.brewTime >= 1200) {
            class_5455 access = level.method_30349();
            this.brew(active.comp_1933(), access);
        } else if (timeLeft >= 100 && this.timeToNextEvent <= 0 && this.totalEvents < this.eventQuota && this.runningEvents.size() < BrewEvents.BREW_EVENTS.size()) {
            class_2960 eventId;
            BrewEvent event = BrewHelper.getRdmEvent(this);
            if (event != null && (eventId = BrewEvents.getId(event)) != null) {
                if (eventId.equals((Object)BrewEvents.KETTLE_EVENT)) {
                    ++this.overflowStarted;
                }
                event.start(this.components, level);
                this.runningEvents.add(event);
                ++this.totalEvents;
            }
            this.setTimeToEvent();
        }
        ++this.brewTime;
        --this.timeToNextEvent;
    }

    private void setTimeToEvent() {
        if (this.field_11863 != null) {
            this.timeToNextEvent = BrewstationBlockEntity.getRandomHighNumber(this.field_11863.method_8409(), 100, 300);
        }
    }

    public static int getRandomHighNumber(class_5819 rnd, int lowerBound, int upperBound) {
        int range = upperBound - lowerBound + 1;
        return upperBound - (int)(Math.pow(rnd.method_43058(), 1.5) * (double)range);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canBrew(@Nullable class_1860<?> recipe) {
        if (recipe == null) return false;
        if (this.field_11863 == null) {
            return false;
        }
        class_2680 blockState = this.field_11863.method_8320(this.method_11016());
        if (!(recipe instanceof BrewingRecipe)) return false;
        BrewingRecipe brewingRecipe = (BrewingRecipe)recipe;
        if (((BrewMaterial)((Object)blockState.method_11654(BlockStateRegistry.MATERIAL))).getLevel() < brewingRecipe.getMaterial().getLevel()) return false;
        if (blockState.method_11654(BlockStateRegistry.LIQUID) == Liquid.EMPTY) return false;
        if (this.field_11863.method_8320(BrewHelper.getBlock((class_2248)ObjectRegistry.BREW_OVEN.get(), this.components, this.field_11863)).method_11654(BlockStateRegistry.HEAT) == Heat.OFF) return false;
        return true;
    }

    private void brew(class_1860<?> recipe, class_5455 access) {
        class_1799 resultStack = recipe.method_8110((class_7225.class_7874)access);
        class_1792 class_17922 = resultStack.method_7909();
        if (class_17922 instanceof DrinkBlockItem) {
            DrinkBlockItem drinkItem = (DrinkBlockItem)class_17922;
            assert (this.field_11863 != null);
            int quality = this.field_11863.method_8320(this.method_11016()).method_11654(BlockStateRegistry.MATERIAL) == BrewMaterial.NETHERITE ? 3 : this.solved + 1;
            DrinkBlockItem.addQuality(resultStack, quality);
            drinkItem.addCount(resultStack, this.solved == 0 ? 1 : this.solved + 1);
            this.solved = quality;
        }
        this.beer = resultStack;
        this.spawnElementals();
        this.endBrewing();
        if (this.field_11863 != null) {
            class_2680 blockState = this.field_11863.method_8320(this.method_11016());
            this.field_11863.method_8501(this.method_11016(), (class_2680)blockState.method_11657(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.BEER)));
            class_2338 ovenPos = BrewHelper.getBlock((class_2248)ObjectRegistry.BREW_OVEN.get(), this.components, this.field_11863);
            class_2680 ovenState = this.field_11863.method_8320(ovenPos);
            this.field_11863.method_8501(ovenPos, (class_2680)ovenState.method_11657(BlockStateRegistry.HEAT, (Comparable)((Object)Heat.OFF)));
            class_2338 timerPos = BrewHelper.getBlock((class_2248)ObjectRegistry.BREW_TIMER.get(), this.components, this.field_11863);
            class_2680 timerState = this.field_11863.method_8320(timerPos);
            this.field_11863.method_8501(timerPos, (class_2680)timerState.method_11657((class_2769)BlockStateRegistry.TIME, (Comparable)Boolean.valueOf(false)));
        }
        block0: for (class_1856 ingredient : recipe.method_8117()) {
            for (int i = 0; i < 3; ++i) {
                class_1799 itemStack = (class_1799)this.ingredients.get(i);
                if (!ingredient.method_8093(itemStack)) continue;
                this.method_5434(i, 1);
                continue block0;
            }
        }
    }

    private void spawnElementals() {
        boolean highFailRate;
        if (this.field_11863 == null) {
            return;
        }
        class_2680 state = this.field_11863.method_8320(this.method_11016());
        BrewMaterial material = (BrewMaterial)((Object)state.method_11654(BlockStateRegistry.MATERIAL));
        boolean overflowUnresolved = this.overflowStarted > this.overflowSolved;
        int failed = Math.max(0, this.totalEvents - this.solved);
        boolean bl = highFailRate = this.totalEvents > 0 && failed * 2 > this.totalEvents;
        int count = highFailRate ? this.field_11863.method_8409().method_43051(2, 4) : (overflowUnresolved ? (material == BrewMaterial.COPPER ? 1 : 2) : 0);
        if (count <= 0) {
            return;
        }
        class_2338 base = BrewHelper.getBlock((class_2248)ObjectRegistry.BREW_OVEN.get(), this.components, this.field_11863);
        if (base == null) {
            return;
        }
        for (int n = 0; n < count; ++n) {
            BeerElementalEntity e = new BeerElementalEntity((class_1299<? extends class_1588>)((class_1299)EntityTypeRegistry.BEER_ELEMENTAL.get()), this.field_11863);
            double ox = (double)this.field_11863.method_8409().method_43051(-1, 2) + 0.5;
            double oz = (double)this.field_11863.method_8409().method_43051(-1, 2) + 0.5;
            e.method_5814((double)base.method_10263() + ox, base.method_10264() + 1, (double)base.method_10260() + oz);
            e.method_6033(20.0f);
            this.field_11863.method_8649((class_1297)e);
            this.field_11863.method_8396(null, e.method_24515(), this.spawnEntitySound, class_3419.field_15245, 1.0f, 1.0f);
        }
        this.overflowStarted = 0;
        this.overflowSolved = 0;
    }

    public void onEventFinished(BrewEvent event, boolean success) {
        class_2960 id = BrewEvents.getId(event);
        if (id == null) {
            return;
        }
        if (id.equals((Object)BrewEvents.KETTLE_EVENT) && success) {
            ++this.overflowSolved;
        }
    }

    private int computeEventQuota() {
        BrewMaterial material = (BrewMaterial)((Object)this.method_11010().method_11654(BlockStateRegistry.MATERIAL));
        assert (this.field_11863 != null);
        class_5819 rnd = this.field_11863.method_8409();
        return switch (material) {
            default -> throw new MatchException(null, null);
            case BrewMaterial.WOOD -> rnd.method_43051(8, 13);
            case BrewMaterial.COPPER -> rnd.method_43051(4, 7);
            case BrewMaterial.NETHERITE -> rnd.method_43051(1, 3);
        };
    }

    public void endBrewing() {
        BrewHelper.finishEvents(this);
        this.brewTime = 0;
        this.totalEvents = 0;
        this.soundTime = 60;
        this.timeToNextEvent = Integer.MIN_VALUE;
        this.eventQuota = -1;
        this.overflowStarted = 0;
        this.overflowSolved = 0;
    }

    public boolean isPartOf(class_2338 blockPos) {
        return this.components.contains(blockPos);
    }

    public void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        if (!this.components.isEmpty()) {
            GeneralUtil.putBlockPoses((class_2487)compoundTag, this.components);
        }
        class_1262.method_5426((class_2487)compoundTag, this.ingredients, (class_7225.class_7874)provider);
        if (!this.beer.method_7960()) {
            compoundTag.method_10566("beer", this.beer.method_57376(provider, (class_2520)new class_2487()));
        }
        compoundTag.method_10569("solved", this.solved);
        compoundTag.method_10569("brewTime", this.brewTime);
        compoundTag.method_10569("totalEvents", this.totalEvents);
        compoundTag.method_10569("timeToNextEvent", this.timeToNextEvent);
        compoundTag.method_10569("eventQuota", this.eventQuota);
        compoundTag.method_10569("overflowStarted", this.overflowStarted);
        compoundTag.method_10569("overflowSolved", this.overflowSolved);
        BrewHelper.saveAdditional(this, compoundTag);
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        this.components = GeneralUtil.readBlockPoses((class_2487)compoundTag);
        this.ingredients = class_2371.method_10213((int)3, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compoundTag, this.ingredients, (class_7225.class_7874)provider);
        if (compoundTag.method_10545("beer")) {
            this.beer = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)compoundTag.method_10562("beer"));
        }
        this.solved = compoundTag.method_10550("solved");
        this.brewTime = compoundTag.method_10550("brewTime");
        this.totalEvents = compoundTag.method_10550("totalEvents");
        this.timeToNextEvent = compoundTag.method_10550("timeToNextEvent");
        this.eventQuota = compoundTag.method_10550("eventQuota");
        this.overflowStarted = compoundTag.method_10550("overflowStarted");
        this.overflowSolved = compoundTag.method_10550("overflowSolved");
        BrewHelper.load(this, compoundTag);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 compoundTag = new class_2487();
        this.method_11007(compoundTag, provider);
        return compoundTag;
    }

    public void growSolved() {
        ++this.solved;
    }

    public Set<BrewEvent> getRunningEvents() {
        return this.runningEvents;
    }

    @NotNull
    public Set<class_2338> getComponents() {
        return this.components;
    }

    public List<class_1799> getIngredient() {
        return this.ingredients;
    }

    public class_2371<class_1799> getItems() {
        return this.ingredients;
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @Nullable
    private class_8786<BrewingRecipe> findActiveRecipe(class_1937 level) {
        List recipeHolders = level.method_8433().method_30027((class_3956)RecipeTypeRegistry.BREWING_RECIPE_TYPE.get());
        for (class_8786 holder : recipeHolders) {
            BrewingRecipe r = (BrewingRecipe)holder.comp_1933();
            if (!this.canBrew(r) || !this.ingredientsMatch(r)) continue;
            return holder;
        }
        return null;
    }

    private boolean ingredientsMatch(BrewingRecipe recipe) {
        class_2371<class_1856> req = recipe.method_8117();
        boolean[] used = new boolean[this.ingredients.size()];
        int matched = 0;
        for (class_1856 ing : req) {
            boolean found = false;
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (used[i] || !ing.method_8093((class_1799)this.ingredients.get(i))) continue;
                used[i] = true;
                found = true;
                ++matched;
                break;
            }
            if (found) continue;
            return false;
        }
        return matched == req.size();
    }
}

