/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.event;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.LootEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3855;
import net.minecraft.class_3966;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.satisfy.brewery.core.event.LoottableInjector;
import net.satisfy.brewery.core.registry.MobEffectRegistry;
import org.jetbrains.annotations.Nullable;

public class CommonEvents {
    private static final String HALEY_ACTIVE = "brewery:haley_active";
    private static final String HALEY_SET_MAYFLY = "brewery:haley_set_mayfly";

    public static void init() {
        LootEvent.MODIFY_LOOT_TABLE.register(CommonEvents::onModifyLootTable);
        PlayerEvent.ATTACK_ENTITY.register(CommonEvents::onPlayerAttack);
        TickEvent.PLAYER_PRE.register(CommonEvents::tickHaley);
    }

    public static void onModifyLootTable(class_5321<class_52> key, LootEvent.LootTableModificationContext context, boolean builtin) {
        LoottableInjector.InjectLoot(key, context);
    }

    public static EventResult onPlayerAttack(class_1657 player, class_1937 level, class_1297 target, class_1268 hand, @Nullable class_3966 result) {
        if (player.method_6059(class_7923.field_41174.method_47983((Object)((class_1291)MobEffectRegistry.PROTECTIVETOUCH.get())))) {
            CommonEvents.handleProtectiveTouch(level, target);
            return EventResult.interruptFalse();
        }
        if (player.method_6059(class_7923.field_41174.method_47983((Object)((class_1291)MobEffectRegistry.HEALINGTOUCH.get())))) {
            CommonEvents.handleHealingTouch(level, target);
            return EventResult.interruptFalse();
        }
        if (player.method_6059(class_7923.field_41174.method_47983((Object)((class_1291)MobEffectRegistry.RENEWINGTOUCH.get())))) {
            CommonEvents.handleRenewingTouch(level, target);
            return EventResult.interruptFalse();
        }
        if (player.method_6059(class_7923.field_41174.method_47983((Object)((class_1291)MobEffectRegistry.TOXICTOUCH.get())))) {
            CommonEvents.handleToxicTouch(level, target);
            return EventResult.pass();
        }
        if (player.method_6059(class_7923.field_41174.method_47983((Object)((class_1291)MobEffectRegistry.LIGHTNING_STRIKE.get())))) {
            CommonEvents.handlelightningStrike(level, target);
            return EventResult.pass();
        }
        if (player.method_6059(class_7923.field_41174.method_47983((Object)((class_1291)MobEffectRegistry.EXPLOSION.get())))) {
            CommonEvents.handleExplosiveTouch(level, target, player);
            return EventResult.pass();
        }
        return EventResult.pass();
    }

    private static void tickHaley(class_1657 player) {
        if (player.method_37908().field_9236) {
            return;
        }
        if (player.method_7337() || player.method_7325()) {
            return;
        }
        boolean has = player.method_6059(class_7923.field_41174.method_47983((Object)((class_1291)MobEffectRegistry.HALEY.get())));
        if (has) {
            if (!player.method_5752().contains(HALEY_ACTIVE)) {
                player.method_5780(HALEY_ACTIVE);
                if (!player.method_31549().field_7478) {
                    player.method_5780(HALEY_SET_MAYFLY);
                    player.method_31549().field_7478 = true;
                    player.method_7355();
                }
            }
        } else if (player.method_5752().contains(HALEY_ACTIVE)) {
            player.method_5738(HALEY_ACTIVE);
            if (player.method_5752().contains(HALEY_SET_MAYFLY)) {
                player.method_5738(HALEY_SET_MAYFLY);
                if (player.method_31549().field_7478 || player.method_31549().field_7479) {
                    player.method_31549().field_7478 = false;
                    player.method_31549().field_7479 = false;
                    player.method_7355();
                }
            }
        }
    }

    private static void handleRenewingTouch(class_1937 level, class_1297 target) {
        if (target instanceof class_1309) {
            class_1309 entity = (class_1309)target;
            entity.method_6092(new class_1293(class_1294.field_5924, 200, 1));
            CommonEvents.spawnParticles(level, (class_1297)entity, (class_2394)class_2398.field_17741);
        }
    }

    private static void handleProtectiveTouch(class_1937 level, class_1297 target) {
        if (target instanceof class_1309) {
            class_1309 entity = (class_1309)target;
            entity.method_6092(new class_1293(class_1294.field_5898, 200, 1));
            CommonEvents.spawnParticles(level, (class_1297)entity, (class_2394)class_2398.field_28478);
        }
    }

    private static void handleToxicTouch(class_1937 level, class_1297 target) {
        if (target instanceof class_1309) {
            class_1309 entity = (class_1309)target;
            entity.method_6092(new class_1293(class_1294.field_5899, 300, 2));
            CommonEvents.spawnParticles(level, (class_1297)entity, (class_2394)class_2398.field_29645);
        }
    }

    private static void handleHealingTouch(class_1937 level, class_1297 target) {
        if (target instanceof class_1309) {
            class_1309 entity = (class_1309)target;
            ((class_1309)target).method_6025(6.0f);
            CommonEvents.spawnParticles(level, (class_1297)entity, (class_2394)class_2398.field_11201);
        }
    }

    private static void handlelightningStrike(class_1937 level, class_1297 target) {
        float chance;
        float f = chance = level.method_8546() ? 0.75f : 0.1f;
        if (level.field_9229.method_43057() < chance) {
            class_1538 lightningBolt = new class_1538(class_1299.field_6112, level);
            lightningBolt.method_24203(target.method_23317(), target.method_23318(), target.method_23321());
            level.method_8649((class_1297)lightningBolt);
        }
    }

    private static void handleExplosiveTouch(class_1937 level, class_1297 target, class_1657 player) {
        if ((double)level.field_9229.method_43057() < 0.1) {
            class_3855 fireball = (class_3855)class_1299.field_6066.method_5883(level);
            double dx = target.method_23317() - player.method_23317();
            double dy = target.method_23318() + (double)(target.method_17682() / 2.0f) - (player.method_23318() + (double)(player.method_17682() / 2.0f));
            double dz = target.method_23321() - player.method_23321();
            assert (fireball != null);
            fireball.method_5814(player.method_23317(), player.method_23318() + (double)(player.method_17682() / 2.0f), player.method_23321());
            fireball.method_7485(dx, dy, dz, 1.5f, 0.0f);
            level.method_8649((class_1297)fireball);
        }
    }

    private static void spawnParticles(class_1937 level, class_1297 target, class_2394 particleType) {
        double height = target.method_17682();
        double x = target.method_23317();
        double y = target.method_23318();
        double z = target.method_23321();
        for (double i = 2.5; i >= 1.5; i -= 0.5) {
            level.method_8406(particleType, x, y + height / i, z, 0.0, 0.0, 0.0);
        }
    }
}

