/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.event.brew_event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.satisfy.brewery.core.block.BrewKettleBlock;
import net.satisfy.brewery.core.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.core.block.property.Liquid;
import net.satisfy.brewery.core.event.brew_event.BrewEvent;
import net.satisfy.brewery.core.event.brew_event.BrewEvents;
import net.satisfy.brewery.core.registry.BlockStateRegistry;
import org.jetbrains.annotations.Nullable;

public class BrewHelper {
    @Nullable
    public static class_2338 getBlock(class_2248 block, Set<class_2338> components, class_1937 level) {
        for (class_2338 pos : components) {
            if (level.method_8320(pos).method_26204() != block) continue;
            return pos;
        }
        return null;
    }

    @Nullable
    public static class_2338 getBlock(Class<?> clazz, Set<class_2338> components, class_1937 level) {
        for (class_2338 pos : components) {
            if (!clazz.isInstance(level.method_8320(pos).method_26204())) continue;
            return pos;
        }
        return null;
    }

    public static List<class_2960> possibleEvents(BrewstationBlockEntity entity) {
        ArrayList<class_2960> possibleEvents = new ArrayList<class_2960>();
        List<class_2960> runningEvents = BrewEvents.toLocations(entity.getRunningEvents());
        for (class_2960 event : BrewEvents.BREW_EVENTS.keySet()) {
            boolean canAdd = true;
            if (runningEvents.contains(event)) {
                canAdd = false;
            } else {
                for (class_2960 runningEvent : runningEvents) {
                    if (!BrewHelper.conflictsWith(event, runningEvent)) continue;
                    canAdd = false;
                    break;
                }
            }
            if (!canAdd) continue;
            possibleEvents.add(event);
        }
        return possibleEvents;
    }

    private static boolean conflictsWith(class_2960 event1, class_2960 event2) {
        return event1.equals((Object)BrewEvents.WHISTLE_EVENT) && event2.equals((Object)BrewEvents.KETTLE_EVENT) || event1.equals((Object)BrewEvents.KETTLE_EVENT) && event2.equals((Object)BrewEvents.WHISTLE_EVENT);
    }

    public static BrewEvent getRdmEvent(BrewstationBlockEntity entity) {
        List<class_2960> possibleEvents = BrewHelper.possibleEvents(entity);
        if (possibleEvents.isEmpty()) {
            return null;
        }
        class_2960 eventLocation = possibleEvents.get(Objects.requireNonNull(entity.method_10997()).method_8409().method_43048(possibleEvents.size()));
        Supplier<BrewEvent> type = BrewEvents.byId(eventLocation);
        assert (type != null);
        BrewEvent event = type.get();
        event.setTimeForEvent(entity.method_10997().method_8409().method_43051(160, 400));
        return event;
    }

    public static void finishEvents(BrewstationBlockEntity entity) {
        Set<BrewEvent> eventSet = entity.getRunningEvents();
        if (eventSet.isEmpty()) {
            return;
        }
        Iterator<BrewEvent> iterator = eventSet.iterator();
        while (iterator.hasNext()) {
            BrewEvent event = iterator.next();
            if (event == null) continue;
            BrewHelper.endEvent(entity, iterator, event);
        }
    }

    public static void checkRunningEvents(BrewstationBlockEntity entity) {
        Set<BrewEvent> eventSet = entity.getRunningEvents();
        if (eventSet.isEmpty()) {
            return;
        }
        Iterator<BrewEvent> iterator = eventSet.iterator();
        while (iterator.hasNext()) {
            BrewEvent event = iterator.next();
            if (event == null) continue;
            event.tick(entity);
            if (event.isFinish(entity.getComponents(), entity.method_10997())) {
                entity.onEventFinished(event, true);
                BrewHelper.endEvent(entity, iterator, event);
                entity.growSolved();
                continue;
            }
            if (event.getTimeLeft() > 0) continue;
            entity.onEventFinished(event, false);
            BrewHelper.endEvent(entity, iterator, event);
        }
    }

    public static void endEvent(BrewstationBlockEntity entity, Iterator<BrewEvent> iterator, BrewEvent event) {
        if (event == null) {
            return;
        }
        event.finish(entity.getComponents(), entity.method_10997());
        iterator.remove();
    }

    public static void saveAdditional(BrewstationBlockEntity entity, class_2487 compoundTag) {
        Set<BrewEvent> events = entity.getRunningEvents();
        if (events.isEmpty()) {
            return;
        }
        class_2499 list = new class_2499();
        for (BrewEvent event : events) {
            class_2487 tag = event.save(new class_2487());
            tag.method_10582("id", Objects.requireNonNull(BrewEvents.getId(event)).toString());
            tag.method_10569("timeLeft", event.getTimeLeft());
            list.add((Object)tag);
        }
        compoundTag.method_10566("runningEvents", (class_2520)list);
    }

    public static void load(BrewstationBlockEntity entity, class_2487 compoundTag) {
        if (!compoundTag.method_10545("runningEvents")) {
            return;
        }
        class_2499 list = compoundTag.method_10554("runningEvents", 10);
        for (class_2520 tag : list) {
            class_2487 cTag;
            String id;
            class_2960 location;
            Supplier<BrewEvent> type;
            if (!(tag instanceof class_2487) || (type = BrewEvents.byId(location = class_2960.method_12829((String)(id = (cTag = (class_2487)tag).method_10558("id"))))) == null) continue;
            BrewEvent event = type.get();
            event.load(compoundTag);
            event.setTimeForEvent(cTag.method_10550("timeLeft"));
            entity.getRunningEvents().add(event);
        }
    }

    public static void resetWater(Set<class_2338> components, class_1937 level) {
        if (components == null || level == null) {
            return;
        }
        class_2338 basinPos = BrewHelper.getBlock(BrewKettleBlock.class, components, level);
        if (basinPos != null) {
            class_2680 basinState = level.method_8320(basinPos);
            Liquid liquid = (Liquid)((Object)basinState.method_11654(BlockStateRegistry.LIQUID));
            if (liquid.equals((Object)Liquid.FILLED)) {
                return;
            }
            level.method_8501(basinPos, (class_2680)basinState.method_11657(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.FILLED)));
        }
    }
}

