/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5328;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.satisfy.brewery.core.block.entity.StorageBlockEntity;
import net.satisfy.brewery.core.registry.MobEffectRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrinkBlockItem
extends class_1747 {
    private final class_1291 effect;
    private final int baseDuration;

    public DrinkBlockItem(class_1291 effect, int duration, class_2248 block, class_1792.class_1793 settings) {
        super(block, settings);
        this.effect = effect;
        this.baseDuration = duration;
    }

    public static void addQuality(class_1799 itemStack, int quality) {
        ((class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10569("brewery.beer_quality", Math.min(Math.max(quality, 1), 3));
    }

    protected class_2680 method_7707(class_1750 context) {
        if (!Objects.requireNonNull(context.method_8036()).method_18276()) {
            return null;
        }
        class_2680 blockState = this.method_7711().method_9605(context);
        return blockState != null && this.method_7709(context, blockState) ? blockState : null;
    }

    protected boolean method_7710(class_2338 blockPos, class_1937 level, @Nullable class_1657 player, class_1799 itemStack, class_2680 blockState) {
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof StorageBlockEntity) {
            StorageBlockEntity beerEntity = (StorageBlockEntity)class_25862;
            beerEntity.setStack(0, itemStack.method_46651(1));
        }
        return super.method_7710(blockPos, level, player, itemStack, blockState);
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        return class_5328.method_29282((class_1937)level, (class_1657)player, (class_1268)interactionHand);
    }

    @NotNull
    public class_1799 method_7861(class_1799 itemStack, class_1937 level, class_1309 livingEntity) {
        class_1657 player;
        class_1799 returnStack = super.method_7861(itemStack, level, livingEntity);
        if (livingEntity instanceof class_1657 && !(player = (class_1657)livingEntity).method_7337()) {
            player.method_7270(new class_1799((class_1935)ObjectRegistry.BEER_MUG.get()));
        }
        if (livingEntity instanceof class_3222) {
            int quality;
            class_3222 serverPlayer = (class_3222)livingEntity;
            int n = quality = itemStack.method_57826(class_9334.field_49628) && Objects.requireNonNull((class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57450("brewery.beer_quality") ? ((class_9279)itemStack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10550("brewery.beer_quality") : 1;
            int durationMultiplier = quality == 2 ? 3 : (quality == 3 ? 5 : 1);
            class_6880 holder = class_7923.field_41174.method_47983((Object)this.effect);
            class_1293 current = serverPlayer.method_6112(holder);
            int currentAmp = current != null ? current.method_5578() : -1;
            int newAmp = class_3532.method_15340((int)(currentAmp + 1), (int)0, (int)5);
            serverPlayer.method_6092(new class_1293(holder, this.baseDuration * durationMultiplier, newAmp));
            class_6880<class_1291> drunkHolder = MobEffectRegistry.holder(MobEffectRegistry.DRUNK);
            class_1293 drunkCurrent = serverPlayer.method_6112(drunkHolder);
            int drunkAmp = drunkCurrent != null ? drunkCurrent.method_5578() : -1;
            int newDrunkAmp = class_3532.method_15340((int)(drunkAmp + 1), (int)0, (int)5);
            int min = 1800;
            int max = quality == 1 ? 9600 : (quality == 2 ? 6000 : 3600);
            int drunkDuration = class_3532.method_15395((class_5819)level.method_8409(), (int)min, (int)max);
            serverPlayer.method_6092(new class_1293(drunkHolder, drunkDuration, newDrunkAmp));
        }
        return returnStack;
    }

    @NotNull
    private class_1293 calculateEffectForQuality(int quality) {
        int durationMultiplier = 1;
        int effectLevel = switch (quality) {
            case 2 -> {
                durationMultiplier = 3;
                yield 2;
            }
            case 3 -> {
                durationMultiplier = 5;
                yield 3;
            }
            default -> 1;
        };
        return new class_1293(class_7923.field_41174.method_47983((Object)this.effect), this.baseDuration * durationMultiplier, effectLevel - 1);
    }

    public void addCount(class_1799 resultSack, int solved) {
        resultSack.method_7939(solved);
    }

    @NotNull
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    public int method_7881(class_1799 stack, class_1309 entity) {
        return 32;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        int effectLevel;
        int beerQuality = stack.method_57826(class_9334.field_49628) && Objects.requireNonNull((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57450("brewery.beer_quality") ? ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10550("brewery.beer_quality") : 1;
        int durationMultiplier = 1;
        switch (beerQuality) {
            case 2: {
                durationMultiplier = 3;
                int n = 2;
                break;
            }
            case 3: {
                durationMultiplier = 5;
                int n = 3;
                break;
            }
            default: {
                int n = effectLevel = 1;
            }
        }
        if (this.effect != null) {
            class_5250 effectName = class_2561.method_43471((String)this.effect.method_5567());
            if (effectLevel > 1) {
                effectName.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)("potion.potency." + (effectLevel - 1))));
            }
            int seconds = this.baseDuration * durationMultiplier / 20;
            class_5250 effectDuration = class_2561.method_43470((String)(" (" + seconds + "s)"));
            tooltip.add((class_2561)effectName.method_10852((class_2561)effectDuration).method_27692(this.effect.method_18792().method_18793()));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
        }
        if (beerQuality > 1) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.brewery.beer_quality", (Object[])new Object[]{beerQuality}).method_27692(class_124.field_1065));
        }
    }
}

