/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.satisfy.brewery.core.block.property.BrewMaterial;
import net.satisfy.brewery.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class BrewingRecipe
implements class_1860<class_9695> {
    private final class_2371<class_1856> ingredients;
    private final class_1799 output;
    private final BrewMaterial material;

    public BrewingRecipe(class_2371<class_1856> ingredients, class_1799 output, BrewMaterial material) {
        this.ingredients = ingredients;
        this.output = output;
        this.material = material;
    }

    public BrewMaterial getMaterial() {
        return this.material;
    }

    public boolean method_8115(class_9695 inventory, class_1937 world) {
        class_1662 recipeMatcher = new class_1662();
        int matchingStacks = 0;
        for (int i = 0; i < 3; ++i) {
            class_1799 itemStack = inventory.method_59984(i);
            if (itemStack.method_7960()) continue;
            ++matchingStacks;
            recipeMatcher.method_20478(itemStack, 1);
        }
        return matchingStacks == this.ingredients.size() && recipeMatcher.method_7402((class_1860)this, null);
    }

    @NotNull
    public class_1799 method_8116(class_9695 recipeInput, class_7225.class_7874 provider) {
        return class_1799.field_8037;
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    @NotNull
    public class_1799 method_8110(class_7225.class_7874 provider) {
        return this.output.method_7972();
    }

    @NotNull
    public class_2960 getId() {
        return RecipeTypeRegistry.BREWING_RECIPE_TYPE.getId();
    }

    @NotNull
    public class_1865<?> method_8119() {
        return (class_1865)RecipeTypeRegistry.BREWING_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return (class_3956)RecipeTypeRegistry.BREWING_RECIPE_TYPE.get();
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<BrewingRecipe> {
        public static final class_9139<class_9129, BrewingRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);
        private static final MapCodec<BrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1856.field_46096.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (class_1856[])list.stream().filter(ingredient -> !ingredient.method_8103()).toArray(class_1856[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for Brewing recipe");
            }
            return ingredients.length > 3 ? DataResult.error(() -> "Too many ingredients for Brewing recipe") : DataResult.success((Object)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
        }, DataResult::success).forGetter(bakingStationRecipe -> bakingStationRecipe.ingredients), (App)class_1799.field_51397.fieldOf("result").forGetter(bakingStationRecipe -> bakingStationRecipe.output), (App)Codec.STRING.fieldOf("material").forGetter(brewingRecipe -> brewingRecipe.material.toString())).apply((Applicative)instance, (ingredients1, stack, string) -> new BrewingRecipe((class_2371<class_1856>)ingredients1, (class_1799)stack, BrewMaterial.valueOf(string))));

        @NotNull
        public static BrewingRecipe fromNetwork(class_9129 buf) {
            int i = buf.method_10816();
            class_2371 nonNullList = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            nonNullList.replaceAll(ingredient -> (class_1856)class_1856.field_48355.decode((Object)buf));
            class_1799 itemStack = (class_1799)class_1799.field_48349.decode((Object)buf);
            BrewMaterial material = (BrewMaterial)buf.method_10818(BrewMaterial.class);
            return new BrewingRecipe((class_2371<class_1856>)nonNullList, itemStack, material);
        }

        public static void toNetwork(class_9129 buf, BrewingRecipe recipe) {
            buf.method_10804(recipe.ingredients.size());
            for (class_1856 ingredient : recipe.ingredients) {
                class_1856.field_48355.encode((Object)buf, (Object)ingredient);
            }
            class_1799.field_48349.encode((Object)buf, (Object)recipe.output);
            buf.method_10817((Enum)recipe.material);
        }

        @NotNull
        public MapCodec<BrewingRecipe> method_53736() {
            return CODEC;
        }

        @NotNull
        public class_9139<class_9129, BrewingRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

