/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_5599;
import net.minecraft.class_630;
import net.minecraft.class_746;
import net.satisfy.brewery.client.model.BrewfestBootsModel;
import net.satisfy.brewery.client.model.BrewfestChestplateModel;
import net.satisfy.brewery.client.model.BrewfestHatModel;
import net.satisfy.brewery.client.model.BrewfestLeggingsModel;
import net.satisfy.brewery.core.item.BrewfestBootsItem;
import net.satisfy.brewery.core.item.BrewfestChestItem;
import net.satisfy.brewery.core.item.BrewfestHatItem;
import net.satisfy.brewery.core.item.BrewfestLegsItem;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ArmorRegistry {
    private static final Map<class_1792, BrewfestHatModel<?>> models = new HashMap();
    private static final Map<class_1792, BrewfestChestplateModel<?>> chestplateModels = new HashMap();
    private static final Map<class_1792, BrewfestLeggingsModel<?>> leggingsModels = new HashMap();
    private static final Map<class_1792, BrewfestBootsModel<?>> bootsModels = new HashMap();

    public static class_3879 getHatModel(class_1792 item, class_630 baseHead) {
        class_5599 modelSet = class_310.method_1551().method_31974();
        BrewfestHatModel model = models.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.BREWFEST_HAT_RED.get() || key == ObjectRegistry.BREWFEST_HAT.get()) {
                return new BrewfestHatModel(modelSet.method_32072(BrewfestHatModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyHead(baseHead);
        }
        return model;
    }

    public static class_3879 getChestplateModel(class_1792 item, class_630 body, class_630 leftArm, class_630 rightArm, class_630 leftLeg, class_630 rightLeg) {
        BrewfestChestplateModel model = chestplateModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.BREWFEST_BLOUSE.get() || key == ObjectRegistry.BREWFEST_REGALIA.get()) {
                return new BrewfestChestplateModel(class_310.method_1551().method_31974().method_32072(BrewfestChestplateModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyBody(body, leftArm, rightArm, leftLeg, rightLeg);
        }
        return model;
    }

    public static class_3879 getLeggingsModel(class_1792 item, class_630 rightLeg, class_630 leftLeg) {
        BrewfestLeggingsModel model = leggingsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.BREWFEST_DRESS.get() || key == ObjectRegistry.BREWFEST_TROUSERS.get()) {
                return new BrewfestLeggingsModel(class_310.method_1551().method_31974().method_32072(BrewfestLeggingsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }

    public static class_3879 getBootsModel(class_1792 item, class_630 rightLeg, class_630 leftLeg) {
        BrewfestBootsModel model = bootsModels.computeIfAbsent(item, key -> {
            if (key == ObjectRegistry.BREWFEST_BOOTS.get() || key == ObjectRegistry.BREWFEST_SHOES.get()) {
                return new BrewfestBootsModel(class_310.method_1551().method_31974().method_32072(BrewfestBootsModel.LAYER_LOCATION));
            }
            return null;
        });
        if (model != null) {
            model.copyLegs(rightLeg, leftLeg);
        }
        return model;
    }

    public static void appendToolTip(@NotNull List<class_2561> tooltip) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1799 helmet = player.method_6118(class_1304.field_6169);
        class_1799 chestplate = player.method_6118(class_1304.field_6174);
        class_1799 leggings = player.method_6118(class_1304.field_6172);
        class_1799 boots = player.method_6118(class_1304.field_6166);
        boolean hasFullSet = helmet.method_7909() instanceof BrewfestHatItem && chestplate.method_7909() instanceof BrewfestChestItem && leggings.method_7909() instanceof BrewfestLegsItem && boots.method_7909() instanceof BrewfestBootsItem;
        tooltip.add((class_2561)class_2561.method_43473());
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.brewery.armor.brewfest_set").method_27692(class_124.field_1054));
        tooltip.add(ArmorRegistry.createArmorTooltipEntry(helmet, BrewfestHatItem.class, "tooltip.brewery.armor.brewfesthelmet"));
        tooltip.add(ArmorRegistry.createArmorTooltipEntry(chestplate, BrewfestChestItem.class, "tooltip.brewery.armor.brewfestbreastplate"));
        tooltip.add(ArmorRegistry.createArmorTooltipEntry(leggings, BrewfestLegsItem.class, "tooltip.brewery.armor.brewfestleggings"));
        tooltip.add(ArmorRegistry.createArmorTooltipEntry(boots, BrewfestBootsItem.class, "tooltip.brewery.armor.brewfestboots"));
        tooltip.add((class_2561)class_2561.method_43470((String)""));
        class_124 color = hasFullSet ? class_124.field_1060 : class_124.field_1080;
    }

    private static class_2561 createArmorTooltipEntry(class_1799 itemStack, Class<?> itemClass, String translationKey) {
        boolean isWorn = itemClass.isInstance(itemStack.method_7909());
        class_124 color = isWorn ? class_124.field_1060 : class_124.field_1080;
        return class_2561.method_43470((String)"- ").method_10852((class_2561)class_2561.method_43471((String)translationKey).method_27692(color));
    }
}

