/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1588;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.core.block.entity.BeerMugBlockEntity;
import net.satisfy.brewery.core.block.entity.BrewstationBlockEntity;
import net.satisfy.brewery.core.block.entity.CabinetBlockEntity;
import net.satisfy.brewery.core.block.entity.CompletionistBannerEntity;
import net.satisfy.brewery.core.block.entity.StorageBlockEntity;
import net.satisfy.brewery.core.block.entity.WallDecorationBlockEntity;
import net.satisfy.brewery.core.entity.BeerElementalAttackEntity;
import net.satisfy.brewery.core.entity.BeerElementalEntity;
import net.satisfy.brewery.core.entity.DarkBrewEntity;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.brewery.core.registry.StorageTypeRegistry;

public class EntityTypeRegistry {
    private static final DeferredRegister<class_2591<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"brewery", (class_5321)class_7924.field_41255);
    private static final DeferredRegister<class_1299<?>> ENTITY_TYPES = DeferredRegister.create((String)"brewery", (class_5321)class_7924.field_41266);
    public static final RegistrySupplier<class_1299<DarkBrewEntity>> DARK_BREW = EntityTypeRegistry.registerEntityType("dark_brew", () -> class_1299.class_1300.method_5903(DarkBrewEntity::new, (class_1311)class_1311.field_17715).method_17687(0.5f, 0.5f).method_5905(Brewery.identifier("dark_brew").toString()));
    public static final RegistrySupplier<class_1299<BeerElementalEntity>> BEER_ELEMENTAL = EntityTypeRegistry.registerEntityType("beer_elemental", () -> class_1299.class_1300.method_5903(BeerElementalEntity::new, (class_1311)class_1311.field_6302).method_17687(1.0f, 1.6f).method_27299(80).method_27300(3).method_5905(Brewery.identifier("beer_elemental").toString()));
    public static final RegistrySupplier<class_1299<BeerElementalAttackEntity>> BEER_ELEMENTAL_ATTACK = EntityTypeRegistry.registerEntityType("beer_elemental_attack", () -> class_1299.class_1300.method_5903(BeerElementalAttackEntity::new, (class_1311)class_1311.field_17715).method_17687(0.3125f, 0.3125f).method_27299(4).method_27300(10).method_5905(Brewery.identifier("beer_elemental_attack").toString()));
    public static final RegistrySupplier<class_2591<BrewstationBlockEntity>> BREWINGSTATION_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("brewingstation", () -> class_2591.class_2592.method_20528(BrewstationBlockEntity::new, (class_2248[])new class_2248[]{(class_2248)ObjectRegistry.WOODEN_BREWINGSTATION.get(), (class_2248)ObjectRegistry.COPPER_BREWINGSTATION.get(), (class_2248)ObjectRegistry.NETHERITE_BREWINGSTATION.get()}).method_11034(null));
    public static final RegistrySupplier<class_2591<BeerMugBlockEntity>> BEER_MUG_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("beer_mug", () -> class_2591.class_2592.method_20528(BeerMugBlockEntity::new, (class_2248[])new class_2248[]{(class_2248)ObjectRegistry.BEER_MUG.get()}).method_11034(null));
    public static final RegistrySupplier<class_2591<StorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> class_2591.class_2592.method_20528(StorageBlockEntity::new, (class_2248[])StorageTypeRegistry.registerBlocks(new HashSet<class_2248>()).toArray(new class_2248[0])).method_11034(null));
    public static final RegistrySupplier<class_2591<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> class_2591.class_2592.method_20528(CabinetBlockEntity::new, (class_2248[])EntityTypeRegistry.addCabinet(new HashSet<class_2248>()).toArray(new class_2248[0])).method_11034(null));
    public static final RegistrySupplier<class_2591<CompletionistBannerEntity>> BREWERY_BANNER = EntityTypeRegistry.registerBlockEntity("brewery_banner", () -> class_2591.class_2592.method_20528(CompletionistBannerEntity::new, (class_2248[])new class_2248[]{(class_2248)ObjectRegistry.BREWERY_BANNER.get(), (class_2248)ObjectRegistry.BREWERY_WALL_BANNER.get()}).method_11034(null));
    public static final RegistrySupplier<class_2591<WallDecorationBlockEntity>> WALL_DECORATION = EntityTypeRegistry.registerBlockEntity("wall_decoration", () -> class_2591.class_2592.method_20528(WallDecorationBlockEntity::new, (class_2248[])new class_2248[]{(class_2248)ObjectRegistry.GINGERBREAD.get()}).method_11034(null));

    public static Set<class_2248> addCabinet(Set<class_2248> blocks) {
        blocks.add((class_2248)ObjectRegistry.CABINET.get());
        blocks.add((class_2248)ObjectRegistry.DRAWER.get());
        blocks.add((class_2248)ObjectRegistry.SIDEBOARD.get());
        blocks.add((class_2248)ObjectRegistry.WALL_CABINET.get());
        return blocks;
    }

    public static void registerBeerElemental(Supplier<? extends class_1299<? extends class_1588>> typeSupplier) {
        EntityAttributeRegistry.register(typeSupplier, BeerElementalEntity::createAttributes);
    }

    private static <T extends class_2591<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(Brewery.identifier(path), type);
    }

    private static <T extends class_1299<?>> RegistrySupplier<T> registerEntityType(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(Brewery.identifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
        EntityTypeRegistry.registerBeerElemental(BEER_ELEMENTAL);
    }
}

