package archives.tater.savepoint.mixin;

import archives.tater.savepoint.SavePoint;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@SuppressWarnings("UnstableApiUsage")
@Mixin(class_1661.class)
public class PlayerInventoryMixin {
    @Shadow @Final public class_1657 player;

    @Inject(
            method = "dropAll",
            at = @At("HEAD")
    )
    private void copySavedItems(CallbackInfo ci) {
        if (player instanceof class_3222 serverPlayer)
            SavePoint.getDirtyOrSet(serverPlayer);
    }

    @ModifyArg(
            method = "dropAll",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;dropItem(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/ItemEntity;"),
            index = 0
    )
    private class_1799 processSaved(class_1799 stack, @Share("keptItem") LocalRef<class_1799> keptItem) {
        var savedDirty = player.getAttached(SavePoint.SAVED_INVENTORY_DIRTY);
        if (savedDirty == null) {
            keptItem.set(class_1799.field_8037);
            return stack;
        }
        keptItem.set(stack.method_7971(SavePoint.getAmountKept(stack, savedDirty)));
        return stack;
    }

    @SuppressWarnings("unchecked")
    @ModifyArg(
            method = "dropAll",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/util/collection/DefaultedList;set(ILjava/lang/Object;)Ljava/lang/Object;"),
            index = 1
    )
    private <E> E setKept(E e, @Share("keptItem") LocalRef<class_1799> keptItem) {
        return (E) keptItem.get();
    }
}
