package archives.tater.savepoint.mixin;

import archives.tater.savepoint.SavePoint;
import net.minecraft.class_1282;
import net.minecraft.class_3222;
import net.minecraft.class_3222.class_10766;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin {
	@Inject(
			method = "setSpawnPoint",
			at = @At("TAIL")
	)
	private void saveInventory(@Nullable class_10766 respawn, boolean sendMessage, CallbackInfo ci) {
		if (respawn != null && sendMessage)
			SavePoint.saveInventory((class_3222) (Object) this);
	}


	@Inject(
			method = "onDeath",
			at = @At("HEAD")
	)
	private void clearIfSpawnpointMissing(class_1282 damageSource, CallbackInfo ci) {
		SavePoint.checkSpawnpointMissing((class_3222) (Object) this);
	}
}