/*
 * Decompiled with CFR 0.152.
 */
package net.uku3lig.hitrange;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_10055;
import net.minecraft.class_10799;
import net.minecraft.class_12245;
import net.minecraft.class_12247;
import net.minecraft.class_1921;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import net.uku3lig.hitrange.HitRange;
import net.uku3lig.hitrange.config.HitRangeConfig;
import net.uku3lig.hitrange.mixin.RenderTypeAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class CircleRenderer {
    private static final class_1921 LINES = CircleRenderer.makeType(class_10799.field_56833, null);
    private static final class_1921 QUADS = CircleRenderer.makeType(class_10799.field_56865, null);
    private static final Int2ObjectMap<class_1921> PLAYER_TRIANGLE_FANS = new Int2ObjectOpenHashMap();
    private static final List<Angle> angles = new ArrayList<Angle>();

    public static class_1921 getCurrentType(class_10055 state) {
        return switch (((HitRangeConfig)HitRange.getManager().getConfig()).getRenderMode()) {
            default -> throw new MatchException(null, null);
            case HitRangeConfig.RenderMode.LINE -> LINES;
            case HitRangeConfig.RenderMode.THICK -> QUADS;
            case HitRangeConfig.RenderMode.FILLED -> (class_1921)PLAYER_TRIANGLE_FANS.computeIfAbsent(state.field_53528, i -> CircleRenderer.makeType(class_10799.field_56866, String.valueOf(i)));
        };
    }

    public static void drawCircle(class_4587.class_4665 entry, class_4588 vertices, class_10055 state) {
        HitRangeConfig config = (HitRangeConfig)HitRange.getManager().getConfig();
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_243 entityPos = new class_243(state.field_53325, state.field_53326, state.field_53327);
        int color = config.getColor();
        if (config.isRandomColors()) {
            String name = state.field_53525 == null ? "" : state.field_53525.getString();
            color = name.hashCode() | 0xFF000000;
        } else if (config.isColorWhenInRange() && state.field_53528 != player.method_5628() && entityPos.method_24802((class_2374)player.method_73189(), (double)config.getRadius())) {
            color = config.getInRangeColor();
        }
        float dy = (state.field_53334 ? 0.125f : 0.0f) + config.getHeight();
        switch (config.getRenderMode()) {
            case LINE: {
                CircleRenderer.drawCircleLines(entry, vertices, dy, color);
                break;
            }
            case THICK: {
                CircleRenderer.drawCircleQuad(entry, vertices, dy, color);
                break;
            }
            case FILLED: {
                CircleRenderer.drawCircleTriangleFan(entry, vertices, dy, color);
            }
        }
    }

    private static void drawCircleLines(class_4587.class_4665 entry, class_4588 vertices, float dy, int argb) {
        Matrix4f positionMatrix = entry.method_23761();
        for (int i = 1; i < angles.size() + 1; ++i) {
            Angle angle = angles.get(i % angles.size());
            Angle prevAngle = angles.get(i - 1);
            vertices.method_22918((Matrix4fc)positionMatrix, prevAngle.dx, dy, prevAngle.dz).method_39415(argb).method_60831(entry, 0.0f, 0.0f, 0.0f).method_75298(3.0f);
            vertices.method_22918((Matrix4fc)positionMatrix, angle.dx, dy, angle.dz).method_39415(argb).method_60831(entry, 0.0f, 0.0f, 0.0f).method_75298(3.0f);
        }
    }

    private static void drawCircleQuad(class_4587.class_4665 entry, class_4588 vertices, float dy, int argb) {
        Matrix4f positionMatrix = entry.method_23761();
        for (int i = 1; i < angles.size() + 1; ++i) {
            Angle angle = angles.get(i % angles.size());
            Angle prevAngle = angles.get(i - 1);
            vertices.method_22918((Matrix4fc)positionMatrix, prevAngle.dx, dy, prevAngle.dz).method_39415(argb).method_60831(entry, 0.0f, 0.0f, 0.0f);
            vertices.method_22918((Matrix4fc)positionMatrix, prevAngle.farDx, dy, prevAngle.farDz).method_39415(argb).method_60831(entry, 0.0f, 0.0f, 0.0f);
            vertices.method_22918((Matrix4fc)positionMatrix, angle.farDx, dy, angle.farDz).method_39415(argb).method_60831(entry, 0.0f, 0.0f, 0.0f);
            vertices.method_22918((Matrix4fc)positionMatrix, angle.dx, dy, angle.dz).method_39415(argb).method_60831(entry, 0.0f, 0.0f, 0.0f);
        }
    }

    private static void drawCircleTriangleFan(class_4587.class_4665 entry, class_4588 vertices, float dy, int argb) {
        Matrix4f positionMatrix = entry.method_23761();
        vertices.method_22918((Matrix4fc)positionMatrix, 0.0f, dy, 0.0f).method_39415(argb).method_60831(entry, 0.0f, 0.0f, 0.0f);
        for (Angle angle : angles) {
            vertices.method_22918((Matrix4fc)positionMatrix, angle.dx, dy, angle.dz).method_39415(argb).method_60831(entry, 0.0f, 0.0f, 0.0f);
        }
        Angle first = angles.getFirst();
        vertices.method_22918((Matrix4fc)positionMatrix, first.dx, dy, first.dz).method_39415(argb).method_60831(entry, 0.0f, 0.0f, 0.0f);
    }

    public static void computeAngles() {
        angles.clear();
        HitRangeConfig config = (HitRangeConfig)HitRange.getManager().getConfig();
        if (config.getRenderMode() == HitRangeConfig.RenderMode.THICK) {
            for (int i = 0; i < config.getCircleSegments(); ++i) {
                float angle = (float)Math.PI * 2 * ((float)i / (float)config.getCircleSegments());
                float dst = config.getRadius() - config.getThickness() / 2.0f;
                float dx = dst * class_3532.method_15374((double)angle);
                float dz = dst * class_3532.method_15362((double)angle);
                float farDx = (dst + config.getThickness()) * class_3532.method_15374((double)angle);
                float farDz = (dst + config.getThickness()) * class_3532.method_15362((double)angle);
                angles.add(new Angle(dx, dz, farDx, farDz));
            }
        } else {
            for (int i = 0; i < config.getCircleSegments(); ++i) {
                float angle = (float)Math.PI * 2 * ((float)i / (float)config.getCircleSegments());
                float dx = config.getRadius() * class_3532.method_15374((double)angle);
                float dz = config.getRadius() * class_3532.method_15362((double)angle);
                angles.add(new Angle(dx, dz));
            }
        }
    }

    private static class_1921 makeType(RenderPipeline pipeline, @Nullable String postfix) {
        String name = "hitrange_" + pipeline.getClass().getSimpleName().toLowerCase(Locale.ROOT);
        if (postfix != null) {
            name = name + "_" + postfix;
        }
        class_12247 setup = class_12247.method_75927((RenderPipeline)pipeline).method_75937().method_75928().method_75935().method_75930(class_12245.field_63976).method_75938();
        return RenderTypeAccessor.of(name, setup);
    }

    static {
        CircleRenderer.computeAngles();
    }

    private record Angle(float dx, float dz, float farDx, float farDz) {
        public Angle(float dx, float dz) {
            this(dx, dz, 0.0f, 0.0f);
        }
    }
}

