/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush;

import com.candyrush.commands.DebugCommand;
import com.candyrush.commands.DebugCommandTabCompleter;
import com.candyrush.commands.ShopCommand;
import com.candyrush.commands.StatsCommand;
import com.candyrush.commands.StatsCommandTabCompleter;
import com.candyrush.integration.MythicMobsIntegration;
import com.candyrush.listeners.BossDeathListener;
import com.candyrush.listeners.ChunkLoadListener;
import com.candyrush.listeners.EventNpcListener;
import com.candyrush.listeners.FoodConsumeListener;
import com.candyrush.listeners.PlayerConnectionListener;
import com.candyrush.listeners.PvpListener;
import com.candyrush.listeners.TreasureChestListener;
import com.candyrush.managers.BossManager;
import com.candyrush.managers.EventNpcManager;
import com.candyrush.managers.GameManager;
import com.candyrush.managers.PlayerManager;
import com.candyrush.managers.PointConversionManager;
import com.candyrush.managers.ScoreboardManager;
import com.candyrush.managers.ShopManager;
import com.candyrush.managers.TeamManager;
import com.candyrush.managers.TreasureChestManager;
import com.candyrush.storage.DatabaseInitializer;
import com.candyrush.storage.GameStateStorage;
import com.candyrush.storage.GameStateStorageImpl;
import com.candyrush.storage.PlayerDataStorage;
import com.candyrush.storage.PlayerDataStorageImpl;
import com.candyrush.tasks.MurdererExpirationTask;
import com.candyrush.utils.ConfigManager;
import com.candyrush.utils.LanguageManager;
import java.sql.SQLException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CandyRushPlugin
extends JavaPlugin {
    private static CandyRushPlugin instance;
    private ConfigManager configManager;
    private LanguageManager languageManager;
    private DatabaseInitializer databaseInitializer;
    private PlayerDataStorage playerDataStorage;
    private GameStateStorage gameStateStorage;
    private MythicMobsIntegration mythicMobsIntegration;
    private GameManager gameManager;
    private TeamManager teamManager;
    private PlayerManager playerManager;
    private TreasureChestManager treasureChestManager;
    private PointConversionManager pointConversionManager;
    private EventNpcManager eventNpcManager;
    private BossManager bossManager;
    private ScoreboardManager scoreboardManager;
    private ShopManager shopManager;

    public void onEnable() {
        boolean hasMythicMobs;
        instance = this;
        this.getLogger().info("=================================");
        this.getLogger().info("  CandyRush Plugin Enabling...  ");
        this.getLogger().info("=================================");
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.getLogger().info("Configuration loaded");
        this.languageManager = new LanguageManager(this);
        this.getLogger().info("Language manager initialized (" + this.languageManager.getCurrentLanguage() + ")");
        boolean bl = hasMythicMobs = this.getServer().getPluginManager().getPlugin("MythicMobs") != null;
        if (hasMythicMobs) {
            this.getLogger().info("MythicMobs dependency found");
        } else {
            this.getLogger().warning("MythicMobs not found! Boss and Event features will be disabled.");
        }
        this.databaseInitializer = new DatabaseInitializer(this);
        try {
            this.databaseInitializer.initialize();
            this.getLogger().info("Database initialized successfully");
        }
        catch (SQLException e) {
            this.getLogger().severe("Failed to initialize database: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.playerDataStorage = new PlayerDataStorageImpl(this.databaseInitializer);
        this.gameStateStorage = new GameStateStorageImpl(this.databaseInitializer);
        this.getLogger().info("Storage layers initialized");
        if (hasMythicMobs) {
            this.mythicMobsIntegration = new MythicMobsIntegration(this);
            if (!this.mythicMobsIntegration.initialize()) {
                this.getLogger().warning("Failed to initialize MythicMobs integration");
                this.getLogger().warning("Boss and Event features will be disabled");
            } else if (!this.mythicMobsIntegration.validateRequiredMobs()) {
                this.getLogger().warning("Some required MythicMobs are missing - check warnings above");
                this.getLogger().warning("The plugin will continue, but events/bosses may not work correctly");
            }
        }
        this.gameManager = new GameManager(this);
        this.teamManager = new TeamManager(this);
        this.playerManager = new PlayerManager(this);
        this.treasureChestManager = new TreasureChestManager(this);
        this.pointConversionManager = new PointConversionManager(this);
        this.eventNpcManager = new EventNpcManager(this);
        this.bossManager = new BossManager(this);
        this.scoreboardManager = new ScoreboardManager(this);
        this.shopManager = new ShopManager(this);
        this.gameManager.initialize();
        this.teamManager.initialize();
        this.playerManager.initialize();
        this.treasureChestManager.initialize();
        this.pointConversionManager.initialize();
        this.eventNpcManager.initialize();
        this.bossManager.initialize();
        this.scoreboardManager.initialize();
        this.getLogger().info("Game managers initialized");
        MurdererExpirationTask murdererExpirationTask = new MurdererExpirationTask(this, this.playerManager, this.playerDataStorage);
        murdererExpirationTask.runTaskTimer((Plugin)this, 400L, 400L);
        this.getLogger().info("Scheduled tasks started (MurdererExpirationTask every 20s)");
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerConnectionListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TreasureChestListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new FoodConsumeListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EventNpcListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BossDeathListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PvpListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChunkLoadListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.shopManager, (Plugin)this);
        this.getLogger().info("Event listeners registered");
        this.getCommand("stats").setExecutor((CommandExecutor)new StatsCommand(this));
        this.getCommand("stats").setTabCompleter((TabCompleter)new StatsCommandTabCompleter());
        this.getCommand("candyrush").setExecutor((CommandExecutor)new DebugCommand(this));
        this.getCommand("candyrush").setTabCompleter((TabCompleter)new DebugCommandTabCompleter());
        this.getCommand("shop").setExecutor((CommandExecutor)new ShopCommand(this));
        this.getLogger().info("Commands registered");
        this.getLogger().info("=================================");
        this.getLogger().info(" CandyRush Plugin Enabled!     ");
        this.getLogger().info("=================================");
    }

    public void onDisable() {
        this.getLogger().info("=================================");
        this.getLogger().info(" CandyRush Plugin Disabling... ");
        this.getLogger().info("=================================");
        if (this.scoreboardManager != null) {
            this.scoreboardManager.shutdown();
        }
        if (this.gameManager != null) {
            this.gameManager.shutdown();
        }
        if (this.teamManager != null) {
            this.teamManager.shutdown();
        }
        if (this.playerManager != null) {
            this.playerManager.shutdown();
        }
        if (this.treasureChestManager != null) {
            this.treasureChestManager.shutdown();
        }
        if (this.pointConversionManager != null) {
            this.pointConversionManager.shutdown();
        }
        if (this.eventNpcManager != null) {
            this.eventNpcManager.shutdown();
        }
        if (this.bossManager != null) {
            this.bossManager.shutdown();
        }
        if (this.databaseInitializer != null) {
            this.databaseInitializer.close();
        }
        this.getLogger().info("=================================");
        this.getLogger().info("  CandyRush Plugin Disabled!   ");
        this.getLogger().info("=================================");
    }

    public static CandyRushPlugin getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public DatabaseInitializer getDatabaseInitializer() {
        return this.databaseInitializer;
    }

    public PlayerDataStorage getPlayerDataStorage() {
        return this.playerDataStorage;
    }

    public GameStateStorage getGameStateStorage() {
        return this.gameStateStorage;
    }

    public MythicMobsIntegration getMythicMobsIntegration() {
        return this.mythicMobsIntegration;
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    public TeamManager getTeamManager() {
        return this.teamManager;
    }

    public PlayerManager getPlayerManager() {
        return this.playerManager;
    }

    public TreasureChestManager getTreasureChestManager() {
        return this.treasureChestManager;
    }

    public PointConversionManager getPointConversionManager() {
        return this.pointConversionManager;
    }

    public EventNpcManager getEventNpcManager() {
        return this.eventNpcManager;
    }

    public BossManager getBossManager() {
        return this.bossManager;
    }

    public ScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }
}

