/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.commands;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.GameState;
import com.candyrush.models.Team;
import com.candyrush.utils.LanguageManager;
import java.util.HashMap;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DebugCommand
implements CommandExecutor {
    private final CandyRushPlugin plugin;
    private final LanguageManager lang;

    public DebugCommand(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLanguageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("candyrush.admin")) {
            sender.sendMessage(this.lang.getMessage("no_permission"));
            return true;
        }
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "status": {
                this.showStatus(sender);
                break;
            }
            case "start": {
                this.forceStart(sender);
                break;
            }
            case "stop": {
                this.forceStop(sender);
                break;
            }
            case "reset": {
                this.resetGame(sender);
                break;
            }
            case "setcenter": {
                this.setMapCenter(sender);
                break;
            }
            case "clearcenter": {
                this.clearMapCenter(sender);
                break;
            }
            default: {
                this.showHelp(sender);
            }
        }
        return true;
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(this.lang.getMessage("admin.debug_help_title"));
        sender.sendMessage(this.lang.getMessage("admin.debug_status"));
        sender.sendMessage(this.lang.getMessage("admin.debug_start"));
        sender.sendMessage(this.lang.getMessage("admin.debug_stop"));
        sender.sendMessage(this.lang.getMessage("admin.debug_reset"));
        sender.sendMessage(this.lang.getMessage("admin.debug_setcenter"));
        sender.sendMessage(this.lang.getMessage("admin.debug_clearcenter"));
    }

    private void showStatus(CommandSender sender) {
        GameState state = this.plugin.getGameManager().getCurrentState();
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        int minPlayers = this.plugin.getConfigManager().getMinPlayers();
        boolean canStart = this.plugin.getGameManager().canStartGame();
        sender.sendMessage(this.lang.getMessage("admin.status_title"));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("state", state.name());
        sender.sendMessage(this.lang.getMessage("admin.status_state", placeholders));
        placeholders.clear();
        placeholders.put("online", String.valueOf(onlinePlayers));
        sender.sendMessage(this.lang.getMessage("admin.status_online", placeholders));
        placeholders.clear();
        placeholders.put("min", String.valueOf(minPlayers));
        sender.sendMessage(this.lang.getMessage("admin.status_min", placeholders));
        placeholders.clear();
        placeholders.put("canStart", String.valueOf(canStart));
        sender.sendMessage(this.lang.getMessage("admin.status_can_start", placeholders));
        placeholders.clear();
        placeholders.put("canJoin", String.valueOf(this.plugin.getGameManager().canJoinGame()));
        sender.sendMessage(this.lang.getMessage("admin.status_can_join", placeholders));
        placeholders.clear();
        placeholders.put("running", String.valueOf(this.plugin.getGameManager().isGameRunning()));
        sender.sendMessage(this.lang.getMessage("admin.status_running", placeholders));
        if (this.plugin.getGameManager().getCurrentRound() != null) {
            Integer roundId = this.plugin.getGameManager().getCurrentRound().getId();
            placeholders.clear();
            placeholders.put("round", roundId != null ? String.valueOf(roundId) : "Not saved yet");
            sender.sendMessage(this.lang.getMessage("admin.status_round", placeholders));
        }
        sender.sendMessage(this.lang.getMessage("admin.status_teams_title"));
        for (Player player : Bukkit.getOnlinePlayers()) {
            Optional<Team> teamOpt = this.plugin.getTeamManager().getPlayerTeam(player.getUniqueId());
            String teamName = teamOpt.map(team -> team.getColor().name()).orElse("None");
            placeholders.clear();
            placeholders.put("player", player.getName());
            placeholders.put("team", teamName);
            sender.sendMessage(this.lang.getMessage("admin.status_team_player", placeholders));
        }
    }

    private void forceStart(CommandSender sender) {
        GameState state = this.plugin.getGameManager().getCurrentState();
        if (state != GameState.WAITING) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("state", state.name());
            sender.sendMessage(this.lang.getMessage("admin.start_already_started", placeholders));
            return;
        }
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        if (onlinePlayers == 0) {
            sender.sendMessage(this.lang.getMessage("admin.start_no_players"));
            return;
        }
        sender.sendMessage(this.lang.getMessage("admin.start_success"));
        this.plugin.getGameManager().tryStartCountdown();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getGameManager().getCurrentState() == GameState.WAITING) {
                sender.sendMessage(this.lang.getMessage("admin.start_failed"));
                sender.sendMessage(this.lang.getMessage("admin.start_check_status"));
            }
        }, 20L);
    }

    private void forceStop(CommandSender sender) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            sender.sendMessage(this.lang.getMessage("admin.stop_not_running"));
            return;
        }
        sender.sendMessage(this.lang.getMessage("admin.stop_success"));
        sender.sendMessage(this.lang.getMessage("admin.stop_not_implemented"));
    }

    private void resetGame(CommandSender sender) {
        sender.sendMessage(this.lang.getMessage("admin.reset_success"));
        this.plugin.getGameManager().initialize();
        sender.sendMessage(this.lang.getMessage("admin.reset_complete"));
    }

    private void setMapCenter(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.lang.getMessage("player_only"));
            return;
        }
        Player player = (Player)sender;
        int x = player.getLocation().getBlockX();
        int z = player.getLocation().getBlockZ();
        this.plugin.getConfigManager().setMapCenter(x, z);
        sender.sendMessage(this.lang.getMessage("admin.setcenter_border"));
        sender.sendMessage(this.lang.getMessage("admin.setcenter_title"));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("x", String.valueOf(x));
        sender.sendMessage(this.lang.getMessage("admin.setcenter_x", placeholders));
        placeholders.clear();
        placeholders.put("z", String.valueOf(z));
        sender.sendMessage(this.lang.getMessage("admin.setcenter_z", placeholders));
        sender.sendMessage(this.lang.getMessage("admin.setcenter_note"));
        sender.sendMessage(this.lang.getMessage("admin.setcenter_border"));
        this.plugin.getLogger().info("Map center set to X=" + x + ", Z=" + z + " by " + player.getName());
    }

    private void clearMapCenter(CommandSender sender) {
        Integer currentX = this.plugin.getConfigManager().getMapCenterX();
        Integer currentZ = this.plugin.getConfigManager().getMapCenterZ();
        if (currentX == null && currentZ == null) {
            sender.sendMessage(this.lang.getMessage("admin.clearcenter_already_cleared"));
            sender.sendMessage(this.lang.getMessage("admin.clearcenter_using_spawn"));
            return;
        }
        this.plugin.getConfigManager().clearMapCenter();
        sender.sendMessage(this.lang.getMessage("admin.clearcenter_border"));
        sender.sendMessage(this.lang.getMessage("admin.clearcenter_title"));
        if (currentX != null && currentZ != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("x", String.valueOf(currentX));
            placeholders.put("z", String.valueOf(currentZ));
            sender.sendMessage(this.lang.getMessage("admin.clearcenter_previous", placeholders));
        }
        sender.sendMessage(this.lang.getMessage("admin.clearcenter_note"));
        sender.sendMessage(this.lang.getMessage("admin.clearcenter_border"));
        this.plugin.getLogger().info("Map center cleared by " + sender.getName());
    }
}

