/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.managers;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.PlayerData;
import com.candyrush.models.TeamColor;
import com.candyrush.utils.MessageUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BossManager {
    private final CandyRushPlugin plugin;
    private final Map<UUID, Integer> murdererCounts;
    private final Set<UUID> activeBosses;
    private final Map<UUID, UUID> bossOwners;
    private final Map<UUID, BossBar> bossBars;
    private int maxActiveBosses = 1;

    public BossManager(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.murdererCounts = new ConcurrentHashMap<UUID, Integer>();
        this.activeBosses = ConcurrentHashMap.newKeySet();
        this.bossOwners = new ConcurrentHashMap<UUID, UUID>();
        this.bossBars = new ConcurrentHashMap<UUID, BossBar>();
    }

    public void initialize() {
        this.murdererCounts.clear();
        this.plugin.getLogger().info("BossManager initialized");
    }

    public void onPlayerBecomeMurderer(UUID playerUuid) {
        int count = this.murdererCounts.getOrDefault(playerUuid, 0) + 1;
        this.murdererCounts.put(playerUuid, count);
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player != null) {
            this.plugin.getLogger().info("Player " + player.getName() + " became murderer " + count + " times");
        }
    }

    public void spawnBoss(Player player) {
        if (this.plugin.getMythicMobsIntegration() == null) {
            this.plugin.getLogger().warning("Cannot spawn boss - MythicMobs not available");
            MessageUtils.sendMessage(player, "&c\u30dc\u30b9\u3092\u53ec\u559a\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff08MythicMobs\u672a\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\uff09");
            return;
        }
        List<String> bossTypes = this.plugin.getConfigManager().getBossTypes();
        if (bossTypes.isEmpty()) {
            this.plugin.getLogger().warning("No boss types configured!");
            return;
        }
        String bossType = bossTypes.get(new Random().nextInt(bossTypes.size()));
        Location spawnLoc = player.getLocation().add(0.0, 0.0, 5.0);
        this.plugin.getMythicMobsIntegration().spawnMob(bossType, spawnLoc, 1).ifPresent(activeMob -> {
            Entity bossEntity = activeMob.getEntity().getBukkitEntity();
            this.activeBosses.add(bossEntity.getUniqueId());
            this.bossOwners.put(bossEntity.getUniqueId(), player.getUniqueId());
            Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&c&l\u26a0\u26a0\u26a0 \u30dc\u30b9\u51fa\u73fe\uff01 \u26a0\u26a0\u26a0"));
            Bukkit.broadcastMessage((String)MessageUtils.colorize("&e" + player.getName() + " &c\u304c\u5f37\u5927\u306a\u30dc\u30b9\u3092\u53ec\u559a\u3057\u307e\u3057\u305f\uff01"));
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.playSound(p.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.0f, 0.5f);
                MessageUtils.sendTitle(p, "&4&l\u30dc\u30b9\u51fa\u73fe\uff01", "&c\u8a0e\u4f10\u3059\u308b\u3068\u30dd\u30a4\u30f3\u30c8\u7372\u5f97");
            }
            this.plugin.getLogger().info("Boss spawned for player: " + player.getName() + " at " + this.formatLocation(spawnLoc));
        });
    }

    public void spawnBoss(Location location) {
        if (this.activeBosses.size() >= this.maxActiveBosses) {
            this.plugin.getLogger().warning("Cannot spawn boss - maximum active bosses reached (" + this.maxActiveBosses + ")");
            Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&c\u65e2\u306b\u30dc\u30b9\u304c\u5b58\u5728\u3059\u308b\u305f\u3081\u3001\u65b0\u3057\u3044\u30dc\u30b9\u306f\u51fa\u73fe\u3057\u307e\u305b\u3093"));
            return;
        }
        List<String> bossTypes = this.plugin.getConfigManager().getBossTypes();
        if (bossTypes.isEmpty()) {
            this.plugin.getLogger().warning("No boss types configured!");
            return;
        }
        String bossType = bossTypes.get(new Random().nextInt(bossTypes.size()));
        this.plugin.getLogger().info("Selected boss type: " + bossType);
        this.plugin.getMythicMobsIntegration().spawnMob(bossType, location, 1).ifPresent(activeMob -> {
            Entity bossEntity = activeMob.getEntity().getBukkitEntity();
            UUID bossUuid = bossEntity.getUniqueId();
            this.activeBosses.add(bossUuid);
            this.createBossBar(bossEntity);
            Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&6&l\u2605 &d&l\u304a\u83d3\u5b50\u306e\u738b \u30b7\u30e5\u30ac\u30fc\u30ed\u30fc\u30c9 &6&l\u51fa\u73fe\uff01 \u2605"));
            for (Player p : Bukkit.getOnlinePlayers()) {
                p.playSound(p.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 0.8f);
            }
            this.plugin.getLogger().info("Boss spawned at " + this.formatLocation(location) + " - UUID: " + String.valueOf(bossUuid));
        });
    }

    public void onBossKilled(Entity boss, Player killer) {
        UUID bossUuid = boss.getUniqueId();
        if (!this.activeBosses.contains(bossUuid)) {
            return;
        }
        this.activeBosses.remove(bossUuid);
        UUID ownerUuid = this.bossOwners.remove(bossUuid);
        this.removeBossBar(bossUuid);
        int bossPoints = 500;
        PlayerData killerData = this.plugin.getPlayerManager().getOrCreatePlayerData(killer);
        killerData.addPoints(bossPoints);
        this.plugin.getPlayerManager().savePlayerData(killerData);
        TeamColor teamColor = killerData.getTeamColor();
        if (teamColor != null) {
            this.plugin.getTeamManager().addTeamPoints(teamColor, bossPoints);
        }
        Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&a&l\u2726 \u30dc\u30b9\u8a0e\u4f10\u6210\u529f\uff01 \u2726"));
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&e" + killer.getName() + " &a\u304c\u30dc\u30b9\u3092\u5012\u3057\u307e\u3057\u305f\uff01"));
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&6+" + bossPoints + "pt \u7372\u5f97\uff01"));
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.playSound(p.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f);
        }
        MessageUtils.sendTitle(killer, "&6&l+500pt", "&a\u30dc\u30b9\u8a0e\u4f10\u30dc\u30fc\u30ca\u30b9\uff01");
        this.plugin.getLogger().info("Boss killed by " + killer.getName() + " - awarded " + bossPoints + " points");
    }

    public boolean isBoss(Entity entity) {
        return this.activeBosses.contains(entity.getUniqueId());
    }

    public void resetMurdererCounts() {
        this.murdererCounts.clear();
        this.plugin.getLogger().info("Murderer counts reset");
    }

    public void removeAllBosses() {
        for (UUID bossUuid : new HashSet<UUID>(this.bossBars.keySet())) {
            this.removeBossBar(bossUuid);
        }
        this.activeBosses.clear();
        this.bossOwners.clear();
        this.murdererCounts.clear();
        this.plugin.getLogger().info("All bosses removed");
    }

    private void createBossBar(Entity bossEntity) {
        if (!(bossEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingBoss = (LivingEntity)bossEntity;
        UUID bossUuid = bossEntity.getUniqueId();
        BossBar bossBar = Bukkit.createBossBar((String)MessageUtils.colorize("&6&l\u2605 &d&l\u304a\u83d3\u5b50\u306e\u738b \u30b7\u30e5\u30ac\u30fc\u30ed\u30fc\u30c9 &6&l\u2605"), (BarColor)BarColor.PINK, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
        for (Player player : Bukkit.getOnlinePlayers()) {
            bossBar.addPlayer(player);
        }
        double healthPercentage = livingBoss.getHealth() / livingBoss.getMaxHealth();
        bossBar.setProgress(Math.max(0.0, Math.min(1.0, healthPercentage)));
        this.bossBars.put(bossUuid, bossBar);
        this.startBossHealthUpdateTask(bossUuid, livingBoss, bossBar);
        this.plugin.getLogger().info("Boss bar created for boss: " + String.valueOf(bossUuid));
    }

    private void startBossHealthUpdateTask(final UUID bossUuid, final LivingEntity boss, final BossBar bossBar) {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!boss.isValid() || boss.isDead() || !BossManager.this.activeBosses.contains(bossUuid)) {
                    BossManager.this.removeBossBar(bossUuid);
                    return;
                }
                double healthPercentage = boss.getHealth() / boss.getMaxHealth();
                bossBar.setProgress(Math.max(0.0, Math.min(1.0, healthPercentage)));
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (bossBar.getPlayers().contains(player)) continue;
                    bossBar.addPlayer(player);
                }
            }
        }, 0L, 10L);
    }

    private void removeBossBar(UUID bossUuid) {
        BossBar bossBar = this.bossBars.remove(bossUuid);
        if (bossBar != null) {
            bossBar.removeAll();
            this.plugin.getLogger().info("Boss bar removed for boss: " + String.valueOf(bossUuid));
        }
    }

    private String formatLocation(Location loc) {
        return String.format("%d, %d, %d", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public void shutdown() {
        this.removeAllBosses();
        this.plugin.getLogger().info("BossManager shutdown complete");
    }
}

