/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.managers;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.NPCEventTier;
import com.candyrush.models.PlayerData;
import com.candyrush.utils.MessageUtils;
import com.candyrush.utils.NpcNameGenerator;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class EventNpcManager {
    private final CandyRushPlugin plugin;
    private final Map<UUID, DefenseEvent> activeDefenseEvents;
    private final Map<UUID, NpcData> activeNpcs;
    private final Map<UUID, Long> playerHelpMessageCooldown;
    private final Map<UUID, Integer> playerDefenseClearCount;
    private final Map<NpcRespawnData, Long> pendingNpcRespawn;
    private BukkitTask proximityCheckTask;
    private BukkitTask npcRespawnTask;
    private Integer currentRoundId;
    private NpcNameGenerator nameGenerator;
    private final Random random;

    public EventNpcManager(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.activeDefenseEvents = new ConcurrentHashMap<UUID, DefenseEvent>();
        this.activeNpcs = new ConcurrentHashMap<UUID, NpcData>();
        this.playerHelpMessageCooldown = new ConcurrentHashMap<UUID, Long>();
        this.playerDefenseClearCount = new ConcurrentHashMap<UUID, Integer>();
        this.pendingNpcRespawn = new ConcurrentHashMap<NpcRespawnData, Long>();
        this.currentRoundId = null;
        this.random = new Random();
    }

    public void initialize() {
        List<String> npcNames = this.plugin.getConfigManager().getNpcNames();
        if (npcNames.isEmpty()) {
            this.plugin.getLogger().warning("No NPC names loaded - using fallback");
            npcNames = List.of("\u592a\u90ce", "\u6b21\u90ce", "\u3055\u304f\u3089");
        }
        this.nameGenerator = new NpcNameGenerator(npcNames);
        this.startProximityCheckTask();
        this.startNpcRespawnTask();
        this.plugin.getLogger().info("EventNpcManager initialized with " + npcNames.size() + " NPC names");
    }

    private NPCEventTier selectRandomTier() {
        List<NPCEventTier> tiers = this.plugin.getConfigManager().getEventTiers();
        if (tiers.isEmpty()) {
            this.plugin.getLogger().severe("No tiers configured! Cannot spawn NPC events");
            return null;
        }
        int totalWeight = 0;
        for (NPCEventTier tier : tiers) {
            totalWeight += tier.getSpawnWeight();
        }
        int randomValue = this.random.nextInt(totalWeight);
        int currentWeight = 0;
        for (NPCEventTier tier : tiers) {
            if (randomValue >= (currentWeight += tier.getSpawnWeight())) continue;
            return tier;
        }
        this.plugin.getLogger().warning("Weighted selection failed, falling back to tier 1");
        return this.plugin.getConfigManager().getEventTier(1);
    }

    public void spawnEventNpcs(World world, Location center, int radius, Integer roundId) {
        this.currentRoundId = roundId;
        if (this.plugin.getMythicMobsIntegration() == null) {
            this.plugin.getLogger().info("Skipping event NPC spawn - MythicMobs not available");
            return;
        }
        this.activeNpcs.clear();
        if (roundId != null) {
            this.deleteOldNpcsFromDatabase(roundId, world);
        }
        int npcPerChunks = this.plugin.getConfigManager().getEventNpcPerChunks();
        int centerChunkX = center.getBlockX() >> 4;
        int centerChunkZ = center.getBlockZ() >> 4;
        int chunkRadius = radius >> 4;
        ArrayList<int[]> spawnCoordinates = new ArrayList<int[]>();
        for (int chunkX = centerChunkX - chunkRadius; chunkX <= centerChunkX + chunkRadius; chunkX += npcPerChunks) {
            for (int chunkZ = centerChunkZ - chunkRadius; chunkZ <= centerChunkZ + chunkRadius; chunkZ += npcPerChunks) {
                spawnCoordinates.add(new int[]{chunkX << 4, chunkZ << 4});
            }
        }
        this.plugin.getLogger().info("Starting async NPC spawn for " + spawnCoordinates.size() + " locations");
        this.spawnNpcsAsync(world, center, radius, spawnCoordinates, 0);
    }

    private void spawnNpcsAsync(World world, Location center, int radius, List<int[]> coordinates, int index) {
        if (index >= coordinates.size()) {
            this.plugin.getLogger().info("Spawned " + this.activeNpcs.size() + " event NPCs in the map");
            return;
        }
        int[] coord = coordinates.get(index);
        int baseX = coord[0];
        int baseZ = coord[1];
        this.findSafeNpcLocationAsync(world, baseX, baseZ, center, radius, location -> {
            if (location != null) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.spawnNpc((Location)location));
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.spawnNpcsAsync(world, center, radius, coordinates, index + 1), 1L);
        });
    }

    private void findSafeNpcLocationAsync(World world, int baseX, int baseZ, Location center, int radius, Consumer<Location> callback) {
        Random random = new Random();
        int x = baseX + random.nextInt(16);
        int z = baseZ + random.nextInt(16);
        if (Math.sqrt(Math.pow((double)x - center.getX(), 2.0) + Math.pow((double)z - center.getZ(), 2.0)) > (double)radius) {
            callback.accept(null);
            return;
        }
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (world.isChunkLoaded(chunkX, chunkZ)) {
            int y = world.getHighestBlockYAt(x, z) + 1;
            Location loc = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
            if (loc.getBlock().getRelative(0, -1, 0).getType().isSolid()) {
                callback.accept(loc);
            } else {
                callback.accept(null);
            }
        } else {
            world.getChunkAtAsync(chunkX, chunkZ).thenAccept(chunk -> {
                int y = world.getHighestBlockYAt(x, z) + 1;
                Location loc = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
                if (loc.getBlock().getRelative(0, -1, 0).getType().isSolid()) {
                    callback.accept(loc);
                } else {
                    callback.accept(null);
                }
            });
        }
    }

    private void spawnNpc(Location location) {
        String finalNpcType;
        NPCEventTier finalTier;
        NPCEventTier selectedTier = this.selectRandomTier();
        if (selectedTier == null) {
            this.plugin.getLogger().warning("Failed to select tier for NPC at " + this.formatLocation(location));
            return;
        }
        String npcType = selectedTier.getNpcMobType();
        Optional<ActiveMob> spawnResult = this.plugin.getMythicMobsIntegration().spawnMob(npcType, location, 1);
        if (!spawnResult.isPresent()) {
            this.plugin.getLogger().warning("Failed to spawn " + npcType + ", falling back to tier 1");
            NPCEventTier tier1 = this.plugin.getConfigManager().getEventTier(1);
            if (tier1 != null) {
                finalTier = tier1;
                finalNpcType = tier1.getNpcMobType();
                spawnResult = this.plugin.getMythicMobsIntegration().spawnMob(finalNpcType, location, 1);
            } else {
                finalTier = selectedTier;
                finalNpcType = npcType;
            }
        } else {
            finalTier = selectedTier;
            finalNpcType = npcType;
        }
        spawnResult.ifPresent(activeMob -> {
            UUID entityUuid = activeMob.getEntity().getUniqueId();
            Entity npcEntity = activeMob.getEntity().getBukkitEntity();
            String formattedName = this.nameGenerator.getFormattedName(finalTier);
            npcEntity.setCustomName(MessageUtils.colorize(formattedName));
            npcEntity.setCustomNameVisible(true);
            NpcData npcData = new NpcData(entityUuid, location, finalNpcType, finalTier, formattedName);
            this.activeNpcs.put(entityUuid, npcData);
            if (this.currentRoundId != null) {
                this.saveNpcToDatabase(location, finalNpcType, this.currentRoundId, entityUuid);
            }
            this.plugin.getLogger().fine("Spawned event NPC (Tier " + finalTier.getTier() + ") at " + this.formatLocation(location) + " UUID: " + String.valueOf(entityUuid) + " Name: " + formattedName);
        });
    }

    public void onPlayerClickNpc(Player player, Entity npc) {
        UUID npcUuid = npc.getUniqueId();
        if (!this.activeNpcs.containsKey(npcUuid)) {
            return;
        }
        if (this.activeDefenseEvents.containsKey(player.getUniqueId())) {
            MessageUtils.sendMessage(player, "&c\u65e2\u306b\u9632\u885b\u30a4\u30d9\u30f3\u30c8\u4e2d\u3067\u3059\uff01");
            return;
        }
        NpcData npcData = this.activeNpcs.get(npcUuid);
        this.startDefenseEvent(player, npc, npcData);
    }

    private void startDefenseEvent(Player player, Entity npc, NpcData npcData) {
        Location npcLocation = npc.getLocation();
        DefenseEvent event = new DefenseEvent(player, npc, npcLocation, npcData);
        this.activeDefenseEvents.put(player.getUniqueId(), event);
        this.activeNpcs.remove(npc.getUniqueId());
        MessageUtils.sendMessage(player, "&e&l\u26a0 \u9632\u885b\u30a4\u30d9\u30f3\u30c8\u958b\u59cb\uff01 \u26a0");
        MessageUtils.sendMessage(player, "&a\u30e2\u30f3\u30b9\u30bf\u30fc\u306e\u6ce2\u3092\u5168\u3066\u5012\u3057\u3066NPC\u3092\u5b88\u308a\u304d\u308c\uff01");
        player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
        event.start();
        this.plugin.getLogger().info("Defense event started for player: " + player.getName());
    }

    private void endDefenseEvent(UUID playerUuid, boolean success, Entity npc) {
        DefenseEvent event = this.activeDefenseEvents.remove(playerUuid);
        if (event == null) {
            return;
        }
        event.stop();
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null) {
            return;
        }
        if (success) {
            NPCEventTier tier = event.npcData.getTier();
            int rewardMin = tier != null ? tier.getRewardPointsMin() : this.plugin.getConfigManager().getRewardPointsMin();
            int rewardMax = tier != null ? tier.getRewardPointsMax() : this.plugin.getConfigManager().getRewardPointsMax();
            int reward = rewardMin + new Random().nextInt(Math.max(1, rewardMax - rewardMin + 1));
            int bossSpawnPoints = tier != null ? tier.getBossSpawnPoints() : 5;
            this.plugin.getPlayerManager().addPoints(playerUuid, reward);
            this.plugin.getPlayerManager().getPlayerData(playerUuid).ifPresent(data -> {
                data.incrementEventsCompleted();
                data.addBossSpawnPoints(bossSpawnPoints);
                int currentBossPoints = data.getBossSpawnPoints();
                this.plugin.getPlayerManager().savePlayerData((PlayerData)data);
                if (data.getTeamColor() != null) {
                    this.plugin.getTeamManager().addTeamPoints(data.getTeamColor(), reward);
                }
                this.plugin.getLogger().info("Player " + player.getName() + " earned " + bossSpawnPoints + " boss spawn points (now: " + currentBossPoints + ")");
            });
            String tierName = tier != null ? "Lv." + tier.getTier() : "";
            MessageUtils.sendMessage(player, "&a&l\u2713 \u9632\u885b\u6210\u529f\uff01");
            MessageUtils.sendMessage(player, "&e&l[NPC] &a\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3059\uff01\u3053\u308c\u3092\u53d7\u3051\u53d6\u3063\u3066\u304f\u3060\u3055\u3044\uff01");
            MessageUtils.sendMessage(player, "&6&l+" + reward + "pt &7\u5831\u916c\u3092\u7372\u5f97\u3057\u307e\u3057\u305f\uff01");
            MessageUtils.sendMessage(player, "&d&l+" + bossSpawnPoints + "pt &7\u30dc\u30b9\u53ec\u559a\u30dd\u30a4\u30f3\u30c8\u7372\u5f97\uff01 " + tierName);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_YES, 1.0f, 1.0f);
            if (npc != null && npc.isValid()) {
                Location npcLocation = npc.getLocation();
                this.spawnRewardEffects(npcLocation);
                npc.remove();
                this.scheduleNpcRespawn(npcLocation);
            }
            this.plugin.getLogger().info("Player " + player.getName() + " completed defense event (Tier " + String.valueOf(tier != null ? Integer.valueOf(tier.getTier()) : "?") + ") - reward: " + reward);
            this.plugin.getPlayerManager().getPlayerData(playerUuid).ifPresent(data -> {
                if (data.canSpawnBoss()) {
                    int threshold = this.plugin.getConfigManager().getBossSpawnPointThreshold();
                    int currentPoints = data.getBossSpawnPoints();
                    int overflow = currentPoints - threshold;
                    this.spawnBossForPlayer(player);
                    data.resetBossSpawnPoints();
                    if (overflow > 0) {
                        data.addBossSpawnPoints(overflow);
                    }
                    this.plugin.getPlayerManager().savePlayerData((PlayerData)data);
                    MessageUtils.sendMessage(player, "&d&l\u30dc\u30b9\u53ec\u559a\u30dd\u30a4\u30f3\u30c8\u304c100\u306b\u5230\u9054\uff01");
                    if (overflow > 0) {
                        MessageUtils.sendMessage(player, "&7\u6b8b\u308a " + overflow + "pt \u306f\u5f15\u304d\u7d99\u304c\u308c\u307e\u3057\u305f");
                    }
                    this.plugin.getLogger().info("Boss spawned for " + player.getName() + " - overflow: " + overflow);
                }
            });
        } else {
            MessageUtils.sendMessage(player, "&c&l\u2717 \u9632\u885b\u5931\u6557...");
            MessageUtils.sendMessage(player, "&7NPC\u304c\u30e2\u30f3\u30b9\u30bf\u30fc\u306b\u3084\u3089\u308c\u3066\u3057\u307e\u3063\u305f...");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_DEATH, 1.0f, 1.0f);
            if (npc != null && npc.isValid()) {
                Location npcLocation = npc.getLocation();
                this.spawnDeathEffects(npcLocation);
                npc.remove();
                this.scheduleNpcRespawn(npcLocation);
            }
            this.plugin.getLogger().info("Player " + player.getName() + " failed defense event");
        }
    }

    private void onPlayerAbandon(UUID playerUuid, Entity npc) {
        DefenseEvent event = this.activeDefenseEvents.remove(playerUuid);
        if (event == null) {
            return;
        }
        event.stop();
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player != null) {
            MessageUtils.sendMessage(player, "&c&l\u9632\u885b\u30a8\u30ea\u30a2\u304b\u3089\u96e2\u308c\u3059\u304e\u307e\u3057\u305f\uff01");
            MessageUtils.sendMessage(player, "&7\u30a4\u30d9\u30f3\u30c8\u304c\u4e2d\u6b62\u3055\u308c\u307e\u3057\u305f...");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 0.8f);
        }
        if (npc != null && npc.isValid()) {
            Location npcLocation = npc.getLocation();
            this.spawnDeathEffects(npcLocation);
            npc.remove();
            this.scheduleNpcRespawn(npcLocation);
        }
        this.plugin.getLogger().info("Player " + String.valueOf(player != null ? player.getName() : playerUuid) + " abandoned defense event");
    }

    private void spawnRewardEffects(Location loc) {
        loc.getWorld().spawnParticle(Particle.FIREWORK, loc.add(0.0, 1.0, 0.0), 50, 0.5, 0.5, 0.5, 0.1);
        loc.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, loc, 30, 0.5, 0.5, 0.5, 0.1);
        loc.getWorld().playSound(loc, Sound.ENTITY_PLAYER_LEVELUP, 1.5f, 1.0f);
    }

    private void spawnDeathEffects(Location loc) {
        loc.getWorld().spawnParticle(Particle.SMOKE, loc.add(0.0, 1.0, 0.0), 30, 0.3, 0.3, 0.3, 0.05);
        loc.getWorld().spawnParticle(Particle.LARGE_SMOKE, loc, 15, 0.2, 0.2, 0.2, 0.05);
        loc.getWorld().playSound(loc, Sound.ENTITY_VILLAGER_DEATH, 1.0f, 1.0f);
    }

    private void startProximityCheckTask() {
        if (this.proximityCheckTask != null) {
            this.proximityCheckTask.cancel();
        }
        this.proximityCheckTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.plugin.getGameManager().isGameRunning()) {
                return;
            }
            int proximityRange = this.plugin.getConfigManager().getProximityRange();
            long currentTime = System.currentTimeMillis();
            int cooldown = this.plugin.getConfigManager().getHelpMessageCooldown() * 1000;
            for (Map.Entry<UUID, NpcData> entry : this.activeNpcs.entrySet()) {
                UUID npcUuid = entry.getKey();
                Entity npc = Bukkit.getEntity((UUID)npcUuid);
                if (npc == null || !npc.isValid()) continue;
                Location npcLoc = npc.getLocation();
                for (Player player : npcLoc.getWorld().getPlayers()) {
                    Long lastMessage;
                    if (!(player.getLocation().distance(npcLoc) <= (double)proximityRange) || (lastMessage = this.playerHelpMessageCooldown.get(player.getUniqueId())) != null && currentTime - lastMessage < (long)cooldown) continue;
                    MessageUtils.sendActionBar(player, "&e&l[NPC] &c\u52a9\u3051\u3066\u304f\u3060\u3055\u3044\uff01\u30e2\u30f3\u30b9\u30bf\u30fc\u306b\u8972\u308f\u308c\u3066\u3044\u307e\u3059\uff01");
                    player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_HURT, 0.5f, 1.0f);
                    this.playerHelpMessageCooldown.put(player.getUniqueId(), currentTime);
                }
            }
        }, 20L, 20L);
    }

    private void startNpcRespawnTask() {
        if (this.npcRespawnTask != null) {
            this.npcRespawnTask.cancel();
        }
        this.npcRespawnTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!this.plugin.getGameManager().isGameRunning()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            ArrayList<NpcRespawnData> toRespawn = new ArrayList<NpcRespawnData>();
            for (Map.Entry<NpcRespawnData, Long> entry : this.pendingNpcRespawn.entrySet()) {
                if (currentTime < entry.getValue()) continue;
                toRespawn.add(entry.getKey());
            }
            for (NpcRespawnData data : toRespawn) {
                Location loc = data.getLocation();
                int chunkX = loc.getBlockX() >> 4;
                int chunkZ = loc.getBlockZ() >> 4;
                if (!loc.getWorld().isChunkLoaded(chunkX, chunkZ)) continue;
                this.spawnNpc(loc);
                this.pendingNpcRespawn.remove(data);
                this.plugin.getLogger().fine("Respawned NPC at " + this.formatLocation(loc));
            }
        }, 20L, 20L);
    }

    private void scheduleNpcRespawn(Location location) {
        int respawnDelay = this.plugin.getConfigManager().getNpcRespawnDelay();
        long respawnTime = System.currentTimeMillis() + (long)respawnDelay * 1000L;
        NpcRespawnData data = new NpcRespawnData(location.clone());
        this.pendingNpcRespawn.put(data, respawnTime);
        this.plugin.getLogger().fine("Scheduled NPC respawn at " + this.formatLocation(location) + " in " + respawnDelay + " seconds");
    }

    private void spawnBossForPlayer(Player player) {
        Location bossLocation = player.getLocation().add(0.0, 0.0, 10.0);
        Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&6&l\u2605\u2605\u2605 \u304a\u83d3\u5b50\u306e\u738b\u51fa\u73fe\uff01 \u2605\u2605\u2605"));
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&e" + player.getName() + " &a\u304c\u9632\u885b\u30a4\u30d9\u30f3\u30c8\u3092" + this.plugin.getConfigManager().getBossSpawnThreshold() + "\u56de\u30af\u30ea\u30a2\u3057\u307e\u3057\u305f\uff01"));
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&d&l\u304a\u83d3\u5b50\u306e\u738b \u30b7\u30e5\u30ac\u30fc\u30ed\u30fc\u30c9 &6&l\u304c\u964d\u81e8\u3057\u307e\u3057\u305f\uff01"));
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.playSound(p.getLocation(), Sound.ENTITY_WITHER_SPAWN, 1.0f, 0.5f);
            p.playSound(p.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 0.5f);
            MessageUtils.sendTitle(p, "&6&l\u2605 &d&l\u304a\u83d3\u5b50\u306e\u738b\u51fa\u73fe\uff01 &6&l\u2605", "&e\u8a0e\u4f10\u3059\u308b\u3068\u30dd\u30a4\u30f3\u30c8\u7372\u5f97");
        }
        this.plugin.getBossManager().spawnBoss(bossLocation);
        this.plugin.getLogger().info("Boss spawned for player: " + player.getName() + " at " + this.formatLocation(bossLocation));
    }

    public void removeAllNpcs() {
        for (UUID playerUuid : new HashSet<UUID>(this.activeDefenseEvents.keySet())) {
            DefenseEvent event = this.activeDefenseEvents.remove(playerUuid);
            if (event == null) continue;
            event.stop();
        }
        for (UUID npcUuid : new HashSet<UUID>(this.activeNpcs.keySet())) {
            Entity npc = Bukkit.getEntity((UUID)npcUuid);
            if (npc == null || !npc.isValid()) continue;
            npc.remove();
        }
        this.activeNpcs.clear();
        this.playerHelpMessageCooldown.clear();
        this.playerDefenseClearCount.clear();
        this.pendingNpcRespawn.clear();
        this.plugin.getLogger().info("All event NPCs removed");
    }

    private String formatLocation(Location loc) {
        return String.format("%d, %d, %d", loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    public void shutdown() {
        this.removeAllNpcs();
        if (this.proximityCheckTask != null) {
            this.proximityCheckTask.cancel();
            this.proximityCheckTask = null;
        }
        if (this.npcRespawnTask != null) {
            this.npcRespawnTask.cancel();
            this.npcRespawnTask = null;
        }
        this.plugin.getLogger().info("EventNpcManager shutdown complete");
    }

    private void deleteOldNpcsFromDatabase(int newRoundId, World world) {
        block26: {
            try (Connection conn = this.plugin.getDatabaseInitializer().getConnection();
                 PreparedStatement stmt = conn.prepareStatement("SELECT id, entity_uuid FROM event_npcs WHERE round_id != ? AND world = ?");){
                stmt.setInt(1, newRoundId);
                stmt.setString(2, world.getName());
                ResultSet rs = stmt.executeQuery();
                ArrayList<Integer> dbIdsToDelete = new ArrayList<Integer>();
                int deletedEntities = 0;
                while (rs.next()) {
                    int id = rs.getInt("id");
                    String uuidString = rs.getString("entity_uuid");
                    if (uuidString != null) {
                        try {
                            UUID entityUuid = UUID.fromString(uuidString);
                            Entity entity = Bukkit.getEntity((UUID)entityUuid);
                            if (entity != null) {
                                entity.remove();
                                ++deletedEntities;
                                this.plugin.getLogger().fine("Removed old NPC entity: " + String.valueOf(entityUuid));
                            }
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getLogger().warning("Invalid UUID in database: " + uuidString);
                        }
                    }
                    dbIdsToDelete.add(id);
                }
                rs.close();
                if (dbIdsToDelete.isEmpty()) break block26;
                String placeholders = String.join((CharSequence)",", Collections.nCopies(dbIdsToDelete.size(), "?"));
                try (PreparedStatement deleteStmt = conn.prepareStatement("DELETE FROM event_npcs WHERE id IN (" + placeholders + ")");){
                    for (int i = 0; i < dbIdsToDelete.size(); ++i) {
                        deleteStmt.setInt(i + 1, (Integer)dbIdsToDelete.get(i));
                    }
                    int deleted = deleteStmt.executeUpdate();
                    this.plugin.getLogger().info("Deleted " + deleted + " old NPC records from database (" + deletedEntities + " entities removed)");
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to delete old NPCs from database", e);
            }
        }
    }

    private void saveNpcToDatabase(Location location, String npcType, int roundId, UUID entityUuid) {
        try (Connection conn = this.plugin.getDatabaseInitializer().getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT INTO event_npcs (round_id, entity_uuid, world, x, y, z, yaw, pitch, npc_type, spawned_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            stmt.setInt(1, roundId);
            stmt.setString(2, entityUuid.toString());
            stmt.setString(3, location.getWorld().getName());
            stmt.setDouble(4, location.getX());
            stmt.setDouble(5, location.getY());
            stmt.setDouble(6, location.getZ());
            stmt.setFloat(7, location.getYaw());
            stmt.setFloat(8, location.getPitch());
            stmt.setString(9, npcType);
            stmt.setLong(10, System.currentTimeMillis() / 1000L);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to save NPC to database at " + this.formatLocation(location), e);
        }
    }

    private static class NpcData {
        private final UUID entityUuid;
        private final Location spawnLocation;
        private final String npcType;
        private final NPCEventTier tier;
        private final String npcName;

        public NpcData(UUID entityUuid, Location spawnLocation, String npcType, NPCEventTier tier, String npcName) {
            this.entityUuid = entityUuid;
            this.spawnLocation = spawnLocation;
            this.npcType = npcType;
            this.tier = tier;
            this.npcName = npcName;
        }

        public NpcData(UUID entityUuid, Location spawnLocation, String npcType) {
            this(entityUuid, spawnLocation, npcType, null, null);
        }

        public UUID getEntityUuid() {
            return this.entityUuid;
        }

        public Location getSpawnLocation() {
            return this.spawnLocation;
        }

        public String getNpcType() {
            return this.npcType;
        }

        public NPCEventTier getTier() {
            return this.tier;
        }

        public String getNpcName() {
            return this.npcName;
        }
    }

    private class DefenseEvent {
        private final Player player;
        private final Entity npc;
        private final Location npcLocation;
        private final NpcData npcData;
        private final List<UUID> spawnedMonsters;
        private final int totalWaves;
        private final int monstersPerWave;
        private final int waveInterval;
        private final int totalDuration;
        private int currentWave;
        private int elapsedSeconds;
        private BukkitTask task;
        private boolean distanceWarningShown;

        public DefenseEvent(Player player, Entity npc, Location npcLocation, NpcData npcData) {
            this.player = player;
            this.npc = npc;
            this.npcLocation = npcLocation;
            this.npcData = npcData;
            this.spawnedMonsters = new ArrayList<UUID>();
            NPCEventTier tier = npcData != null ? npcData.getTier() : null;
            this.totalWaves = tier != null ? tier.getMonsterWaves() : EventNpcManager.this.plugin.getConfigManager().getMonsterWaves();
            this.monstersPerWave = tier != null ? tier.getMonstersPerWave() : EventNpcManager.this.plugin.getConfigManager().getMonstersPerWave();
            this.waveInterval = tier != null ? tier.getWaveIntervalSeconds() : EventNpcManager.this.plugin.getConfigManager().getWaveIntervalSeconds();
            this.totalDuration = tier != null ? tier.getDefenseDurationSeconds() : EventNpcManager.this.plugin.getConfigManager().getDefenseDurationSeconds();
            this.currentWave = 0;
            this.elapsedSeconds = 0;
            this.distanceWarningShown = false;
        }

        public void start() {
            this.spawnWave();
            this.task = Bukkit.getScheduler().runTaskTimer((Plugin)EventNpcManager.this.plugin, () -> {
                int remaining;
                ++this.elapsedSeconds;
                if (!this.player.isOnline()) {
                    EventNpcManager.this.onPlayerAbandon(this.player.getUniqueId(), this.npc);
                    return;
                }
                if (this.npc == null || !this.npc.isValid()) {
                    EventNpcManager.this.endDefenseEvent(this.player.getUniqueId(), false, this.npc);
                    return;
                }
                double distance = this.player.getLocation().distance(this.npcLocation);
                if (distance > 15.0 && distance <= 20.0) {
                    if (!this.distanceWarningShown) {
                        MessageUtils.sendMessage(this.player, "&e&l\u26a0 \u8b66\u544a: NPC\u304b\u3089\u96e2\u308c\u3059\u304e\u3066\u3044\u307e\u3059\uff01");
                        MessageUtils.sendMessage(this.player, "&c20\u30d6\u30ed\u30c3\u30af\u4ee5\u4e0a\u96e2\u308c\u308b\u3068\u30a4\u30d9\u30f3\u30c8\u304c\u4e2d\u6b62\u3055\u308c\u307e\u3059\uff01");
                        this.player.playSound(this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.5f);
                        this.distanceWarningShown = true;
                    }
                } else if (distance <= 15.0) {
                    this.distanceWarningShown = false;
                } else if (distance > 20.0) {
                    EventNpcManager.this.onPlayerAbandon(this.player.getUniqueId(), this.npc);
                    return;
                }
                this.spawnedMonsters.removeIf(uuid -> {
                    Entity entity = Bukkit.getEntity((UUID)uuid);
                    return entity == null || !entity.isValid();
                });
                for (UUID monsterUuid : this.spawnedMonsters) {
                    double monsterDistance;
                    Entity monster = Bukkit.getEntity((UUID)monsterUuid);
                    if (monster == null || !monster.isValid() || !((monsterDistance = monster.getLocation().distance(this.npcLocation)) > 16.0)) continue;
                    Random random = new Random();
                    double angle = random.nextDouble() * Math.PI * 2.0;
                    double teleportDistance = 5.0 + random.nextDouble() * 3.0;
                    double x = this.npcLocation.getX() + Math.cos(angle) * teleportDistance;
                    double z = this.npcLocation.getZ() + Math.sin(angle) * teleportDistance;
                    int y = this.npcLocation.getWorld().getHighestBlockYAt((int)x, (int)z) + 1;
                    Location teleportLoc = new Location(this.npcLocation.getWorld(), x, (double)y, z);
                    monster.teleport(teleportLoc);
                    if (!EventNpcManager.this.plugin.getConfigManager().isDebugEnabled()) continue;
                    EventNpcManager.this.plugin.getLogger().info("Monster teleported back to NPC - was " + String.format("%.1f", monsterDistance) + " blocks away");
                }
                if (this.elapsedSeconds % this.waveInterval == 0 && this.currentWave < this.totalWaves) {
                    this.spawnWave();
                }
                if ((remaining = this.totalDuration - this.elapsedSeconds) > 0) {
                    MessageUtils.sendActionBar(this.player, "&e&l\u9632\u885b\u4e2d\uff01 &7\u6ce2: &a" + this.currentWave + "&7/&a" + this.totalWaves + " &7| \u6b8b\u308a: &c" + remaining + "\u79d2 &7| \u30e2\u30f3\u30b9\u30bf\u30fc: &c" + this.spawnedMonsters.size());
                }
                if (this.currentWave >= this.totalWaves && this.spawnedMonsters.isEmpty()) {
                    EventNpcManager.this.endDefenseEvent(this.player.getUniqueId(), true, this.npc);
                    return;
                }
                if (this.elapsedSeconds >= this.totalDuration) {
                    EventNpcManager.this.endDefenseEvent(this.player.getUniqueId(), false, this.npc);
                }
            }, 0L, 20L);
        }

        private void spawnWave() {
            boolean isFinalWave;
            ++this.currentWave;
            boolean bl = isFinalWave = this.currentWave == this.totalWaves;
            if (isFinalWave) {
                MessageUtils.sendMessage(this.player, "&4&l\u26a0 \u6700\u7d42\u6ce2\uff01\u30a8\u30ea\u30fc\u30c8\u30e2\u30f3\u30b9\u30bf\u30fc\u304c\u51fa\u73fe\uff01 \u26a0");
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 0.8f, 0.5f);
            } else {
                MessageUtils.sendMessage(this.player, "&c&l\u26a0 \u7b2c" + this.currentWave + "\u6ce2\u306e\u30e2\u30f3\u30b9\u30bf\u30fc\u304c\u51fa\u73fe\uff01");
                this.player.playSound(this.player.getLocation(), Sound.ENTITY_WITHER_SPAWN, 0.5f, 1.5f);
            }
            List<String> mobTypes = this.npcData != null && this.npcData.getTier() != null ? this.npcData.getTier().getMonsters() : EventNpcManager.this.plugin.getConfigManager().getDefenseMobs();
            List<String> eliteMobTypes = EventNpcManager.this.plugin.getConfigManager().getDefenseEliteMobs();
            if (mobTypes.isEmpty()) {
                EventNpcManager.this.plugin.getLogger().warning("No defense mobs configured!");
                return;
            }
            EventNpcManager.this.plugin.getLogger().info("Spawning wave " + this.currentWave + " - Configured mobs: " + String.valueOf(mobTypes));
            EventNpcManager.this.plugin.getLogger().info("Monsters per wave: " + this.monstersPerWave);
            Random random = new Random();
            int spawnedCount = 0;
            for (int i = 0; i < this.monstersPerWave; ++i) {
                String mobType;
                double angle = random.nextDouble() * Math.PI * 2.0;
                double distance = 5.0 + random.nextDouble() * 5.0;
                double x = this.npcLocation.getX() + Math.cos(angle) * distance;
                double z = this.npcLocation.getZ() + Math.sin(angle) * distance;
                int y = this.npcLocation.getWorld().getHighestBlockYAt((int)x, (int)z) + 1;
                Location spawnLoc = new Location(this.npcLocation.getWorld(), x, (double)y, z);
                if (isFinalWave && !eliteMobTypes.isEmpty() && random.nextDouble() < 0.7) {
                    mobType = eliteMobTypes.get(random.nextInt(eliteMobTypes.size()));
                    EventNpcManager.this.plugin.getLogger().info("Selected elite mob type: " + mobType);
                } else {
                    mobType = mobTypes.get(random.nextInt(mobTypes.size()));
                    EventNpcManager.this.plugin.getLogger().info("Selected normal mob type: " + mobType);
                }
                EventNpcManager.this.plugin.getLogger().info("Attempting to spawn " + mobType + " at " + String.format("%.1f, %.1f, %.1f", spawnLoc.getX(), spawnLoc.getY(), spawnLoc.getZ()));
                Optional<ActiveMob> spawnedMob = EventNpcManager.this.plugin.getMythicMobsIntegration().spawnMob(mobType, spawnLoc, 1);
                if (spawnedMob.isPresent()) {
                    ActiveMob activeMob = spawnedMob.get();
                    UUID mobUuid = activeMob.getEntity().getUniqueId();
                    this.spawnedMonsters.add(mobUuid);
                    ++spawnedCount;
                    EventNpcManager.this.plugin.getLogger().info("Successfully spawned " + mobType + " with UUID: " + String.valueOf(mobUuid));
                    if (mobType.startsWith("Elite")) {
                        spawnLoc.getWorld().spawnParticle(Particle.FLAME, spawnLoc, 30, 0.5, 0.5, 0.5, 0.1);
                        spawnLoc.getWorld().spawnParticle(Particle.LAVA, spawnLoc, 10, 0.3, 0.3, 0.3, 0.05);
                        continue;
                    }
                    spawnLoc.getWorld().spawnParticle(Particle.FLAME, spawnLoc, 20, 0.5, 0.5, 0.5, 0.05);
                    continue;
                }
                EventNpcManager.this.plugin.getLogger().warning("Failed to spawn " + mobType + " - MythicMobs returned empty");
            }
            EventNpcManager.this.plugin.getLogger().info("Wave " + this.currentWave + " spawning complete - Spawned " + spawnedCount + " / " + this.monstersPerWave + " monsters");
        }

        public void stop() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
            for (UUID uuid : this.spawnedMonsters) {
                Entity entity = Bukkit.getEntity((UUID)uuid);
                if (entity == null || !entity.isValid()) continue;
                entity.remove();
            }
            this.spawnedMonsters.clear();
        }
    }

    private static class NpcRespawnData {
        private final Location location;

        public NpcRespawnData(Location location) {
            this.location = location;
        }

        public Location getLocation() {
            return this.location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NpcRespawnData that = (NpcRespawnData)o;
            return this.location.equals((Object)that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }
}

