/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.managers;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.PlayerData;
import com.candyrush.models.TeamColor;
import com.candyrush.utils.LanguageManager;
import com.candyrush.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PointConversionManager {
    private final CandyRushPlugin plugin;
    private final LanguageManager lang;
    private final Map<Material, Integer> foodPointValues;

    public PointConversionManager(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLanguageManager();
        this.foodPointValues = new HashMap<Material, Integer>();
        this.initializeFoodValues();
    }

    public void initialize() {
        this.plugin.getLogger().info("PointConversionManager initialized with " + this.foodPointValues.size() + " food types");
    }

    private void initializeFoodValues() {
        this.foodPointValues.put(Material.APPLE, 5);
        this.foodPointValues.put(Material.BREAD, 10);
        this.foodPointValues.put(Material.CARROT, 3);
        this.foodPointValues.put(Material.POTATO, 3);
        this.foodPointValues.put(Material.BAKED_POTATO, 8);
        this.foodPointValues.put(Material.BEETROOT, 3);
        this.foodPointValues.put(Material.MELON_SLICE, 2);
        this.foodPointValues.put(Material.SWEET_BERRIES, 2);
        this.foodPointValues.put(Material.COOKED_BEEF, 20);
        this.foodPointValues.put(Material.COOKED_PORKCHOP, 20);
        this.foodPointValues.put(Material.COOKED_CHICKEN, 15);
        this.foodPointValues.put(Material.COOKED_MUTTON, 15);
        this.foodPointValues.put(Material.COOKED_RABBIT, 12);
        this.foodPointValues.put(Material.COOKED_COD, 12);
        this.foodPointValues.put(Material.COOKED_SALMON, 15);
        this.foodPointValues.put(Material.COOKIE, 5);
        this.foodPointValues.put(Material.PUMPKIN_PIE, 15);
        this.foodPointValues.put(Material.CAKE, 25);
        this.foodPointValues.put(Material.GOLDEN_APPLE, 50);
        this.foodPointValues.put(Material.GOLDEN_CARROT, 30);
        this.foodPointValues.put(Material.ENCHANTED_GOLDEN_APPLE, 100);
        this.foodPointValues.put(Material.MUSHROOM_STEW, 15);
        this.foodPointValues.put(Material.RABBIT_STEW, 20);
        this.foodPointValues.put(Material.BEETROOT_SOUP, 15);
        this.foodPointValues.put(Material.SUSPICIOUS_STEW, 15);
    }

    public void onPlayerEatFood(Player player, Material food) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        if (!this.foodPointValues.containsKey(food)) {
            return;
        }
        int points = this.foodPointValues.get(food);
        PlayerData playerData = this.plugin.getPlayerManager().getOrCreatePlayerData(player);
        TeamColor teamColor = playerData.getTeamColor();
        if (teamColor == null) {
            return;
        }
        playerData.addPoints(points);
        this.plugin.getPlayerManager().savePlayerData(playerData);
        this.plugin.getTeamManager().addTeamPoints(teamColor, points);
        MessageUtils.sendActionBar(player, "&e+" + points + "pt &7(" + this.getFoodName(food) + ") &6\u5408\u8a08: " + MessageUtils.formatPoints(playerData.getPoints()) + "pt");
        this.plugin.getLogger().fine("Player " + player.getName() + " earned " + points + " points from " + String.valueOf(food));
    }

    public int convertAllFood(Player player) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            MessageUtils.sendMessage(player, this.lang.getMessage("game.not_running"));
            return 0;
        }
        PlayerData playerData = this.plugin.getPlayerManager().getOrCreatePlayerData(player);
        TeamColor teamColor = playerData.getTeamColor();
        if (teamColor == null) {
            MessageUtils.sendMessage(player, this.lang.getMessage("game.not_running"));
            return 0;
        }
        int totalPoints = 0;
        int totalItems = 0;
        HashMap<Material, Integer> convertedItems = new HashMap<Material, Integer>();
        for (ItemStack item : player.getInventory().getContents()) {
            Material material;
            if (item == null || item.getType() == Material.AIR || !this.foodPointValues.containsKey(material = item.getType())) continue;
            int itemPoints = this.foodPointValues.get(material);
            int amount = item.getAmount();
            int points = itemPoints * amount;
            totalPoints += points;
            totalItems += amount;
            convertedItems.put(material, convertedItems.getOrDefault(material, 0) + amount);
            item.setAmount(0);
        }
        if (totalPoints == 0) {
            MessageUtils.sendMessage(player, this.lang.getMessage("convert.nothing_to_convert"));
            return 0;
        }
        playerData.addPoints(totalPoints);
        this.plugin.getPlayerManager().savePlayerData(playerData);
        this.plugin.getTeamManager().addTeamPoints(teamColor, totalPoints);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("items", String.valueOf(totalItems));
        placeholders.put("points", MessageUtils.formatPoints(totalPoints));
        MessageUtils.sendMessage(player, this.lang.getMessage("convert.success"));
        MessageUtils.sendMessage(player, this.lang.getMessage("convert.converted", placeholders));
        placeholders.clear();
        placeholders.put("points", MessageUtils.formatPoints(playerData.getPoints()));
        MessageUtils.sendMessage(player, this.lang.getMessage("convert.total_points", placeholders));
        MessageUtils.sendTitle(player, "&6&l+" + MessageUtils.formatPoints(totalPoints) + "pt", this.lang.getMessage("convert.success"));
        this.plugin.getLogger().info("Player " + player.getName() + " converted food for " + totalPoints + " points");
        return totalPoints;
    }

    public boolean isFood(Material material) {
        return this.foodPointValues.containsKey(material);
    }

    public int getFoodPoints(Material material) {
        return this.foodPointValues.getOrDefault(material, 0);
    }

    private String getFoodName(Material material) {
        switch (material) {
            case APPLE: {
                return "\u30ea\u30f3\u30b4";
            }
            case BREAD: {
                return "\u30d1\u30f3";
            }
            case COOKED_BEEF: {
                return "\u713c\u304d\u725b\u8089";
            }
            case COOKED_CHICKEN: {
                return "\u713c\u304d\u9ce5";
            }
            case COOKED_PORKCHOP: {
                return "\u713c\u304d\u8c5a\u8089";
            }
            case GOLDEN_APPLE: {
                return "\u91d1\u306e\u30ea\u30f3\u30b4";
            }
            case GOLDEN_CARROT: {
                return "\u91d1\u306e\u30cb\u30f3\u30b8\u30f3";
            }
            case ENCHANTED_GOLDEN_APPLE: {
                return "\u30a8\u30f3\u30c1\u30e3\u30f3\u30c8\u91d1\u30ea\u30f3\u30b4";
            }
        }
        return material.name();
    }

    public void shutdown() {
        this.plugin.getLogger().info("PointConversionManager shutdown complete");
    }
}

