/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.managers;

import com.candyrush.CandyRushPlugin;
import com.candyrush.managers.TeamManager;
import com.candyrush.models.GameState;
import com.candyrush.models.PlayerData;
import com.candyrush.models.TeamColor;
import com.candyrush.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ScoreboardManager {
    private final CandyRushPlugin plugin;
    private BukkitTask updateTask;
    private Scoreboard mainScoreboard;

    public ScoreboardManager(CandyRushPlugin plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        org.bukkit.scoreboard.ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager != null) {
            this.mainScoreboard = manager.getMainScoreboard();
            this.setupMainScoreboardTeams();
        }
        this.startUpdateTask();
        this.plugin.getLogger().info("ScoreboardManager initialized");
    }

    private void setupMainScoreboardTeams() {
        Team blueTeam = this.mainScoreboard.getTeam("blue");
        if (blueTeam == null) {
            blueTeam = this.mainScoreboard.registerNewTeam("blue");
        }
        blueTeam.setColor(ChatColor.BLUE);
        blueTeam.setPrefix("\u00a79");
        blueTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
        Team greenTeam = this.mainScoreboard.getTeam("green");
        if (greenTeam == null) {
            greenTeam = this.mainScoreboard.registerNewTeam("green");
        }
        greenTeam.setColor(ChatColor.GREEN);
        greenTeam.setPrefix("\u00a7a");
        greenTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
        Team yellowTeam = this.mainScoreboard.getTeam("yellow");
        if (yellowTeam == null) {
            yellowTeam = this.mainScoreboard.registerNewTeam("yellow");
        }
        yellowTeam.setColor(ChatColor.YELLOW);
        yellowTeam.setPrefix("\u00a7e");
        yellowTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
        Team redTeam = this.mainScoreboard.getTeam("red");
        if (redTeam == null) {
            redTeam = this.mainScoreboard.registerNewTeam("red");
        }
        redTeam.setColor(ChatColor.RED);
        redTeam.setPrefix("\u00a7c");
        redTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
        this.plugin.getLogger().info("Main scoreboard teams created: blue, green, yellow (game teams) and red (murderer team)");
    }

    public void setupScoreboard(Player player) {
        org.bukkit.scoreboard.ScoreboardManager manager = Bukkit.getScoreboardManager();
        if (manager == null) {
            return;
        }
        Scoreboard playerScoreboard = manager.getNewScoreboard();
        Objective objective = playerScoreboard.registerNewObjective("candyrush", "dummy", MessageUtils.colorize("&e&l\u26a1 &6&lCandy Rush &e&l\u26a1"));
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.copyTeamsFromMainScoreboard(playerScoreboard);
        player.setScoreboard(playerScoreboard);
        this.updatePlayerScoreboard(player);
    }

    private void copyTeamsFromMainScoreboard(Scoreboard playerScoreboard) {
        Team mainRedTeam;
        Team mainYellowTeam;
        Team mainGreenTeam;
        if (this.mainScoreboard == null) {
            return;
        }
        Team mainBlueTeam = this.mainScoreboard.getTeam("blue");
        if (mainBlueTeam != null) {
            Team blueTeam = playerScoreboard.getTeam("blue");
            if (blueTeam == null) {
                blueTeam = playerScoreboard.registerNewTeam("blue");
            }
            blueTeam.setColor(ChatColor.BLUE);
            blueTeam.setPrefix("\u00a79");
            blueTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
            for (Object entry : mainBlueTeam.getEntries()) {
                if (blueTeam.hasEntry((String)entry)) continue;
                blueTeam.addEntry((String)entry);
            }
        }
        if ((mainGreenTeam = this.mainScoreboard.getTeam("green")) != null) {
            Team greenTeam = playerScoreboard.getTeam("green");
            if (greenTeam == null) {
                greenTeam = playerScoreboard.registerNewTeam("green");
            }
            greenTeam.setColor(ChatColor.GREEN);
            greenTeam.setPrefix("\u00a7a");
            greenTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
            for (Object entry : mainGreenTeam.getEntries()) {
                if (greenTeam.hasEntry((String)entry)) continue;
                greenTeam.addEntry((String)entry);
            }
        }
        if ((mainYellowTeam = this.mainScoreboard.getTeam("yellow")) != null) {
            Team yellowTeam = playerScoreboard.getTeam("yellow");
            if (yellowTeam == null) {
                yellowTeam = playerScoreboard.registerNewTeam("yellow");
            }
            yellowTeam.setColor(ChatColor.YELLOW);
            yellowTeam.setPrefix("\u00a7e");
            yellowTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
            for (String entry : mainYellowTeam.getEntries()) {
                if (yellowTeam.hasEntry(entry)) continue;
                yellowTeam.addEntry(entry);
            }
        }
        if ((mainRedTeam = this.mainScoreboard.getTeam("red")) != null) {
            Team redTeam = playerScoreboard.getTeam("red");
            if (redTeam == null) {
                redTeam = playerScoreboard.registerNewTeam("red");
            }
            redTeam.setColor(ChatColor.RED);
            redTeam.setPrefix("\u00a7c");
            redTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.ALWAYS);
            for (String entry : mainRedTeam.getEntries()) {
                if (redTeam.hasEntry(entry)) continue;
                redTeam.addEntry(entry);
            }
        }
    }

    public void updatePlayerScoreboard(Player player) {
        Scoreboard scoreboard = player.getScoreboard();
        if (scoreboard == null) {
            return;
        }
        Objective objective = scoreboard.getObjective("candyrush");
        if (objective == null) {
            return;
        }
        for (String entry : scoreboard.getEntries()) {
            scoreboard.resetScores(entry);
        }
        GameState gameState = this.plugin.getGameManager().getCurrentState();
        Optional<PlayerData> playerDataOpt = this.plugin.getPlayerManager().getPlayerData(player.getUniqueId());
        if (!playerDataOpt.isPresent()) {
            return;
        }
        PlayerData playerData = playerDataOpt.get();
        int line = 15;
        this.setScore(objective, " ", line--);
        switch (gameState) {
            case WAITING: {
                this.setScore(objective, MessageUtils.colorize("&7\u72b6\u614b: &e\u5f85\u6a5f\u4e2d"), line--);
                this.setScore(objective, MessageUtils.colorize("&7\u30d7\u30ec\u30a4\u30e4\u30fc: &a" + Bukkit.getOnlinePlayers().size() + "&7/&a" + this.plugin.getConfigManager().getMinPlayers()), line--);
                break;
            }
            case COUNTDOWN: {
                this.setScore(objective, MessageUtils.colorize("&7\u72b6\u614b: &e\u30ab\u30a6\u30f3\u30c8\u30c0\u30a6\u30f3"), line--);
                break;
            }
            case RUNNING: {
                int gameTimeRemaining = this.getGameTimeRemaining();
                this.setScore(objective, MessageUtils.colorize("&7\u6b8b\u308a\u6642\u9593: &c" + this.formatTime(gameTimeRemaining)), line--);
                this.setScore(objective, MessageUtils.colorize("  "), line--);
                TeamColor teamColor = playerData.getTeamColor();
                if (teamColor != null) {
                    this.setScore(objective, MessageUtils.colorize("&7\u30c1\u30fc\u30e0: " + teamColor.getFormattedName()), line--);
                } else {
                    this.setScore(objective, MessageUtils.colorize("&7\u30c1\u30fc\u30e0: &8\u306a\u3057"), line--);
                }
                this.setScore(objective, MessageUtils.colorize("   "), line--);
                this.setScore(objective, MessageUtils.colorize("&e\u2501\u2501\u2501 &6\u7d71\u8a08 &e\u2501\u2501\u2501"), line--);
                this.setScore(objective, MessageUtils.colorize("&7\u30dd\u30a4\u30f3\u30c8: &a" + playerData.getPoints()), line--);
                this.setScore(objective, MessageUtils.colorize("&7PK: &c" + playerData.getPk()), line--);
                this.setScore(objective, MessageUtils.colorize("&7PKK: &6" + playerData.getPkk()), line--);
                if (!playerData.isMurderer()) break;
                this.setScore(objective, MessageUtils.colorize("    "), line--);
                this.setScore(objective, MessageUtils.colorize("&4&l\u26a0 \u6bba\u4eba\u8005 \u26a0"), line--);
                break;
            }
            case COOLDOWN: {
                this.setScore(objective, MessageUtils.colorize("&7\u72b6\u614b: &e\u30af\u30fc\u30eb\u30c0\u30a6\u30f3"), line--);
                this.setScore(objective, MessageUtils.colorize("  "), line--);
                this.setScore(objective, MessageUtils.colorize("&e\u2501\u2501\u2501 &6\u6700\u7d42\u30b9\u30b3\u30a2 &e\u2501\u2501\u2501"), line--);
                this.setScore(objective, MessageUtils.colorize("&7\u30dd\u30a4\u30f3\u30c8: &a" + playerData.getPoints()), line--);
                this.setScore(objective, MessageUtils.colorize("&7PK: &c" + playerData.getPk()), line--);
                this.setScore(objective, MessageUtils.colorize("&7PKK: &6" + playerData.getPkk()), line--);
            }
        }
        this.setScore(objective, MessageUtils.colorize("     "), line--);
        if (gameState == GameState.RUNNING) {
            this.setScore(objective, MessageUtils.colorize("&e\u2501\u2501\u2501 &6\u30c1\u30fc\u30e0\u9806\u4f4d &e\u2501\u2501\u2501"), line--);
            this.displayTeamRankings(objective, line);
        }
    }

    private void displayTeamRankings(Objective objective, int startLine) {
        TeamManager teamManager = this.plugin.getTeamManager();
        if (teamManager == null) {
            return;
        }
        int line = startLine;
        ArrayList<TeamColor> teams = new ArrayList<TeamColor>(Arrays.asList(TeamColor.values()));
        teams.sort((t1, t2) -> Integer.compare(teamManager.getTeamPoints((TeamColor)((Object)t2)), teamManager.getTeamPoints((TeamColor)((Object)t1))));
        int rank = 1;
        for (TeamColor team : teams) {
            if (rank > 3) break;
            int points = teamManager.getTeamPoints(team);
            String medal = rank == 1 ? "&6\ud83e\udd47" : (rank == 2 ? "&7\ud83e\udd48" : "&c\ud83e\udd49");
            this.setScore(objective, MessageUtils.colorize(medal + " " + team.getFormattedName() + " &7: &a" + points), line--);
            ++rank;
        }
    }

    private void setScore(Objective objective, String text, int score) {
        String entry = text;
        if (entry.length() > 40) {
            entry = entry.substring(0, 40);
        }
        Score scoreEntry = objective.getScore(entry);
        scoreEntry.setScore(score);
    }

    public void updateAllScoreboards() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updatePlayerScoreboard(player);
        }
    }

    public void updateTeamScoreboards(TeamColor teamColor) {
        com.candyrush.models.Team team = this.plugin.getTeamManager().getTeam(teamColor);
        if (team == null) {
            this.plugin.getLogger().warning("Cannot update scoreboards for team " + String.valueOf((Object)teamColor) + " - team not found");
            return;
        }
        int updatedCount = 0;
        for (UUID uuid : team.getPlayerUuids()) {
            Player player = Bukkit.getPlayer((UUID)uuid);
            if (player == null || !player.isOnline()) continue;
            this.updatePlayerScoreboard(player);
            ++updatedCount;
        }
        this.plugin.getLogger().fine("Updated scoreboards for " + updatedCount + " players in " + String.valueOf((Object)teamColor) + " team");
    }

    private void startUpdateTask() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        this.updateTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> this.updateAllScoreboards(), 20L, 20L);
    }

    public void clearScoreboard(Player player) {
        player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
    }

    private int getGameTimeRemaining() {
        return this.plugin.getGameManager().getGameTimeRemaining();
    }

    private String formatTime(int seconds) {
        int minutes = seconds / 60;
        int secs = seconds % 60;
        return String.format("%02d:%02d", minutes, secs);
    }

    public void shutdown() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.clearScoreboard(player);
        }
        this.plugin.getLogger().info("ScoreboardManager shutdown complete");
    }
}

