/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.models;

import com.candyrush.models.TeamColor;

public class GameRound {
    private final Integer id;
    private final long startedAt;
    private Long endedAt;
    private TeamColor winnerTeam;
    private int totalPlayers;
    private Integer durationSeconds;
    private final long createdAt;

    public GameRound(int totalPlayers) {
        long now;
        this.id = null;
        this.startedAt = now = System.currentTimeMillis() / 1000L;
        this.endedAt = null;
        this.winnerTeam = null;
        this.totalPlayers = totalPlayers;
        this.durationSeconds = null;
        this.createdAt = now;
    }

    public GameRound(Integer id, long startedAt, Long endedAt, TeamColor winnerTeam, int totalPlayers, Integer durationSeconds, long createdAt) {
        this.id = id;
        this.startedAt = startedAt;
        this.endedAt = endedAt;
        this.winnerTeam = winnerTeam;
        this.totalPlayers = totalPlayers;
        this.durationSeconds = durationSeconds;
        this.createdAt = createdAt;
    }

    public Integer getId() {
        return this.id;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public Long getEndedAt() {
        return this.endedAt;
    }

    public TeamColor getWinnerTeam() {
        return this.winnerTeam;
    }

    public int getTotalPlayers() {
        return this.totalPlayers;
    }

    public Integer getDurationSeconds() {
        return this.durationSeconds;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean isOngoing() {
        return this.endedAt == null;
    }

    public boolean hasEnded() {
        return this.endedAt != null;
    }

    public boolean hasWinner() {
        return this.winnerTeam != null;
    }

    public boolean isPersisted() {
        return this.id != null;
    }

    public void endGame(TeamColor winnerTeam) {
        long now = System.currentTimeMillis() / 1000L;
        this.endedAt = now;
        this.winnerTeam = winnerTeam;
        this.durationSeconds = (int)(now - this.startedAt);
    }

    public void setTotalPlayers(int totalPlayers) {
        this.totalPlayers = totalPlayers;
    }

    public long getElapsedSeconds() {
        long now = System.currentTimeMillis() / 1000L;
        return now - this.startedAt;
    }

    public long getRemainingSeconds(int configuredDuration) {
        long elapsed = this.getElapsedSeconds();
        long remaining = (long)configuredDuration - elapsed;
        return Math.max(0L, remaining);
    }

    public boolean isTimeExpired(int configuredDuration) {
        return this.getElapsedSeconds() >= (long)configuredDuration;
    }

    public String getFormattedDuration() {
        int seconds = this.durationSeconds != null ? this.durationSeconds : (int)this.getElapsedSeconds();
        int minutes = seconds / 60;
        int secs = seconds % 60;
        return String.format("%02d:%02d", minutes, secs);
    }

    public String toString() {
        return "GameRound{id=" + this.id + ", startedAt=" + this.startedAt + ", endedAt=" + this.endedAt + ", winnerTeam=" + String.valueOf((Object)this.winnerTeam) + ", totalPlayers=" + this.totalPlayers + ", durationSeconds=" + this.durationSeconds + ", ongoing=" + this.isOngoing() + "}";
    }
}

