/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.models;

import java.util.List;
import java.util.Objects;

public class NPCEventTier {
    private final int tier;
    private final String npcMobType;
    private final List<String> monsters;
    private final int rewardPointsMin;
    private final int rewardPointsMax;
    private final int bossSpawnPoints;
    private final String displayNameFormat;
    private final int monsterWaves;
    private final int monstersPerWave;
    private final int defenseDurationSeconds;
    private final int waveIntervalSeconds;
    private final int spawnWeight;

    public NPCEventTier(int tier, String npcMobType, List<String> monsters, int rewardPointsMin, int rewardPointsMax, int bossSpawnPoints, String displayNameFormat, int monsterWaves, int monstersPerWave, int defenseDurationSeconds, int waveIntervalSeconds, int spawnWeight) {
        if (tier < 1 || tier > 5) {
            throw new IllegalArgumentException("Tier must be between 1 and 5");
        }
        if (npcMobType == null || npcMobType.isEmpty()) {
            throw new IllegalArgumentException("NPC mob type cannot be null or empty");
        }
        if (monsters == null || monsters.isEmpty()) {
            throw new IllegalArgumentException("Monsters list cannot be null or empty");
        }
        if (rewardPointsMin < 0) {
            throw new IllegalArgumentException("Reward points min cannot be negative");
        }
        if (rewardPointsMax < rewardPointsMin) {
            throw new IllegalArgumentException("Reward points max must be >= min");
        }
        if (bossSpawnPoints <= 0) {
            throw new IllegalArgumentException("Boss spawn points must be positive");
        }
        if (displayNameFormat == null || !displayNameFormat.contains("{name}")) {
            throw new IllegalArgumentException("Display name format must contain {name} placeholder");
        }
        if (monsterWaves <= 0) {
            throw new IllegalArgumentException("Monster waves must be positive");
        }
        if (monstersPerWave <= 0) {
            throw new IllegalArgumentException("Monsters per wave must be positive");
        }
        if (defenseDurationSeconds <= 0) {
            throw new IllegalArgumentException("Defense duration must be positive");
        }
        if (waveIntervalSeconds < 0) {
            throw new IllegalArgumentException("Wave interval cannot be negative");
        }
        if (spawnWeight <= 0) {
            throw new IllegalArgumentException("Spawn weight must be positive");
        }
        this.tier = tier;
        this.npcMobType = npcMobType;
        this.monsters = List.copyOf(monsters);
        this.rewardPointsMin = rewardPointsMin;
        this.rewardPointsMax = rewardPointsMax;
        this.bossSpawnPoints = bossSpawnPoints;
        this.displayNameFormat = displayNameFormat;
        this.monsterWaves = monsterWaves;
        this.monstersPerWave = monstersPerWave;
        this.defenseDurationSeconds = defenseDurationSeconds;
        this.waveIntervalSeconds = waveIntervalSeconds;
        this.spawnWeight = spawnWeight;
    }

    public int getTier() {
        return this.tier;
    }

    public String getNpcMobType() {
        return this.npcMobType;
    }

    public List<String> getMonsters() {
        return this.monsters;
    }

    public int getRewardPointsMin() {
        return this.rewardPointsMin;
    }

    public int getRewardPointsMax() {
        return this.rewardPointsMax;
    }

    public int getBossSpawnPoints() {
        return this.bossSpawnPoints;
    }

    public String getDisplayNameFormat() {
        return this.displayNameFormat;
    }

    public int getMonsterWaves() {
        return this.monsterWaves;
    }

    public int getMonstersPerWave() {
        return this.monstersPerWave;
    }

    public int getDefenseDurationSeconds() {
        return this.defenseDurationSeconds;
    }

    public int getWaveIntervalSeconds() {
        return this.waveIntervalSeconds;
    }

    public int getSpawnWeight() {
        return this.spawnWeight;
    }

    public String formatDisplayName(String name) {
        return this.displayNameFormat.replace("{name}", name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPCEventTier that = (NPCEventTier)o;
        return this.tier == that.tier;
    }

    public int hashCode() {
        return Objects.hash(this.tier);
    }

    public String toString() {
        return "NPCEventTier{tier=" + this.tier + ", npcMobType='" + this.npcMobType + "', monsters=" + String.valueOf(this.monsters) + ", rewardPoints=" + this.rewardPointsMin + "-" + this.rewardPointsMax + ", bossSpawnPoints=" + this.bossSpawnPoints + "}";
    }
}

