/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.models;

import com.candyrush.models.TeamColor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;

public class Team {
    private final TeamColor color;
    private final Set<UUID> playerUuids;
    private int points;
    private int kills;
    private int deaths;
    private Location spawnPoint;
    private Location flagLocation;

    public Team(TeamColor color) {
        this.color = color;
        this.playerUuids = new HashSet<UUID>();
        this.points = 0;
        this.kills = 0;
        this.deaths = 0;
        this.spawnPoint = null;
        this.flagLocation = null;
    }

    public TeamColor getColor() {
        return this.color;
    }

    public Set<UUID> getPlayerUuids() {
        return Collections.unmodifiableSet(this.playerUuids);
    }

    public int getPlayerCount() {
        return this.playerUuids.size();
    }

    public int getPoints() {
        return this.points;
    }

    public int getKills() {
        return this.kills;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public Location getSpawnPoint() {
        return this.spawnPoint;
    }

    public Location getFlagLocation() {
        return this.flagLocation;
    }

    public boolean addPlayer(UUID uuid) {
        return this.playerUuids.add(uuid);
    }

    public boolean removePlayer(UUID uuid) {
        return this.playerUuids.remove(uuid);
    }

    public boolean hasPlayer(UUID uuid) {
        return this.playerUuids.contains(uuid);
    }

    public void clearPlayers() {
        this.playerUuids.clear();
    }

    public void addPoints(int amount) {
        this.points += amount;
        if (this.points < 0) {
            this.points = 0;
        }
    }

    public void setPoints(int points) {
        this.points = Math.max(0, points);
    }

    public void incrementKills() {
        ++this.kills;
    }

    public void incrementDeaths() {
        ++this.deaths;
    }

    public void addKills(int amount) {
        this.kills += Math.max(0, amount);
    }

    public void addDeaths(int amount) {
        this.deaths += Math.max(0, amount);
    }

    public void setSpawnPoint(Location location) {
        this.spawnPoint = location != null ? location.clone() : null;
    }

    public void setFlagLocation(Location location) {
        this.flagLocation = location != null ? location.clone() : null;
    }

    public void reset() {
        this.points = 0;
        this.kills = 0;
        this.deaths = 0;
        this.playerUuids.clear();
    }

    public double getKDRatio() {
        if (this.deaths == 0) {
            return this.kills;
        }
        return (double)this.kills / (double)this.deaths;
    }

    public double getAveragePoints() {
        if (this.playerUuids.isEmpty()) {
            return 0.0;
        }
        return (double)this.points / (double)this.playerUuids.size();
    }

    public boolean isEmpty() {
        return this.playerUuids.isEmpty();
    }

    public String getFormattedName() {
        return this.color.getFormattedName();
    }

    public String toString() {
        return "Team{color=" + String.valueOf((Object)this.color) + ", players=" + this.playerUuids.size() + ", points=" + this.points + ", kills=" + this.kills + ", deaths=" + this.deaths + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Team team = (Team)o;
        return this.color == team.color;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color});
    }
}

