/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.storage;

import com.candyrush.models.PlayerData;
import com.candyrush.models.TeamColor;
import com.candyrush.storage.DatabaseInitializer;
import com.candyrush.storage.PlayerDataStorage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class PlayerDataStorageImpl
implements PlayerDataStorage {
    private final DatabaseInitializer databaseInitializer;

    public PlayerDataStorageImpl(DatabaseInitializer databaseInitializer) {
        this.databaseInitializer = databaseInitializer;
    }

    @Override
    public Optional<PlayerData> loadPlayer(UUID uuid) throws SQLException {
        String sql = "SELECT * FROM players WHERE uuid = ?";
        try (Connection conn = this.databaseInitializer.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    Optional<PlayerData> optional = Optional.of(this.parsePlayerData(rs));
                    return optional;
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public void savePlayer(PlayerData playerData) throws SQLException {
        String sql = "INSERT INTO players (uuid, name, team_color, points, kills, deaths, chests_opened, events_completed, boss_spawn_points, is_murderer, murderer_until, last_seen, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT(uuid) DO UPDATE SET name = excluded.name, team_color = excluded.team_color, points = excluded.points, kills = excluded.kills, deaths = excluded.deaths, chests_opened = excluded.chests_opened, events_completed = excluded.events_completed, boss_spawn_points = excluded.boss_spawn_points, is_murderer = excluded.is_murderer, murderer_until = excluded.murderer_until, last_seen = excluded.last_seen, updated_at = excluded.updated_at";
        try (Connection conn = this.databaseInitializer.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, playerData.getUuid().toString());
            stmt.setString(2, playerData.getName());
            stmt.setString(3, playerData.getTeamColor() != null ? playerData.getTeamColor().name() : null);
            stmt.setInt(4, playerData.getPoints());
            stmt.setInt(5, playerData.getPk());
            stmt.setInt(6, playerData.getPkk());
            stmt.setInt(7, playerData.getChestsOpened());
            stmt.setInt(8, playerData.getEventsCompleted());
            stmt.setInt(9, playerData.getBossSpawnPoints());
            stmt.setInt(10, playerData.isMurderer() ? 1 : 0);
            stmt.setLong(11, playerData.getMurdererUntil());
            stmt.setLong(12, playerData.getLastSeen());
            stmt.setLong(13, playerData.getCreatedAt());
            stmt.setLong(14, playerData.getUpdatedAt());
            stmt.executeUpdate();
        }
    }

    @Override
    public void deletePlayer(UUID uuid) throws SQLException {
        String sql = "DELETE FROM players WHERE uuid = ?";
        try (Connection conn = this.databaseInitializer.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            stmt.executeUpdate();
        }
    }

    @Override
    public List<PlayerData> loadPlayersByTeam(TeamColor teamColor) throws SQLException {
        String sql = "SELECT * FROM players WHERE team_color = ? ORDER BY points DESC";
        ArrayList<PlayerData> players = new ArrayList<PlayerData>();
        try (Connection conn = this.databaseInitializer.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, teamColor.name());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    players.add(this.parsePlayerData(rs));
                }
            }
        }
        return players;
    }

    @Override
    public List<PlayerData> getTopPlayers(int limit) throws SQLException {
        String sql = "SELECT * FROM players ORDER BY points DESC LIMIT ?";
        ArrayList<PlayerData> players = new ArrayList<PlayerData>();
        try (Connection conn = this.databaseInitializer.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setInt(1, limit);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    players.add(this.parsePlayerData(rs));
                }
            }
        }
        return players;
    }

    @Override
    public List<PlayerData> getActiveMurderers() throws SQLException {
        long now = System.currentTimeMillis() / 1000L;
        String sql = "SELECT * FROM players WHERE is_murderer = 1 AND murderer_until > ?";
        ArrayList<PlayerData> murderers = new ArrayList<PlayerData>();
        try (Connection conn = this.databaseInitializer.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setLong(1, now);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    murderers.add(this.parsePlayerData(rs));
                }
            }
        }
        return murderers;
    }

    @Override
    public void clearAllTeamAssignments() throws SQLException {
        String sql = "UPDATE players SET team_color = NULL, updated_at = ?";
        try (Connection conn = this.databaseInitializer.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setLong(1, System.currentTimeMillis() / 1000L);
            stmt.executeUpdate();
        }
    }

    @Override
    public void resetAllPoints() throws SQLException {
        String sql = "UPDATE players SET points = 0, updated_at = ?";
        try (Connection conn = this.databaseInitializer.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setLong(1, System.currentTimeMillis() / 1000L);
            stmt.executeUpdate();
        }
    }

    @Override
    public int getTotalPlayerCount() throws SQLException {
        String sql = "SELECT COUNT(*) FROM players";
        try (Connection conn = this.databaseInitializer.getConnection();
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
        }
        return 0;
    }

    private PlayerData parsePlayerData(ResultSet rs) throws SQLException {
        UUID uuid = UUID.fromString(rs.getString("uuid"));
        String name = rs.getString("name");
        String teamColorStr = rs.getString("team_color");
        TeamColor teamColor = teamColorStr != null ? TeamColor.valueOf(teamColorStr) : null;
        int points = rs.getInt("points");
        int pk = rs.getInt("kills");
        int pkk = rs.getInt("deaths");
        int chestsOpened = rs.getInt("chests_opened");
        int eventsCompleted = rs.getInt("events_completed");
        int bossSpawnPoints = rs.getInt("boss_spawn_points");
        boolean isMurderer = rs.getInt("is_murderer") == 1;
        long murdererUntil = rs.getLong("murderer_until");
        long lastSeen = rs.getLong("last_seen");
        long createdAt = rs.getLong("created_at");
        long updatedAt = rs.getLong("updated_at");
        return new PlayerData(uuid, name, teamColor, points, pk, pkk, chestsOpened, eventsCompleted, bossSpawnPoints, isMurderer, murdererUntil, lastSeen, createdAt, updatedAt);
    }
}

