/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.tasks;

import com.candyrush.CandyRushPlugin;
import com.candyrush.managers.PlayerManager;
import com.candyrush.models.PlayerData;
import com.candyrush.storage.PlayerDataStorage;
import java.sql.SQLException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MurdererExpirationTask
extends BukkitRunnable {
    private final CandyRushPlugin plugin;
    private final PlayerManager playerManager;
    private final PlayerDataStorage playerDataStorage;

    public MurdererExpirationTask(CandyRushPlugin plugin, PlayerManager playerManager, PlayerDataStorage playerDataStorage) {
        this.plugin = plugin;
        this.playerManager = playerManager;
        this.playerDataStorage = playerDataStorage;
    }

    public void run() {
        long currentTime = System.currentTimeMillis() / 1000L;
        int expiredCount = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            try {
                PlayerData data = this.playerManager.getPlayerData(player.getUniqueId()).orElse(null);
                if (data == null || !data.isMurderer() || data.getMurdererUntil() <= 0L || currentTime <= data.getMurdererUntil()) continue;
                data.clearMurderer();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    try {
                        this.playerDataStorage.savePlayer(data);
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Failed to save player data after murderer expiration for " + player.getName(), e);
                    }
                });
                this.playerManager.updatePlayerTeamColor(player);
                player.sendMessage("\u00a7a\u6bba\u4eba\u8005\u30b9\u30c6\u30fc\u30bf\u30b9\u304c\u89e3\u9664\u3055\u308c\u307e\u3057\u305f");
                this.plugin.getLogger().info("Expired murderer status for " + player.getName() + " (was set until " + data.getMurdererUntil() + ", now is " + currentTime + ")");
                ++expiredCount;
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error checking murderer expiration for " + player.getName(), e);
            }
        }
        if (expiredCount > 0) {
            this.plugin.getLogger().info("MurdererExpirationTask: Expired " + expiredCount + " murderer statuses");
        }
    }
}

