/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.utils;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.NPCEventTier;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final CandyRushPlugin plugin;
    private final FileConfiguration config;
    private Map<Integer, NPCEventTier> eventTiers;
    private List<String> npcNames;

    public ConfigManager(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.eventTiers = new HashMap<Integer, NPCEventTier>();
        this.npcNames = new ArrayList<String>();
        this.loadEventTiers();
        this.loadNpcNames();
    }

    public String getLanguage() {
        return this.config.getString("language", "ja");
    }

    public int getMinPlayers() {
        return this.config.getInt("game.min-players", 2);
    }

    public int getCountdownSeconds() {
        return this.config.getInt("game.countdown-seconds", 10);
    }

    public int getCooldownMinutes() {
        return this.config.getInt("game.cooldown-minutes", 5);
    }

    public int getGameDurationMinutes() {
        return this.config.getInt("game.duration-minutes", 20);
    }

    public int getMapRadius() {
        return this.config.getInt("game.map-radius", 250);
    }

    public Integer getMapCenterX() {
        if (this.config.isSet("game.center-x") && this.config.get("game.center-x") != null) {
            return this.config.getInt("game.center-x");
        }
        return null;
    }

    public Integer getMapCenterZ() {
        if (this.config.isSet("game.center-z") && this.config.get("game.center-z") != null) {
            return this.config.getInt("game.center-z");
        }
        return null;
    }

    public void setMapCenter(int x, int z) {
        this.config.set("game.center-x", (Object)x);
        this.config.set("game.center-z", (Object)z);
        this.plugin.saveConfig();
    }

    public void clearMapCenter() {
        this.config.set("game.center-x", null);
        this.config.set("game.center-z", null);
        this.plugin.saveConfig();
    }

    public int getTreasurePerChunk() {
        return this.config.getInt("treasure.per-chunk", 1);
    }

    public double getTrappedChestDamage() {
        return this.config.getDouble("treasure.trapped-chest-damage", 4.0);
    }

    public double getTrappedChestEquipmentChance() {
        return this.config.getDouble("treasure.trapped-chest-equipment-chance", 0.7);
    }

    public int getTreasureRespawnDelay() {
        return this.config.getInt("treasure.respawn-delay-seconds", 60);
    }

    public int getTreasureSpawnMinHeight() {
        return this.config.getInt("treasure.spawn-min-height", 60);
    }

    public int getTreasureSpawnMaxHeight() {
        return this.config.getInt("treasure.spawn-max-height", 200);
    }

    public int getEventNpcPerChunks() {
        return this.config.getInt("event.npc-per-chunks", 3);
    }

    public int getProximityRange() {
        return this.config.getInt("event.proximity-range", 10);
    }

    public int getHelpMessageCooldown() {
        return this.config.getInt("event.help-message-cooldown", 5);
    }

    public int getDefenseDurationSeconds() {
        return this.config.getInt("event.defense-duration-seconds", 120);
    }

    public int getMonsterWaves() {
        return this.config.getInt("event.monster-waves", 3);
    }

    public int getMonstersPerWave() {
        return this.config.getInt("event.monsters-per-wave", 5);
    }

    public int getWaveIntervalSeconds() {
        return this.config.getInt("event.wave-interval-seconds", 30);
    }

    public int getRewardPointsMin() {
        return this.config.getInt("event.reward-points-min", 50);
    }

    public int getRewardPointsMax() {
        return this.config.getInt("event.reward-points-max", 100);
    }

    public List<String> getDefenseMobs() {
        return this.config.getStringList("mythicmobs.defense-mobs");
    }

    public List<String> getDefenseEliteMobs() {
        return this.config.getStringList("mythicmobs.defense-elite-mobs");
    }

    public int getBossSpawnThreshold() {
        return this.config.getInt("event.boss-spawn-threshold", 3);
    }

    public int getNpcRespawnDelay() {
        return this.config.getInt("event.npc-respawn-delay-seconds", 120);
    }

    public int getMurdererDurationSeconds() {
        return this.config.getInt("murderer.duration-seconds", 600);
    }

    public String getWeather() {
        return this.config.getString("world.weather", "CLEAR");
    }

    public boolean isAutoMorning() {
        return this.config.getBoolean("world.auto-morning", true);
    }

    public String getEventNpcType() {
        return this.config.getString("mythicmobs.event-npc-type", "EventNPC");
    }

    public List<String> getBossTypes() {
        List<String> bossTypes = this.config.getStringList("mythicmobs.boss-types");
        if (bossTypes.isEmpty()) {
            String oldBossType = this.config.getString("mythicmobs.boss-type", "SugarLord");
            bossTypes = Arrays.asList(oldBossType);
        }
        return bossTypes;
    }

    public String getDatabaseType() {
        return this.config.getString("database.type", "sqlite");
    }

    public String getSqliteFile() {
        return this.config.getString("database.sqlite.file", "data.db");
    }

    public boolean isDebugEnabled() {
        return this.config.getBoolean("debug.enabled", false);
    }

    public boolean isVerboseLogging() {
        return this.config.getBoolean("debug.verbose-logging", false);
    }

    public String getPrefix() {
        return this.config.getString("messages.prefix", "&6[CandyRush] &r");
    }

    public List<NPCEventTier> getEventTiers() {
        ArrayList<NPCEventTier> tiers = new ArrayList<NPCEventTier>();
        for (int i = 1; i <= 5; ++i) {
            NPCEventTier tier = this.eventTiers.get(i);
            if (tier == null) continue;
            tiers.add(tier);
        }
        return tiers;
    }

    public NPCEventTier getEventTier(int tier) {
        if (tier < 1 || tier > 5) {
            return null;
        }
        return this.eventTiers.get(tier);
    }

    public int getBossSpawnPointThreshold() {
        return this.config.getInt("event.boss-spawn-point-threshold", 100);
    }

    public List<String> getNpcNames() {
        return new ArrayList<String>(this.npcNames);
    }

    private void loadEventTiers() {
        this.eventTiers.clear();
        ConfigurationSection tiersSection = this.config.getConfigurationSection("event.tiers");
        if (tiersSection == null) {
            this.plugin.getLogger().warning("No event.tiers section found in config.yml");
            return;
        }
        for (int tier = 1; tier <= 5; ++tier) {
            ConfigurationSection tierSection = tiersSection.getConfigurationSection(String.valueOf(tier));
            if (tierSection == null) {
                this.plugin.getLogger().warning("Tier " + tier + " configuration not found in config.yml");
                continue;
            }
            try {
                String npcMobType = tierSection.getString("npc-mob-type");
                List monsters = tierSection.getStringList("monsters");
                int rewardPointsMin = tierSection.getInt("reward-points-min");
                int rewardPointsMax = tierSection.getInt("reward-points-max");
                int bossSpawnPoints = tierSection.getInt("boss-spawn-points");
                String displayNameFormat = tierSection.getString("display-name-format");
                int monsterWaves = tierSection.getInt("monster-waves", this.config.getInt("event.monster-waves", 3));
                int monstersPerWave = tierSection.getInt("monsters-per-wave", this.config.getInt("event.monsters-per-wave", 5));
                int defenseDuration = tierSection.getInt("defense-duration-seconds", this.config.getInt("event.defense-duration-seconds", 120));
                int waveInterval = tierSection.getInt("wave-interval-seconds", this.config.getInt("event.wave-interval-seconds", 30));
                int spawnWeight = tierSection.getInt("spawn-weight", 20);
                if (npcMobType == null || npcMobType.isEmpty()) {
                    this.plugin.getLogger().severe("Tier " + tier + ": npc-mob-type is missing or empty");
                    continue;
                }
                if (monsters == null || monsters.isEmpty()) {
                    this.plugin.getLogger().severe("Tier " + tier + ": monsters list is missing or empty");
                    continue;
                }
                if (displayNameFormat == null || !displayNameFormat.contains("{name}")) {
                    this.plugin.getLogger().severe("Tier " + tier + ": display-name-format must contain {name} placeholder");
                    continue;
                }
                if (rewardPointsMax < rewardPointsMin) {
                    this.plugin.getLogger().severe("Tier " + tier + ": reward-points-max must be >= reward-points-min");
                    continue;
                }
                if (bossSpawnPoints <= 0) {
                    this.plugin.getLogger().severe("Tier " + tier + ": boss-spawn-points must be positive");
                    continue;
                }
                NPCEventTier eventTier = new NPCEventTier(tier, npcMobType, monsters, rewardPointsMin, rewardPointsMax, bossSpawnPoints, displayNameFormat, monsterWaves, monstersPerWave, defenseDuration, waveInterval, spawnWeight);
                this.eventTiers.put(tier, eventTier);
                this.plugin.getLogger().info("Loaded tier " + tier + " configuration: " + String.valueOf(eventTier));
                continue;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to load tier " + tier + " configuration: " + e.getMessage());
            }
        }
        if (this.eventTiers.size() != 5) {
            this.plugin.getLogger().warning("Expected 5 tiers but loaded " + this.eventTiers.size() + " tiers");
        }
    }

    private void loadNpcNames() {
        this.npcNames.clear();
        File namesFile = new File(this.plugin.getDataFolder(), "npc-names.yml");
        if (!namesFile.exists()) {
            this.plugin.getLogger().warning("npc-names.yml not found, using default fallback names");
            this.npcNames.addAll(List.of("\u592a\u90ce", "\u6b21\u90ce", "\u3055\u304f\u3089", "\u82b1", "\u60a0", "\u5149", "\u3042\u3081\u3061\u3083\u3093", "\u30ad\u30e3\u30f3\u30c7\u30a3", "\u30df\u30f3\u30c8", "\u30b3\u30b3\u30a2"));
            return;
        }
        try {
            YamlConfiguration namesConfig = YamlConfiguration.loadConfiguration((File)namesFile);
            List names = namesConfig.getStringList("npc-names");
            if (names.isEmpty()) {
                this.plugin.getLogger().warning("No names found in npc-names.yml, using fallback names");
                this.npcNames.addAll(List.of("\u592a\u90ce", "\u6b21\u90ce", "\u3055\u304f\u3089", "\u82b1", "\u60a0", "\u5149", "\u3042\u3081\u3061\u3083\u3093", "\u30ad\u30e3\u30f3\u30c7\u30a3", "\u30df\u30f3\u30c8", "\u30b3\u30b3\u30a2"));
            } else {
                this.npcNames.addAll(names);
                this.plugin.getLogger().info("Loaded " + this.npcNames.size() + " NPC names from npc-names.yml");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load npc-names.yml: " + e.getMessage());
            this.npcNames.addAll(List.of("\u592a\u90ce", "\u6b21\u90ce", "\u3055\u304f\u3089", "\u82b1", "\u60a0", "\u5149", "\u3042\u3081\u3061\u3083\u3093", "\u30ad\u30e3\u30f3\u30c7\u30a3", "\u30df\u30f3\u30c8", "\u30b3\u30b3\u30a2"));
        }
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.loadEventTiers();
        this.loadNpcNames();
    }
}

