/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.utils;

import com.candyrush.models.NPCEventTier;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class NpcNameGenerator {
    private final List<String> names;
    private final Random random;

    public NpcNameGenerator(List<String> names) {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("Name pool cannot be null or empty");
        }
        this.names = new ArrayList<String>(names);
        this.random = new Random();
    }

    public String getRandomName() {
        return this.names.get(this.random.nextInt(this.names.size()));
    }

    public String getFormattedName(NPCEventTier tier) {
        String randomName = this.getRandomName();
        return tier.formatDisplayName(randomName);
    }

    public int getNamePoolSize() {
        return this.names.size();
    }

    public boolean hasAdequateNames(int minimumSize) {
        return this.names.size() >= minimumSize;
    }
}

