/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.integration;

import com.candyrush.CandyRushPlugin;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;

public class MythicMobsIntegration {
    private final CandyRushPlugin plugin;
    private MythicBukkit mythicMobs;
    private boolean initialized = false;

    public MythicMobsIntegration(CandyRushPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean initialize() {
        try {
            this.mythicMobs = MythicBukkit.inst();
            if (this.mythicMobs == null) {
                this.plugin.getLogger().severe("MythicMobs instance not found!");
                return false;
            }
            this.copyMythicMobsConfigs();
            this.initialized = true;
            this.plugin.getLogger().info("MythicMobs integration initialized successfully");
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to initialize MythicMobs integration: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean isInitialized() {
        return this.initialized && this.mythicMobs != null;
    }

    public Optional<ActiveMob> spawnMob(String mobType, Location location, int level) {
        if (!this.isInitialized()) {
            this.plugin.getLogger().warning("Attempted to spawn mob but MythicMobs is not initialized");
            return Optional.empty();
        }
        try {
            ActiveMob mob;
            Entity spawnedEntity = this.mythicMobs.getAPIHelper().spawnMythicMob(mobType, location, level);
            if (spawnedEntity == null) {
                this.plugin.getLogger().warning("Failed to spawn MythicMob: " + mobType + " (mob type may not exist)");
                return Optional.empty();
            }
            if (spawnedEntity instanceof Entity && (mob = this.mythicMobs.getAPIHelper().getMythicMobInstance(spawnedEntity)) != null) {
                this.plugin.getLogger().fine("Spawned MythicMob: " + mobType + " at " + this.formatLocation(location));
                return Optional.of(mob);
            }
            this.plugin.getLogger().warning("Failed to convert spawned mob to ActiveMob: " + mobType);
            return Optional.empty();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error spawning MythicMob " + mobType + ": " + e.getMessage());
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public Optional<ActiveMob> spawnMob(String mobType, Location location) {
        return this.spawnMob(mobType, location, 1);
    }

    public boolean isMythicMob(Entity entity) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.mythicMobs.getAPIHelper().isMythicMob(entity);
    }

    public Optional<ActiveMob> getActiveMob(Entity entity) {
        if (!this.isInitialized()) {
            return Optional.empty();
        }
        try {
            ActiveMob activeMob = this.mythicMobs.getAPIHelper().getMythicMobInstance(entity);
            return Optional.ofNullable(activeMob);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<String> getMobType(Entity entity) {
        return this.getActiveMob(entity).map(mob -> mob.getMobType());
    }

    public void removeMob(ActiveMob activeMob) {
        if (activeMob != null && activeMob.getEntity() != null) {
            activeMob.getEntity().remove();
        }
    }

    public boolean mobTypeExists(String mobType) {
        if (!this.isInitialized()) {
            return false;
        }
        return this.mythicMobs.getMobManager().getMythicMob(mobType).isPresent();
    }

    public boolean validateRequiredMobs() {
        if (!this.isInitialized()) {
            return false;
        }
        String eventNpcType = this.plugin.getConfigManager().getEventNpcType();
        List<String> bossTypes = this.plugin.getConfigManager().getBossTypes();
        boolean valid = true;
        if (!this.mobTypeExists(eventNpcType)) {
            this.plugin.getLogger().warning("Event NPC mob type '" + eventNpcType + "' not found in MythicMobs!");
            this.plugin.getLogger().warning("Please create this mob or update 'mythicmobs.event-npc-type' in config.yml");
            valid = false;
        }
        for (String bossType : bossTypes) {
            if (this.mobTypeExists(bossType)) continue;
            this.plugin.getLogger().warning("Boss mob type '" + bossType + "' not found in MythicMobs!");
            this.plugin.getLogger().warning("Please create this mob or update 'mythicmobs.boss-types' in config.yml");
            valid = false;
        }
        return valid;
    }

    private void copyMythicMobsConfigs() {
        String[] skillFiles;
        String[] dropTableFiles;
        String[] mobFiles;
        File mythicMobsFolder = new File(this.plugin.getServer().getPluginManager().getPlugin("MythicMobs").getDataFolder(), "Mobs");
        File dropTablesFolder = new File(this.plugin.getServer().getPluginManager().getPlugin("MythicMobs").getDataFolder(), "DropTables");
        File skillsFolder = new File(this.plugin.getServer().getPluginManager().getPlugin("MythicMobs").getDataFolder(), "Skills");
        if (!mythicMobsFolder.exists()) {
            mythicMobsFolder.mkdirs();
        }
        if (!dropTablesFolder.exists()) {
            dropTablesFolder.mkdirs();
        }
        if (!skillsFolder.exists()) {
            skillsFolder.mkdirs();
        }
        for (String fileName : mobFiles = new String[]{"EventNPC.yml", "RaidBoss.yml", "TreasureChestBoss.yml", "CandyRushBoss.yml", "DefenseMobs.yml"}) {
            File targetFile = new File(mythicMobsFolder, fileName);
            if (targetFile.exists()) continue;
            try {
                InputStream inputStream = this.plugin.getResource("mythicmobs/mobs/" + fileName);
                if (inputStream != null) {
                    Files.copy(inputStream, targetFile.toPath(), new CopyOption[0]);
                    this.plugin.getLogger().info("Copied MythicMobs config: " + fileName);
                    inputStream.close();
                    continue;
                }
                this.plugin.getLogger().warning("Could not find resource: mythicmobs/mobs/" + fileName);
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to copy MythicMobs config " + fileName + ": " + e.getMessage());
            }
        }
        for (String fileName : dropTableFiles = new String[]{"CandyRushDrops.yml"}) {
            File targetFile = new File(dropTablesFolder, fileName);
            if (targetFile.exists()) continue;
            try {
                InputStream inputStream = this.plugin.getResource("mythicmobs/droptables/" + fileName);
                if (inputStream != null) {
                    Files.copy(inputStream, targetFile.toPath(), new CopyOption[0]);
                    this.plugin.getLogger().info("Copied MythicMobs drop table: " + fileName);
                    inputStream.close();
                    continue;
                }
                this.plugin.getLogger().warning("Could not find resource: mythicmobs/droptables/" + fileName);
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to copy MythicMobs drop table " + fileName + ": " + e.getMessage());
            }
        }
        for (String fileName : skillFiles = new String[]{"CandyRushSkills.yml"}) {
            File targetFile = new File(skillsFolder, fileName);
            if (targetFile.exists()) continue;
            try {
                InputStream inputStream = this.plugin.getResource("mythicmobs/skills/" + fileName);
                if (inputStream != null) {
                    Files.copy(inputStream, targetFile.toPath(), new CopyOption[0]);
                    this.plugin.getLogger().info("Copied MythicMobs skills: " + fileName);
                    inputStream.close();
                    continue;
                }
                this.plugin.getLogger().warning("Could not find resource: mythicmobs/skills/" + fileName);
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to copy MythicMobs skills " + fileName + ": " + e.getMessage());
            }
        }
        try {
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), "mm reload");
            this.plugin.getLogger().info("Reloaded MythicMobs configuration");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not reload MythicMobs: " + e.getMessage());
        }
    }

    private String formatLocation(Location loc) {
        return String.format("%.1f, %.1f, %.1f in %s", loc.getX(), loc.getY(), loc.getZ(), loc.getWorld() != null ? loc.getWorld().getName() : "unknown");
    }

    public MythicBukkit getMythicMobs() {
        return this.mythicMobs;
    }
}

