/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.listeners;

import com.candyrush.CandyRushPlugin;
import com.candyrush.utils.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerConnectionListener
implements Listener {
    private final CandyRushPlugin plugin;

    public PlayerConnectionListener(CandyRushPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.plugin.getPlayerManager().handlePlayerJoin(event.getPlayer());
        Player player = event.getPlayer();
        this.plugin.getScoreboardManager().setupScoreboard(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            String state = this.plugin.getGameManager().getCurrentState().name();
            int onlinePlayers = Bukkit.getOnlinePlayers().size();
            int minPlayers = this.plugin.getConfigManager().getMinPlayers();
            MessageUtils.sendMessage(player, "&a&l\u2501\u2501\u2501\u2501\u2501\u2501 CandyRush \u2501\u2501\u2501\u2501\u2501\u2501");
            MessageUtils.sendMessage(player, "&e\u30b2\u30fc\u30e0\u72b6\u614b: &6" + this.getStateMessage(state));
            MessageUtils.sendMessage(player, "&e\u30aa\u30f3\u30e9\u30a4\u30f3: &6" + onlinePlayers + "&7/&e\u6700\u4f4e" + minPlayers + "\u4eba");
            switch (state) {
                case "WAITING": {
                    if (onlinePlayers >= minPlayers) {
                        MessageUtils.sendMessage(player, "&a\u6700\u4f4e\u4eba\u6570\u306b\u9054\u3057\u307e\u3057\u305f\uff01\u30ab\u30a6\u30f3\u30c8\u30c0\u30a6\u30f3\u3092\u958b\u59cb\u3057\u307e\u3059...");
                        break;
                    }
                    MessageUtils.sendMessage(player, "&e\u3042\u3068&c" + (minPlayers - onlinePlayers) + "\u4eba&e\u3067\u30b2\u30fc\u30e0\u958b\u59cb");
                    break;
                }
                case "COUNTDOWN": {
                    MessageUtils.sendMessage(player, "&e\u307e\u3082\u306a\u304f\u30b2\u30fc\u30e0\u958b\u59cb\uff01");
                    break;
                }
                case "RUNNING": {
                    MessageUtils.sendMessage(player, "&a\u30b2\u30fc\u30e0\u9032\u884c\u4e2d\uff01\u53c2\u52a0\u3057\u3066\u304f\u3060\u3055\u3044");
                    this.plugin.getShopManager().giveShopItem(player);
                    break;
                }
                case "COOLDOWN": {
                    MessageUtils.sendMessage(player, "&c\u30af\u30fc\u30eb\u30c0\u30a6\u30f3\u4e2d... \u3057\u3070\u3089\u304f\u304a\u5f85\u3061\u304f\u3060\u3055\u3044");
                }
            }
            MessageUtils.sendMessage(player, "&a&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501");
            this.plugin.getGameManager().tryStartCountdown();
        }, 20L);
    }

    private String getStateMessage(String state) {
        switch (state) {
            case "WAITING": {
                return "\u5f85\u6a5f\u4e2d";
            }
            case "COUNTDOWN": {
                return "\u30ab\u30a6\u30f3\u30c8\u30c0\u30a6\u30f3\u4e2d";
            }
            case "RUNNING": {
                return "\u30b2\u30fc\u30e0\u9032\u884c\u4e2d";
            }
            case "COOLDOWN": {
                return "\u30af\u30fc\u30eb\u30c0\u30a6\u30f3\u4e2d";
            }
        }
        return state;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        int minPlayers;
        int onlinePlayers;
        this.plugin.getPlayerManager().handlePlayerQuit(event.getPlayer());
        if (this.plugin.getGameManager().getCurrentState().name().equals("COUNTDOWN") && (onlinePlayers = Bukkit.getOnlinePlayers().size() - 1) < (minPlayers = this.plugin.getConfigManager().getMinPlayers())) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getGameManager().cancelCountdown(), 5L);
        }
    }
}

